/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.item;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.item.PortalDataHolder;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.util.BackportMethods;
import net.lerariemann.infinity.util.ClientMethods;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.teleport.InfinityPortal;
import net.minecraft.BlockUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class F4Item
extends Item
implements PortalDataHolder {
    static final BlockState OBSIDIAN = Blocks.f_50080_.m_49966_();

    public F4Item(Item.Properties settings) {
        super(settings);
    }

    public static MutableComponent getDimensionTooltip(ResourceLocation dimension) {
        if (dimension == null) {
            return Component.m_237115_((String)Blocks.f_50142_.m_7705_());
        }
        String name = dimension.toString();
        MutableComponent text = InfinityMethods.getDimensionNameAsText(dimension);
        if (name.contains("infinity:generated_") || name.equals("infinity:random")) {
            return text;
        }
        return Component.m_237110_((String)"tooltip.infinity.f4", (Object[])new Object[]{text});
    }

    public static int getCharge(ItemStack f4) {
        return BackportMethods.getOrDefaultInt(f4, ModComponentTypes.F4_CHARGE, 0);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag type) {
        super.m_7373_(stack, world, tooltip, type);
        ResourceLocation dimension = BackportMethods.getDimensionIdentifier(stack);
        MutableComponent mutableText = F4Item.getDimensionTooltip(dimension);
        tooltip.add((Component)mutableText.m_130940_(ChatFormatting.GRAY));
        MutableComponent mutableText2 = Component.m_237110_((String)"tooltip.infinity.f4.charges", (Object[])new Object[]{F4Item.getCharge(stack)});
        tooltip.add((Component)mutableText2.m_130940_(ChatFormatting.GRAY));
    }

    public static ItemStack placePortal(Level world, Player player, ItemStack stack, BlockPos lowerCenter, int size_x, int size_y) {
        boolean doNotRenderPortal;
        int useCharges;
        Direction.Axis dir2 = player.m_6350_().m_175362_(Direction.Axis.Y).m_122434_();
        int charges = BackportMethods.getOrDefaultInt(stack, ModComponentTypes.F4_CHARGE, 0);
        int n = useCharges = player.m_7500_() ? 0 : 2 * (2 + size_x + size_y);
        if (charges < useCharges) {
            if (!world.m_5776_()) {
                player.m_213846_((Component)Component.m_237110_((String)"error.infinity.f4.no_charges", (Object[])new Object[]{useCharges}));
            }
            return null;
        }
        BlockPos lowerLeft = lowerCenter.m_5487_(dir2, -(size_x / 2));
        ResourceLocation id = BackportMethods.getDimensionIdentifier(stack);
        boolean bl = doNotRenderPortal = world.f_46443_ && (id == null || !id.m_135815_().contains("generated_"));
        if (PortalDataHolder.isDestinationRandom(id)) {
            id = InfinityMethods.getRandomId(world.f_46441_);
        }
        int obsNotReplaced = 0;
        for (int x = -1; x <= size_x; ++x) {
            if (!world.m_46597_(lowerLeft.m_5487_(dir2, x).m_6630_(size_y), OBSIDIAN)) {
                ++obsNotReplaced;
            }
            if (world.m_46597_(lowerLeft.m_5487_(dir2, x).m_7495_(), OBSIDIAN)) continue;
            ++obsNotReplaced;
        }
        for (int y = 0; y < size_y; ++y) {
            if (!world.m_46597_(lowerLeft.m_5487_(dir2, -1).m_5484_(Direction.UP, y), OBSIDIAN)) {
                ++obsNotReplaced;
            }
            if (!world.m_46597_(lowerLeft.m_5487_(dir2, size_x).m_5484_(Direction.UP, y), OBSIDIAN)) {
                ++obsNotReplaced;
            }
            if (doNotRenderPortal) continue;
            for (int x = 0; x < size_x; ++x) {
                BlockEntity blockEntity;
                BlockPos pos = lowerLeft.m_5487_(dir2, x).m_5484_(Direction.UP, y);
                world.m_46597_(pos, (BlockState)(id == null ? Blocks.f_50142_ : (Block)ModBlocks.PORTAL.get()).m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)dir2));
                if (id == null || !((blockEntity = world.m_7702_(pos)) instanceof InfinityPortalBlockEntity)) continue;
                InfinityPortalBlockEntity ipbe = (InfinityPortalBlockEntity)blockEntity;
                ipbe.setData(world.m_7654_(), id);
            }
        }
        world.m_5594_(player, player.m_20183_(), SoundEvents.f_11699_, SoundSource.BLOCKS, 1.0f, 0.75f);
        return BackportMethods.apply(stack, ModComponentTypes.F4_CHARGE, charges - (useCharges -= obsNotReplaced));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            ClientMethods.setF4Screen(player);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static InteractionResultHolder<ItemStack> deploy(Level world, Player player, InteractionHand hand) {
        int i;
        int lowerY;
        Direction dir = player.m_6350_();
        Direction.Axis dir2 = dir.m_175362_(Direction.Axis.Y).m_122434_();
        BlockPos lowerCenter = player.m_20183_().m_5484_(dir, 4);
        ItemStack stack = player.m_21120_(hand);
        int size_x = BackportMethods.getOrDefaultInt(stack, ModComponentTypes.SIZE_X, 3);
        int size_y = BackportMethods.getOrDefaultInt(stack, ModComponentTypes.SIZE_Y, 3);
        if (size_y % 2 == 0) {
            double d;
            double d2 = d = dir2.equals((Object)Direction.Axis.X) ? player.m_20182_().f_82479_ : player.m_20182_().f_82481_;
            if (d % 1.0 > 0.5) {
                lowerCenter = lowerCenter.m_5487_(dir2, 1);
            }
        }
        if (world.m_151562_(lowerY = lowerCenter.m_123342_())) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        boolean positionFound = true;
        for (i = 0; i <= 8 && !world.m_151562_(lowerY + i + size_y); ++i) {
            positionFound = true;
            block1: for (int j = 0; j <= size_y + 1 && positionFound; ++j) {
                for (int k = -1; k <= size_x; ++k) {
                    BlockState bs = world.m_8055_(lowerCenter.m_6630_(i + j - 1).m_5487_(dir2, k - size_x / 2));
                    if (bs.m_247087_()) continue;
                    if (bs.m_60713_(Blocks.f_50080_)) {
                        if (j == 0 || j == size_y + 1 || k == -1 || k == size_x) continue;
                        i += j - 1;
                    } else {
                        i += j;
                    }
                    positionFound = false;
                    continue block1;
                }
            }
            if (positionFound) break;
        }
        if (!positionFound) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ItemStack newStack = F4Item.placePortal(world, player, stack.m_41777_(), lowerCenter.m_6630_(i), size_x, size_y);
        if (newStack == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return InteractionResultHolder.m_19096_((Object)(player.m_7500_() ? stack : newStack));
    }

    public static boolean isPortal(BlockState state) {
        return state.m_60713_(Blocks.f_50142_) || state.m_60713_((Block)ModBlocks.PORTAL.get());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        BlockState bs = world.m_8055_(pos = context.m_8083_());
        if (bs.m_247087_()) {
            pos = pos.m_7495_();
            bs = world.m_8055_(pos);
        }
        InteractionHand hand = context.m_43724_();
        if (F4Item.isPortal(bs)) {
            ItemStack newStack = F4Item.useOnPortalBlock(world, pos, stack.m_41777_());
            if (!player.m_7500_()) {
                player.m_21008_(hand, newStack);
            }
            return InteractionResult.CONSUME;
        }
        pos = pos.m_6630_(bs.m_60713_(Blocks.f_50080_) ? 1 : 2);
        Direction.Axis dir2 = player.m_6350_().m_122434_().equals((Object)Direction.Axis.X) ? Direction.Axis.Z : Direction.Axis.X;
        int size_x = BackportMethods.getOrDefaultInt(stack, ModComponentTypes.SIZE_X, 3);
        int size_y = BackportMethods.getOrDefaultInt(stack, ModComponentTypes.SIZE_Y, 3);
        for (int j = -1; j <= size_y; ++j) {
            for (int k = -1; k <= size_x; ++k) {
                bs = world.m_8055_(pos.m_6630_(j).m_5487_(dir2, k - size_x / 2));
                if (bs.m_60713_(Blocks.f_50080_) && (j == -1 || j == size_y || k == -1 || k == size_x) || bs.m_247087_()) continue;
                return InteractionResult.FAIL;
            }
        }
        ItemStack newStack = F4Item.placePortal(world, player, context.m_43722_().m_41777_(), pos, size_x, size_y);
        if (newStack == null) {
            return InteractionResult.FAIL;
        }
        if (!player.m_7500_()) {
            player.m_21008_(hand, newStack);
        }
        return InteractionResult.CONSUME;
    }

    public static boolean checkIfValidAxis(Direction.Axis axisFound, Direction.Axis axisBeingChecked, Direction.Axis forceAxis) {
        if (forceAxis == null) {
            return axisBeingChecked.m_122478_() || axisFound.equals((Object)axisBeingChecked);
        }
        return axisFound.equals((Object)forceAxis);
    }

    public static boolean checkNeighbors(Level world, BlockPos bp, Collection<Direction> primaryOffsets, Collection<Direction> secondaryOffsets, int max, Direction.Axis forcePrimaryAxis) {
        int i = 0;
        boolean checkCorners = !secondaryOffsets.isEmpty();
        for (Direction dir : primaryOffsets) {
            Direction.Axis axisFound;
            BlockState bs = world.m_8055_(bp.m_121945_(dir));
            Direction.Axis axis = dir.m_122434_();
            if (F4Item.isPortal(bs) && F4Item.checkIfValidAxis(axisFound = (Direction.Axis)bs.m_61143_((Property)BlockStateProperties.f_61364_), axis, forcePrimaryAxis) && ++i > max) {
                return true;
            }
            if (!checkCorners || !bs.m_60713_(Blocks.f_50080_)) continue;
            Direction.Axis forceAxis = axis.m_122479_() ? axis : null;
            return F4Item.checkNeighbors(world, bp.m_121945_(dir), secondaryOffsets, Set.of(), 0, forceAxis);
        }
        return false;
    }

    public static void checkObsidianRemovalSides(Level world, BlockPos bp, Set<BlockPos> toRemove, Set<BlockPos> toLeave, Direction direction) {
        if (world.m_8055_(bp).m_60713_(Blocks.f_50080_)) {
            Set<Direction> secondaryOffsets;
            boolean bl = direction.m_122434_().m_122478_();
            Set<Direction> primaryOffsets = bl ? Set.of(direction) : Set.of(direction, direction.m_175362_(Direction.Axis.Y), direction.m_175364_(Direction.Axis.Y));
            Set<Direction> set = secondaryOffsets = bl ? Set.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST) : Set.of(Direction.UP, Direction.DOWN);
            if (F4Item.checkNeighbors(world, bp, primaryOffsets, secondaryOffsets, 0, null)) {
                toLeave.add(bp);
                return;
            }
            toRemove.add(bp);
        }
    }

    public static ItemStack useOnPortalBlock(Level world, BlockPos origin, ItemStack stack) {
        Direction.Axis axis = (Direction.Axis)world.m_8055_(origin).m_61143_((Property)NetherPortalBlock.f_54904_);
        Direction positive = axis.equals((Object)Direction.Axis.X) ? Direction.EAST : Direction.SOUTH;
        BlockUtil.FoundRectangle portal = InfinityPortal.getRect(world, origin);
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        HashSet<BlockPos> toLeave = new HashSet<BlockPos>();
        for (int i = -1; i <= portal.f_124349_; ++i) {
            F4Item.checkObsidianRemovalSides(world, portal.f_124348_.m_5487_(axis, i).m_6630_(-1), toRemove, toLeave, Direction.DOWN);
            F4Item.checkObsidianRemovalSides(world, portal.f_124348_.m_5487_(axis, i).m_6630_(portal.f_124350_), toRemove, toLeave, Direction.UP);
        }
        for (int j = -1; j <= portal.f_124350_; ++j) {
            F4Item.checkObsidianRemovalSides(world, portal.f_124348_.m_5487_(axis, -1).m_6630_(j), toRemove, toLeave, positive.m_122424_());
            F4Item.checkObsidianRemovalSides(world, portal.f_124348_.m_5487_(axis, portal.f_124349_).m_6630_(j), toRemove, toLeave, positive);
        }
        int obsidian = 0;
        for (BlockPos bp : toRemove) {
            if (toLeave.contains(bp)) continue;
            world.m_6933_(bp, Blocks.f_50016_.m_49966_(), 3, 0);
            ++obsidian;
        }
        for (int i = 0; i < portal.f_124349_; ++i) {
            for (int j = 0; j < portal.f_124350_; ++j) {
                world.m_6933_(portal.f_124348_.m_5487_(axis, i).m_6630_(j), Blocks.f_50016_.m_49966_(), 3, 0);
            }
        }
        world.m_5594_(null, origin, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 0.75f);
        return BackportMethods.apply(stack, ModComponentTypes.F4_CHARGE, F4Item.getCharge(stack) + obsidian);
    }
}

