/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.item.function;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import net.lerariemann.infinity.registry.core.ModItemFunctions;
import net.lerariemann.infinity.registry.core.ModItems;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class ChromaticColoringRecipe
implements CraftingRecipe {
    private final Ingredient input;
    private final ItemStack output;

    public ChromaticColoringRecipe(Ingredient input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingContainer input, Level world) {
        boolean foundChroma = false;
        for (int k = 0; k < input.m_280657_().size(); ++k) {
            ItemStack itemStack = input.m_8020_(k);
            if (itemStack.m_150930_((Item)ModItems.CHROMATIC_MATTER.get())) {
                if (foundChroma) {
                    return false;
                }
                foundChroma = true;
                continue;
            }
            if (itemStack.m_41619_() || this.input.test(itemStack)) continue;
            return false;
        }
        return foundChroma;
    }

    public ItemStack craft(CraftingContainer input, RegistryAccess lookup) {
        ItemStack chroma = ItemStack.f_41583_;
        int i = 0;
        for (int k = 0; k < input.m_280657_().size(); ++k) {
            ItemStack itemStack = input.m_8020_(k);
            if (itemStack.m_150930_((Item)ModItems.CHROMATIC_MATTER.get())) {
                chroma = itemStack;
                continue;
            }
            if (itemStack.m_41619_()) continue;
            ++i;
        }
        assert (!chroma.m_41619_());
        if (i > 0) {
            ItemStack result = this.output.m_255036_(i);
            result.m_41751_(chroma.m_41783_());
            return result;
        }
        return chroma.m_41720_().m_7968_();
    }

    public NonNullList<ItemStack> getRemainder(CraftingContainer craftingRecipeInput) {
        NonNullList defaultedList = NonNullList.m_122780_((int)craftingRecipeInput.m_280657_().size(), (Object)ItemStack.f_41583_);
        int j = 0;
        for (int i = 0; i < defaultedList.size(); ++i) {
            ItemStack itemStack = craftingRecipeInput.m_8020_(i);
            if (itemStack.m_150930_((Item)ModItems.CHROMATIC_MATTER.get())) {
                defaultedList.set(i, (Object)itemStack.m_255036_(1));
                continue;
            }
            if (itemStack.m_41619_()) continue;
            ++j;
        }
        return j > 0 ? defaultedList : NonNullList.m_122780_((int)craftingRecipeInput.m_280657_().size(), (Object)ItemStack.f_41583_);
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 1;
    }

    public ResourceLocation m_6423_() {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)this.output.m_41720_());
        return ResourceLocation.m_214293_((String)id.m_135827_(), (String)(id.m_135815_() + "_chromatic"));
    }

    public ItemStack m_8043_(RegistryAccess registriesLookup) {
        return this.output;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItemFunctions.CHROMATIC_COLORING.get();
    }

    public record Serializer(BiFunction<Ingredient, ItemStack, ChromaticColoringRecipe> func) implements RecipeSerializer<ChromaticColoringRecipe>
    {
        public ChromaticColoringRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"input"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            return this.func.apply(input, output);
        }

        public ChromaticColoringRecipe read(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            return this.func.apply(input, output);
        }

        public void write(FriendlyByteBuf buf, ChromaticColoringRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.m_130055_(recipe.output);
        }
    }
}

