/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.item.function;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import net.lerariemann.infinity.registry.core.ModItemFunctions;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public abstract class CollisionCraftingRecipe
implements Recipe<Container> {
    private final Ingredient input;
    private final ItemStack output;

    public CollisionCraftingRecipe(Ingredient input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public boolean m_5818_(Container input, Level world) {
        if (world.f_46443_) {
            return false;
        }
        return this.input.test(input.m_8020_(0));
    }

    public ItemStack m_5874_(Container input, RegistryAccess lookup) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registriesLookup) {
        return this.output.m_41777_();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public static class OfIridescence
    extends CollisionCraftingRecipe {
        ItemStack output;

        public OfIridescence(Ingredient input, ItemStack output) {
            super(input, output);
            this.output = output;
        }

        public ResourceLocation m_6423_() {
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)this.output.m_41720_());
            return ResourceLocation.m_214293_((String)id.m_135827_(), (String)(id.m_135815_() + "_of_iridescence"));
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)ModItemFunctions.IRIDESCENCE_CRAFTING.get();
        }

        public RecipeType<?> m_6671_() {
            return (RecipeType)ModItemFunctions.IRIDESCENCE_CRAFTING_TYPE.get();
        }
    }

    public static class OfPortal
    extends CollisionCraftingRecipe {
        ItemStack output;

        public OfPortal(Ingredient input, ItemStack output) {
            super(input, output);
            this.output = output;
        }

        public ResourceLocation m_6423_() {
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)this.output.m_41720_());
            return ResourceLocation.m_214293_((String)id.m_135827_(), (String)(id.m_135815_() + "_of_portal"));
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)ModItemFunctions.PORTAL_CRAFTING.get();
        }

        public RecipeType<?> m_6671_() {
            return (RecipeType)ModItemFunctions.PORTAL_CRAFTING_TYPE.get();
        }
    }

    public record Serializer(BiFunction<Ingredient, ItemStack, CollisionCraftingRecipe> func) implements RecipeSerializer<CollisionCraftingRecipe>
    {
        public CollisionCraftingRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"input"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            return this.func.apply(input, output);
        }

        public CollisionCraftingRecipe read(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            return this.func.apply(input, output);
        }

        public void write(FriendlyByteBuf buf, CollisionCraftingRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.m_130055_(recipe.output);
        }
    }

    public static enum Type implements RecipeType<CollisionCraftingRecipe>
    {
        PORTAL,
        IRIDESCENCE;

    }
}

