/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.item.function;

import net.lerariemann.infinity.item.F4Item;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.registry.core.ModItemFunctions;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.BackportMethods;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class F4RechargingRecipe
extends CustomRecipe {
    public F4RechargingRecipe(ResourceLocation id, CraftingBookCategory craftingRecipeCategory) {
        super(id, craftingRecipeCategory);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        boolean foundF4 = false;
        for (int k = 0; k < inventory.m_280657_().size(); ++k) {
            ItemStack itemStack = inventory.m_8020_(k);
            if (itemStack.m_150930_((Item)ModItems.F4.get())) {
                if (foundF4) {
                    return false;
                }
                foundF4 = true;
                continue;
            }
            if (itemStack.m_150930_(Items.f_41999_)) continue;
            return false;
        }
        return foundF4;
    }

    public ItemStack craft(CraftingContainer inventory, RegistryAccess registryManager) {
        ItemStack f4 = null;
        int obsidian = 0;
        for (int slot = 0; slot < inventory.m_280657_().size(); ++slot) {
            ItemStack itemStack = inventory.m_8020_(slot);
            if (itemStack.m_150930_((Item)ModItems.F4.get())) {
                f4 = itemStack;
                continue;
            }
            if (itemStack.m_41619_()) continue;
            ++obsidian;
        }
        assert (f4 != null);
        int charge = F4Item.getCharge(f4);
        if (obsidian == 0 && charge > 0) {
            return Items.f_41999_.m_7968_().m_255036_(Math.min(charge, 64));
        }
        ItemStack result = f4.m_41777_();
        return BackportMethods.apply(result, ModComponentTypes.F4_CHARGE, charge + obsidian);
    }

    public NonNullList<ItemStack> getRemainder(CraftingContainer craftingRecipeInput) {
        NonNullList defaultedList = NonNullList.m_122780_((int)craftingRecipeInput.m_280657_().size(), (Object)ItemStack.f_41583_);
        ItemStack f4 = null;
        int f4pos = 0;
        for (int i = 0; i < defaultedList.size(); ++i) {
            ItemStack itemStack = craftingRecipeInput.m_8020_(i);
            if (itemStack.m_150930_((Item)ModItems.F4.get())) {
                f4 = itemStack;
                f4pos = i;
                continue;
            }
            if (itemStack.m_41619_()) continue;
            return defaultedList;
        }
        assert (f4 != null);
        int charge = F4Item.getCharge(f4);
        if (charge == 0) {
            return defaultedList;
        }
        charge = Math.max(charge - 64, 0);
        ItemStack result = f4.m_41777_();
        BackportMethods.apply(result, ModComponentTypes.F4_CHARGE, charge);
        defaultedList.set(f4pos, (Object)result);
        return defaultedList;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItemFunctions.F4_RECHARGING.get();
    }
}

