/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.mixin.core;

import com.google.common.collect.ImmutableList;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.MinecraftServerAccess;
import net.lerariemann.infinity.compat.GravityChangerCompat;
import net.lerariemann.infinity.util.PlatformMethods;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements MinecraftServerAccess {
    @Final
    @Shadow
    private Map<ResourceKey<Level>, ServerLevel> f_129762_;
    @Final
    @Shadow
    private Executor f_129738_;
    @Final
    @Shadow
    protected LevelStorageSource.LevelStorageAccess f_129744_;
    @Final
    @Shadow
    protected WorldData f_129749_;
    @Final
    @Shadow
    private ChunkProgressListenerFactory f_129756_;
    @Unique
    public Map<ResourceKey<Level>, ServerLevel> infinity$worldsToAdd;
    @Unique
    public boolean infinity$needsInvocation;

    @Shadow
    public ServerLevel m_129880_(ResourceKey<Level> key) {
        return null;
    }

    @Shadow
    protected TickTask m_6681_(Runnable runnable) {
        return null;
    }

    @Shadow
    public abstract RegistryAccess.Frozen m_206579_();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void injected(CallbackInfo info) {
        this.infinity$worldsToAdd = new HashMap<ResourceKey<Level>, ServerLevel>();
        this.infinity$needsInvocation = !Files.exists(InfinityMod.invocationLock, new LinkOption[0]);
        InfinityMod.LOGGER.info("Invocation {}", (Object)(this.infinity$needsInvocation ? "needed..." : "not needed"));
        if (!this.infinity$needsInvocation) {
            this.infinity$setDimensionProvider();
        }
    }

    @Override
    public boolean infinity$needsInvocation() {
        return this.infinity$needsInvocation;
    }

    @Override
    public void infinity$onInvocation() {
        this.infinity$needsInvocation = false;
        try {
            Path p = InfinityMod.invocationLock;
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.copy(InfinityMod.rootConfigPathInJar.resolve(".util/invocation.lock"), p, StandardCopyOption.REPLACE_EXISTING);
            }
            this.infinity$setDimensionProvider();
            InfinityMod.LOGGER.info("Invocation complete");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void infinity$setDimensionProvider() {
        InfinityMod.updateProvider((MinecraftServer)this);
    }

    @Override
    public void infinity$addWorld(ResourceKey<Level> key, LevelStem options) {
        ServerLevelData serverWorldProperties = this.f_129749_.m_5996_();
        ServerLevel world = new ServerLevel((MinecraftServer)this, this.f_129738_, this.f_129744_, serverWorldProperties, key, options, this.f_129756_.m_9620_(11), this.f_129749_.m_7513_(), BiomeManager.m_47877_((long)this.f_129749_.m_246337_().m_245499_()), (List)ImmutableList.of(), false, this.m_129880_((ResourceKey<Level>)Level.f_46428_).m_288231_());
        this.m_129880_((ResourceKey<Level>)Level.f_46428_).m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(world.m_6857_()));
        this.infinity$worldsToAdd.put(key, world);
        ((MinecraftServer)this).m_6937_((Runnable)this.m_6681_(() -> {
            this.f_129762_.put(key, world);
            this.infinity$worldsToAdd.clear();
        }));
        if (Platform.isModLoaded((String)"gravity_changer_q")) {
            GravityChangerCompat.changeMavity(world);
        }
        PlatformMethods.onWorldLoad(this, world);
    }

    @Override
    public boolean infinity$hasToAdd(ResourceKey<Level> key) {
        return this.infinity$worldsToAdd.containsKey(key);
    }

    @Redirect(method={"createWorlds"}, at=@At(value="NEW", target="(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorage$Session;Lnet/minecraft/world/level/ServerWorldProperties;Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/world/dimension/DimensionOptions;Lnet/minecraft/server/WorldGenerationProgressListener;ZJLjava/util/List;ZLnet/minecraft/util/math/random/RandomSequencesState;)Lnet/minecraft/server/world/ServerWorld;"))
    public ServerLevel create(MinecraftServer server, Executor workerExecutor, LevelStorageSource.LevelStorageAccess session, ServerLevelData properties, ResourceKey<Level> worldKey, LevelStem dimensionOptions, ChunkProgressListener worldGenerationProgressListener, boolean debugWorld, long seed, List<CustomSpawner> spawners, boolean shouldTickTime, RandomSequences randomSequencesState) {
        ServerLevelData prop = worldKey.m_135782_().toString().contains("infinity") ? this.f_129749_.m_5996_() : properties;
        return new ServerLevel(server, workerExecutor, session, prop, worldKey, dimensionOptions, worldGenerationProgressListener, debugWorld, seed, spawners, shouldTickTime, randomSequencesState);
    }
}

