/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.mixin.core;

import java.util.Random;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.mixin.core.AbstractBlockMixin;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.teleport.PortalCreator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetherPortalBlock.class})
public class NetherPortalBlockMixin
extends AbstractBlockMixin {
    @Shadow
    @Final
    public static EnumProperty<Direction.Axis> f_54904_;

    @Inject(at={@At(value="HEAD")}, method={"onEntityCollision(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)V"})
    private void injected(BlockState state, Level world, BlockPos pos, Entity entity, CallbackInfo info) {
        if (world instanceof ServerLevel) {
            ServerLevel w = (ServerLevel)world;
            if (entity instanceof ItemEntity) {
                ItemEntity e = (ItemEntity)entity;
                PortalCreator.tryCreatePortalFromItem((Level)w, pos, e);
            }
        }
    }

    @Redirect(method={"getStateForNeighborUpdate(Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/Direction;Lnet/minecraft/block/BlockState;Lnet/minecraft/world/WorldAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;isOf(Lnet/minecraft/block/Block;)Z"))
    private boolean injected(BlockState neighborState, Block block) {
        return neighborState.m_60734_() instanceof NetherPortalBlock;
    }

    @Override
    protected void injected_onBlockAdded(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify, CallbackInfo ci) {
        if (state.m_60713_(Blocks.f_50142_) && (RandomProvider.rule("randomizeAllNetherPortals") || InfinityMethods.isInfinity(world))) {
            world.m_186460_(pos, Blocks.f_50142_, 2);
        }
    }

    @Override
    protected void injected_scheduledTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (state.m_60713_(Blocks.f_50142_)) {
            boolean bl = RandomProvider.rule("randomizeAllNetherPortals");
            if (!bl && !InfinityMethods.isInfinity((Level)world)) {
                return;
            }
            world.m_46597_(pos, (BlockState)((Block)ModBlocks.PORTAL.get()).m_49966_().m_61124_(f_54904_, (Comparable)((Direction.Axis)state.m_61143_(f_54904_))));
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof InfinityPortalBlockEntity) {
                InfinityPortalBlockEntity ipbe = (InfinityPortalBlockEntity)blockEntity;
                if (bl) {
                    long l = InfinityMethods.getRandomSeed(new Random(world.m_46467_()));
                    ipbe.setDimension(l);
                } else {
                    ipbe.setOpen(true);
                }
            }
        }
    }
}

