/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.mixin.core;

import com.mojang.authlib.GameProfile;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.lerariemann.infinity.access.ServerPlayerEntityAccess;
import net.lerariemann.infinity.access.Timebombable;
import net.lerariemann.infinity.options.InfinityOptions;
import net.lerariemann.infinity.registry.var.ModPayloads;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.teleport.WarpLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
extends Player
implements ServerPlayerEntityAccess {
    @Shadow
    public ServerGamePacketListenerImpl f_8906_;
    @Shadow
    private int f_8920_;
    @Shadow
    private float f_8917_;
    @Shadow
    private int f_8918_;
    @Unique
    private long infinity$ticksUntilWarp;
    @Unique
    private ResourceLocation infinity$idForWarp;

    public ServerPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Shadow
    public abstract ServerLevel m_284548_();

    @Shadow
    public abstract boolean m_264318_(ServerLevel var1, double var2, double var4, double var6, Set<RelativeMovement> var8, float var9, float var10);

    @Shadow
    public abstract boolean m_6469_(DamageSource var1, float var2);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        InfinityOptions.access((Level)this.m_9236_()).effect.tryGiveEffect(player);
        if (--this.infinity$ticksUntilWarp == 0L) {
            WarpLogic.performWarp(player, this.infinity$idForWarp);
        }
        ((Timebombable)this.m_284548_()).tickTimebombProgress(player);
    }

    @Inject(method={"changeGameMode"}, at={@At(value="RETURN")})
    private void injected4(GameType gameMode, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer player = (ServerPlayer)this;
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            ModPayloads.sendReloadPacket(player, player.m_284548_());
        }
    }

    @Inject(method={"teleport(Lnet/minecraft/server/world/ServerWorld;DDDFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;sendCommandTree(Lnet/minecraft/server/network/ServerPlayerEntity;)V")})
    private void injected5(ServerLevel targetWorld, double x, double y, double z, float yaw, float pitch, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        ModPayloads.sendReloadPacket(player, targetWorld);
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPayloads.STARS_RELOAD, (FriendlyByteBuf)PlatformMethods.createPacketByteBufs());
        this.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(this.m_150110_()));
        for (MobEffectInstance effect : this.m_21220_()) {
            this.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(this.m_19879_(), effect));
        }
        this.f_8920_ = -1;
        this.f_8917_ = -1.0f;
        this.f_8918_ = -1;
    }

    @Override
    public void infinity$setWarpTimer(long ticks, ResourceLocation dim) {
        this.infinity$ticksUntilWarp = ticks;
        this.infinity$idForWarp = dim;
    }
}

