/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.mixin.fixes;

import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.teleport.InfinityPortal;
import net.lerariemann.infinity.util.teleport.PortalCreator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.PortalInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    protected BlockPos f_19819_;

    @Shadow
    public abstract Level m_9236_();

    @ModifyArg(method={"tickPortal()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;moveToWorld(Lnet/minecraft/server/world/ServerWorld;)Lnet/minecraft/entity/Entity;"))
    private ServerLevel injected(ServerLevel originalWorldTo) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel worldFrom = (ServerLevel)level;
            BlockPos pos = this.f_19819_;
            BlockEntity blockEntity = worldFrom.m_7702_(pos);
            if (blockEntity instanceof InfinityPortalBlockEntity) {
                InfinityPortalBlockEntity portal = (InfinityPortalBlockEntity)blockEntity;
                ResourceKey keyTo = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)portal.getDimension());
                ServerLevel worldTo = worldFrom.m_7654_().m_129880_(keyTo);
                return InfinityMethods.dimExists(worldTo) && portal.isOpen() ? worldTo : worldFrom;
            }
            if (worldFrom.m_8055_(pos).m_60713_(Blocks.f_50142_) && InfinityMethods.isInfinity((Level)worldFrom)) {
                PortalCreator.modifyPortalRecursive(worldFrom, pos, Level.f_46428_.m_135782_(), true);
                return worldFrom.m_7654_().m_129783_();
            }
            return originalWorldTo;
        }
        return originalWorldTo;
    }

    @Inject(method={"getTeleportTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void injected(ServerLevel destination, CallbackInfoReturnable<PortalInfo> cir) {
        BlockPos posFrom;
        ServerLevel worldFrom;
        BlockEntity blockEntity;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && (blockEntity = (worldFrom = (ServerLevel)level).m_7702_(posFrom = this.f_19819_)) instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity ipbe = (InfinityPortalBlockEntity)blockEntity;
            cir.setReturnValue((Object)new InfinityPortal(ipbe, worldFrom, posFrom).getTeleportTarget((Entity)this));
        }
    }

    @Inject(method={"updateMovementInFluid"}, at={@At(value="RETURN")}, cancellable=true)
    void inj(TagKey<Fluid> tag, double speed, CallbackInfoReturnable<Boolean> cir) {
        if (tag.equals((Object)FluidTags.f_13131_) && PlatformMethods.acidTest((Entity)this, false)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isSubmergedIn"}, at={@At(value="RETURN")}, cancellable=true)
    void inj(TagKey<Fluid> fluidTag, CallbackInfoReturnable<Boolean> cir) {
        if (fluidTag.equals((Object)FluidTags.f_13131_) && PlatformMethods.acidTest((Entity)this, true)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getFluidHeight"}, at={@At(value="RETURN")}, cancellable=true)
    void inj2(TagKey<Fluid> fluid, CallbackInfoReturnable<Double> cir) {
        if (fluid.equals((Object)FluidTags.f_13131_)) {
            cir.setReturnValue((Object)Math.max((Double)cir.getReturnValue(), PlatformMethods.acidHeightTest((Entity)this)));
        }
    }
}

