/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.mixin.options;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.lerariemann.infinity.access.InfinityOptionsAccess;
import net.lerariemann.infinity.access.Timebombable;
import net.lerariemann.infinity.options.InfinityOptions;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerWorldMixin
extends Level
implements WorldGenLevel,
InfinityOptionsAccess,
Timebombable {
    @Unique
    public InfinityOptions infinity$options;
    @Unique
    public int infinity$timebombProgress;

    protected ServerWorldMixin(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void injected(MinecraftServer server, Executor workerExecutor, LevelStorageSource.LevelStorageAccess session, ServerLevelData properties, ResourceKey<Level> worldKey, LevelStem dimensionOptions, ChunkProgressListener worldGenerationProgressListener, boolean debugWorld, long seed, List<CustomSpawner> spawners, boolean shouldTickTime, RandomSequences randomSequencesState, CallbackInfo ci) {
        this.infinity$options = InfinityOptions.generate(server, worldKey.m_135782_());
        DimensionType t = this.m_6042_();
        ((InfinityOptionsAccess)t).infinity$setOptions(this.infinity$options);
        this.infinity$timebombProgress = 0;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void injected2(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        if (InfinityMethods.isInfinity((ResourceKey<Level>)this.m_46472_()) && this.infinity$timebombProgress > 0) {
            ++this.infinity$timebombProgress;
        }
    }

    @ModifyExpressionValue(method={"tickWeather"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$Key;)Z")})
    private boolean mev(boolean original) {
        return original && !InfinityMethods.isInfinity((ResourceKey<Level>)this.m_46472_());
    }

    @ModifyExpressionValue(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/ChunkSection;hasRandomTicks()Z")})
    boolean mev2(boolean original, @Local LevelChunkSection cs) {
        return original || this.infinity$options.isHaunted() && !cs.m_188008_();
    }

    @Inject(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/fluid/FluidState;hasRandomTicks()Z")})
    void inj(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci, @Local BlockState bs, @Local BlockPos blockPos2, @Local FluidState fs) {
        if (this.infinity$options.isHaunted() && this.f_46441_.m_188503_(200) < (int)Math.floor(this.m_46940_() * 4.0f) && bs.m_61138_((Property)BlockStateProperties.f_61424_)) {
            this.m_46597_(blockPos2, (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61424_, (Comparable)Integer.valueOf(this.f_46441_.m_188503_(24))));
        }
    }

    @Override
    public void infinity$timebomb() {
        if (InfinityMethods.isInfinity((ResourceKey<Level>)this.m_46472_())) {
            this.infinity$timebombProgress = 1;
        }
    }

    @Override
    public boolean infinity$tryRestore() {
        if (InfinityMethods.isInfinity((ResourceKey<Level>)this.m_46472_()) && this.infinity$timebombProgress > Timebombable.getCooldownTicks()) {
            this.infinity$timebombProgress = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean infinity$isTimebombed() {
        return this.infinity$timebombProgress > 0;
    }

    @Override
    public int infinity$getTimebombProgress() {
        return this.infinity$timebombProgress;
    }

    @Override
    public InfinityOptions infinity$getOptions() {
        return InfinityOptions.nullSafe(this.infinity$options);
    }

    @Override
    public void infinity$setOptions(InfinityOptions options) {
        this.infinity$options = options;
    }
}

