/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.options;

import java.io.File;
import java.util.function.Function;
import net.lerariemann.infinity.access.InfinityOptionsAccess;
import net.lerariemann.infinity.options.EffectGiver;
import net.lerariemann.infinity.options.IridescentMap;
import net.lerariemann.infinity.options.PitchShifter;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.joml.Vector3f;

public class InfinityOptions {
    public CompoundTag data;
    public PitchShifter shifter;
    public EffectGiver effect;
    public IridescentMap iridMap;
    public static CompoundTag defaultShader = new CompoundTag();

    public InfinityOptions(CompoundTag data) {
        this.data = data;
        this.shifter = PitchShifter.decode(NbtUtils.test(data, "pitch_shift", new CompoundTag()));
        this.effect = EffectGiver.of(NbtUtils.test(data, "effect", new CompoundTag()));
        this.iridMap = IridescentMap.decode(NbtUtils.test(data, "iridescent_map", new CompoundTag()));
    }

    public CompoundTag data() {
        return this.data;
    }

    public static InfinityOptions empty() {
        return new InfinityOptions(new CompoundTag());
    }

    public static CompoundTag readData(MinecraftServer server, ResourceLocation worldId) {
        if (worldId.m_135827_().equals("infinity")) {
            String name = worldId.m_135815_();
            File f = server.m_129843_(LevelResource.f_78180_).resolve(name + "/data/infinity/options.json").toFile();
            if (f.exists()) {
                return CommonIO.read(f);
            }
        }
        return new CompoundTag();
    }

    public static InfinityOptions generate(MinecraftServer server, ResourceLocation worldId) {
        return new InfinityOptions(InfinityOptions.readData(server, worldId));
    }

    public static InfinityOptions access(Level world) {
        return ((InfinityOptionsAccess)world).infinity$getOptions();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static InfinityOptions ofClient() {
        return InfinityOptions.ofClient(Minecraft.m_91087_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static InfinityOptions ofClient(Minecraft client) {
        return ((InfinityOptionsAccess)client).infinity$getOptions();
    }

    public static InfinityOptions nullSafe(InfinityOptions options) {
        return options != null ? options : InfinityOptions.empty();
    }

    public boolean isEmpty() {
        return this.data.m_128456_();
    }

    public CompoundTag getShader() {
        LogManager.getLogger().info((Object)defaultShader);
        return NbtUtils.test(this.data, "shader", defaultShader);
    }

    public double getTimeScale() {
        return NbtUtils.test(this.data, "time_scale", 1.0);
    }

    public double getMavity() {
        return NbtUtils.test(this.data, "mavity", 1.0);
    }

    public Function<Float, Float> getSoundPitch() {
        return this.shifter.applier();
    }

    public boolean isHaunted() {
        return NbtUtils.test(this.data, "haunted", false);
    }

    public int getHauntingTicks(RandomSource random) {
        if (!this.isHaunted()) {
            return -2;
        }
        if (this.data.m_128441_("haunting_ticks")) {
            return this.data.m_128451_("haunting_ticks");
        }
        return random.m_216332_(NbtUtils.test(this.data, "min_haunting_ticks", 20), NbtUtils.test(this.data, "max_haunting_ticks", 200));
    }

    public String getSkyType() {
        return NbtUtils.test(this.data, "sky_type", "empty");
    }

    public float getHorizonShadingRatio() {
        return NbtUtils.test(this.data, "horizon_shading_ratio", 1.0f);
    }

    public boolean endSkyLike() {
        return NbtUtils.test(this.data, "end_sky_like", false);
    }

    public boolean hasDawn() {
        return NbtUtils.test(this.data, "dawn", !this.getSkyType().equals("rainbow"));
    }

    public float getSolarSize() {
        return NbtUtils.test(this.data, "solar_size", 30.0f);
    }

    public float getSolarTilt() {
        return NbtUtils.test(this.data, "solar_tilt", -90.0f);
    }

    public Vector3f getSolarTint() {
        int color = NbtUtils.test(this.data, "solar_tint", 0xFFFFFF);
        return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public ResourceLocation getSolarTexture() {
        return new ResourceLocation(NbtUtils.test(this.data, "solar_texture", "textures/environment/sun.png"));
    }

    public int getNumStars() {
        return NbtUtils.test(this.data, "num_stars", 1500);
    }

    public float getStarSizeBase() {
        return NbtUtils.test(this.data, "star_size_base", 0.15f);
    }

    public float getStarSizeModifier() {
        return NbtUtils.test(this.data, "star_size_modifier", 0.1f);
    }

    public float getStellarTiltY() {
        return NbtUtils.test(this.data, "stellar_tilt_y", -90.0f);
    }

    public float getStellarTiltZ() {
        return NbtUtils.test(this.data, "stellar_tilt_z", 0.0f);
    }

    public float getStellarVelocity() {
        return NbtUtils.test(this.data, "stellar_velocity", 1.0f);
    }

    public float getDayStarBrightness() {
        return NbtUtils.test(this.data, "star_brightness_day", 0.0f);
    }

    public float getNightStarBrightness() {
        return NbtUtils.test(this.data, "star_brightness_night", 0.5f);
    }

    public Vector3f getStellarColor() {
        int color = NbtUtils.test(this.data, "stellar_color", 0xFFFFFF);
        return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public boolean isMoonCustom() {
        return this.data.m_128441_("lunar_texture");
    }

    public int getNumMoons() {
        return this.data.m_128441_("moons") ? this.data.m_128437_("moons", 10).size() : 1;
    }

    public boolean lunarTest(String key, int i) {
        return this.data.m_128441_("moons") && ((CompoundTag)this.data.m_128437_("moons", 10).get(i)).m_128441_(key);
    }

    public float fullLunarTest(String key, int i, float def) {
        return this.lunarTest(key, i) ? ((CompoundTag)this.data.m_128437_("moons", 10).get(i)).m_128457_(key) : def;
    }

    public float getLunarSize(int i) {
        return this.fullLunarTest("lunar_size", i, 20.0f);
    }

    public float getLunarTiltY(int i) {
        return this.fullLunarTest("lunar_tilt_y", i, -90.0f);
    }

    public float getLunarTiltZ(int i) {
        return this.fullLunarTest("lunar_tilt_z", i, 0.0f);
    }

    public Vector3f getLunarTint(int i) {
        int color = this.lunarTest("lunar_tint", i) ? ((CompoundTag)this.data.m_128437_("moons", 10).get(i)).m_128451_("lunar_tint") : 0xFFFFFF;
        return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public ResourceLocation getLunarTexture(int i) {
        return new ResourceLocation(this.lunarTest("lunar_texture", i) ? ((CompoundTag)this.data.m_128437_("moons", 10).get(i)).m_128461_("lunar_texture") : "textures/environment/moon_phases.png");
    }

    public float getLunarVelocity(int i) {
        return this.fullLunarTest("lunar_velocity", i, 1.0f);
    }

    public float getLunarOffset(int i) {
        return this.fullLunarTest("lunar_offset", i, 0.0f);
    }
}

