/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.options;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;

public interface PitchShifter {
    public Function<Float, Float> applier();

    public static PitchShifter decode(CompoundTag comp) {
        return switch (comp.m_128461_("type")) {
            case "constant" -> new Constant(PitchShifter.getFloat(comp, "value"));
            case "add" -> new Add(PitchShifter.getFloat(comp, "value"));
            default -> Empty.INSTANCE;
        };
    }

    public static float getFloat(CompoundTag comp, String s) {
        if (!comp.m_128425_(s, 5)) {
            return 1.0f;
        }
        return comp.m_128457_(s);
    }

    public record Constant(float value) implements PitchShifter
    {
        @Override
        public Function<Float, Float> applier() {
            return f -> Float.valueOf(this.value);
        }
    }

    public record Add(float value) implements PitchShifter
    {
        @Override
        public Function<Float, Float> applier() {
            return f -> Float.valueOf(f.floatValue() + this.value);
        }
    }

    public static enum Empty implements PitchShifter
    {
        INSTANCE;


        @Override
        public Function<Float, Float> applier() {
            return Function.identity();
        }
    }
}

