/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.options;

import java.awt.Color;
import java.util.Random;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.options.InfinityOptions;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;

public interface PortalColorApplier {
    public static PortalColorApplier of(ResourceLocation id, MinecraftServer server) {
        return PortalColorApplier.of(id, InfinityOptions.readData(server, id));
    }

    public static PortalColorApplier of(ResourceLocation id, CompoundTag defaultData) {
        CompoundTag data = InfinityMod.provider.easterizer.optionmap.get(id.m_135815_());
        if (data == null) {
            data = defaultData;
        }
        return PortalColorApplier.of(data, (int)InfinityMethods.getNumericFromId(id));
    }

    public static PortalColorApplier of(CompoundTag data, int defaultColor) {
        if (!data.m_128441_("portal_color")) {
            return new Simple(defaultColor);
        }
        if (data.m_128425_("portal_color", 3)) {
            return new Simple(data.m_128451_("portal_color"));
        }
        CompoundTag applierData = data.m_128469_("portal_color");
        return switch (applierData.m_128461_("type")) {
            case "simple" -> new Simple(applierData.m_128451_("value"));
            case "checker" -> new Checker(applierData.m_128437_("values", 3));
            case "random_hue" -> new RandomHue(applierData);
            case "random" -> RandomColor.INSTANCE;
            default -> new Simple(defaultColor);
        };
    }

    public int apply(BlockPos var1);

    public record Simple(int value) implements PortalColorApplier
    {
        @Override
        public int apply(BlockPos pos) {
            return this.value;
        }
    }

    public record Checker(ListTag values) implements PortalColorApplier
    {
        @Override
        public int apply(BlockPos pos) {
            int mod = InfinityMethods.properMod(pos.m_123341_() + pos.m_123342_() + pos.m_123343_(), this.values.size());
            return this.values.m_128763_(mod);
        }
    }

    public record RandomHue(float saturation, float brightness, float detail) implements PortalColorApplier
    {
        public RandomHue(CompoundTag applierData) {
            this(NbtUtils.test(applierData, "saturation", 1.0f), NbtUtils.test(applierData, "brightness", 1.0f), NbtUtils.test(applierData, "detail", 12.0f));
        }

        @Override
        public int apply(BlockPos pos) {
            float hue = (float)(pos.m_123341_() + pos.m_123342_() + pos.m_123343_()) / this.detail;
            return Color.HSBtoRGB(hue - (float)((int)hue), this.saturation, this.brightness) & 0xFFFFFF;
        }
    }

    public static enum RandomColor implements PortalColorApplier
    {
        INSTANCE;


        @Override
        public int apply(BlockPos pos) {
            return new Random(pos.hashCode()).nextInt();
        }
    }
}

