/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.options;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RandomInfinityOptions {
    CompoundTag data = new CompoundTag();
    String path;

    public RandomInfinityOptions(RandomDimension parent, boolean isEasterDim) {
        CompoundTag effect;
        this.path = parent.getStoragePath();
        RandomProvider prov = parent.PROVIDER;
        if (isEasterDim && prov.easterizer.optionmap.containsKey(parent.getName())) {
            this.data = prov.easterizer.optionmap.get(parent.getName());
        }
        if (isEasterDim) {
            return;
        }
        Random r = parent.random;
        CompoundTag shader = new CompoundTag();
        if (prov.roll(r, "use_shaders")) {
            Object[] lst = RandomInfinityOptions.genMatrix(r);
            shader = CommonIO.readAndFormat(String.valueOf(InfinityMod.utilPath) + "/shader.json", lst);
        }
        this.data.m_128365_("shader", (Tag)shader);
        this.data.m_128350_("solar_size", (float)(30.0 * r.nextExponential()));
        this.data.m_128350_("solar_tilt", (float)(360.0 * r.nextDouble() - 180.0));
        int moons = r.nextInt(1, 9);
        ListTag moonslist = new ListTag();
        for (int i = 0; i < moons; ++i) {
            CompoundTag moon = new CompoundTag();
            moon.m_128350_("lunar_size", (float)(20.0 * r.nextExponential()));
            moon.m_128350_("lunar_offset", (float)r.nextDouble());
            moon.m_128350_("lunar_velocity", (float)(r.nextDouble() * 4.0 - 2.0));
            moon.m_128350_("lunar_tilt_y", (float)(r.nextDouble() * 180.0 - 90.0));
            moon.m_128350_("lunar_tilt_z", (float)(r.nextDouble() * 180.0 - 90.0));
            moon.m_128405_("lunar_tint", r.nextInt(0x1000000));
            moonslist.add((Object)moon);
        }
        this.data.m_128365_("moons", (Tag)moonslist);
        this.data.m_128405_("num_stars", r.nextInt(1000, 4000));
        this.data.m_128350_("star_size_base", (float)(0.1 + r.nextDouble() * 0.3));
        this.data.m_128350_("star_size_modifier", (float)(0.03 * r.nextExponential()));
        this.data.m_128350_("stellar_velocity", (float)(r.nextDouble() * 4.0 - 2.0));
        this.data.m_128350_("stellar_tilt_y", (float)(r.nextDouble() * 180.0 - 90.0));
        this.data.m_128350_("stellar_tilt_z", (float)(r.nextDouble() * 180.0 - 90.0));
        float a = r.nextFloat();
        float b = r.nextFloat();
        this.data.m_128350_("star_brightness_day", Math.min(a, b));
        this.data.m_128350_("star_brightness_night", Math.max(a, b));
        this.data.m_128347_("time_scale", RandomInfinityOptions.timeScale(r));
        this.data.m_128347_("mavity", prov.roll(r, "use_mavity") ? RandomInfinityOptions.mavity(r) : 1.0);
        if (prov.roll(r, "pitch_shift")) {
            this.data.m_128365_("pitch_shift", (Tag)RandomInfinityOptions.pitchShift(r));
        }
        if (prov.roll(r, "give_effect") && !(effect = RandomInfinityOptions.effect(r, prov)).m_128456_()) {
            this.data.m_128365_("effect", (Tag)effect);
        }
        this.data.m_128365_("iridescent_map", (Tag)RandomInfinityOptions.iridMap(r));
    }

    public static double timeScale(Random r) {
        double d = r.nextDouble();
        if (d < 0.1) {
            return r.nextDouble();
        }
        if (d < 0.5) {
            return 1.0;
        }
        if (d < 0.95) {
            return r.nextExponential() * 3.0;
        }
        return r.nextExponential() * 30.0;
    }

    public static double mavity(Random r) {
        double d = r.nextDouble();
        if (d < 0.8) {
            return r.nextDouble();
        }
        return 1.0 / (0.95 * r.nextDouble() + 0.05);
    }

    public void save() {
        CommonIO.write(this.data, this.path, "options.json");
    }

    static Object[] genMatrix(Random r) {
        ArrayList<Float> points = new ArrayList<Float>();
        float scale = 2.0f + r.nextFloat();
        points.add(Float.valueOf(0.0f));
        points.add(Float.valueOf(scale));
        for (int i = 0; i < 8; ++i) {
            points.add(Float.valueOf(scale * r.nextFloat()));
        }
        Collections.sort(points);
        Object[] res = new Object[9];
        for (int i = 0; i < 9; ++i) {
            res[i] = Float.valueOf(((Float)points.get(i + 1)).floatValue() - ((Float)points.get(i)).floatValue());
        }
        return res;
    }

    public static CompoundTag pitchShift(Random r) {
        CompoundTag comp = new CompoundTag();
        int i = r.nextInt(0, 2);
        switch (i) {
            case 0: {
                comp.m_128359_("type", "constant");
                comp.m_128350_("value", r.nextFloat(0.5f, 2.0f));
                return comp;
            }
            case 1: {
                comp.m_128359_("type", "add");
                comp.m_128350_("value", r.nextFloat(-1.0f, 1.0f));
                return comp;
            }
        }
        return comp;
    }

    public static CompoundTag effect(Random r, RandomProvider provider) {
        CompoundTag res = new CompoundTag();
        CompoundTag effect = provider.randomElement(r, "effects");
        if (effect.m_128471_("Instant")) {
            return new CompoundTag();
        }
        int amplifier = Math.min(5, (int)(0.5 * r.nextExponential()));
        res.m_128359_("id", effect.m_128461_("Name"));
        res.m_128405_("amplifier", amplifier);
        return res;
    }

    public static CompoundTag iridMap(Random r) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", switch (r.nextInt(4)) {
            case 0 -> "static";
            case 1 -> "linear";
            case 2 -> "circles";
            default -> "noise";
        });
        return res;
    }
}

