/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.options;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import net.lerariemann.infinity.options.InfinityOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public record SkyRenderer(InfinityOptions options, Minecraft client, ClientLevel world, PoseStack matrices, Tesselator tessellator, float tickDelta, Matrix4f projectionMatrix, VertexBuffer lightSkyBuffer, VertexBuffer starsBuffer) {
    public SkyRenderer(InfinityOptions options, Minecraft client, ClientLevel world, PoseStack matrices, float tickDelta, Matrix4f projectionMatrix, VertexBuffer lightSkyBuffer, VertexBuffer starsBuffer) {
        this(options, client, world, matrices, Tesselator.m_85913_(), tickDelta, projectionMatrix, lightSkyBuffer, starsBuffer);
    }

    public static boolean testCameraCancels(Camera camera) {
        FogType cameraSubmersionType = camera.m_167685_();
        return cameraSubmersionType == FogType.POWDER_SNOW || cameraSubmersionType == FogType.LAVA;
    }

    public void render(Runnable fogCallback) {
        if (this.testAndRenderNonOverworldySkies()) {
            return;
        }
        this.setupOverworldySky();
        this.renderAllCelestialBodies(fogCallback);
        this.finish();
    }

    public boolean testAndRenderNonOverworldySkies() {
        if (this.client.f_91073_ != null && this.client.f_91073_.m_104583_().m_108883_() == DimensionSpecialEffects.SkyType.END) {
            this.renderSkybox(new ResourceLocation("textures/environment/end_sky.png"), 16.0f, 40, 255);
            return true;
        }
        if (this.options.endSkyLike()) {
            this.handleSkyBackground();
            return true;
        }
        return this.client.f_91073_ != null && this.client.f_91073_.m_104583_().m_108883_() != DimensionSpecialEffects.SkyType.NORMAL;
    }

    public void setupOverworldySky() {
        FogRenderer.m_109036_();
        RenderSystem.depthMask((boolean)false);
        this.handleSkyBackground();
        this.handleFog();
        this.matrices.m_85836_();
    }

    public void handleSkyBackground() {
        String skyType = this.options.getSkyType();
        if (skyType.equals("rainbow")) {
            this.renderRainbowBackground();
        } else {
            Vec3 vec3d = this.world.m_171660_(this.client.f_91063_.m_109153_().m_90583_(), this.tickDelta);
            this.renderSingleColorBackground((float)vec3d.f_82479_, (float)vec3d.f_82480_, (float)vec3d.f_82481_, 1.0f);
        }
    }

    public void renderRainbowBackground() {
        float main = this.world.m_46942_(this.tickDelta) * 2.0f;
        int color = Color.getHSBColor(main - (float)((int)main), 1.0f, 1.0f).getRGB();
        float f = Mth.m_14036_((float)(Mth.m_14089_((float)(this.world.m_46942_(this.tickDelta) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        this.renderSingleColorBackground(f * (float)(color >> 16 & 0xFF) / 255.0f, f * (float)(color >> 8 & 0xFF) / 255.0f, f * (float)(color & 0xFF) / 255.0f, 1.0f);
    }

    public void renderSingleColorBackground(float f, float g, float h, float a) {
        RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)a);
        this.lightSkyBuffer.m_85921_();
        this.lightSkyBuffer.m_253207_(this.matrices.m_85850_().m_252922_(), this.projectionMatrix, RenderSystem.getShader());
        VertexBuffer.m_85931_();
    }

    public void handleFog() {
        RenderSystem.enableBlend();
        float[] fs = this.world.m_104583_().m_7518_(this.world.m_46942_(this.tickDelta), this.tickDelta);
        if (fs != null && this.options().hasDawn()) {
            this.handleSunriseFog(fs);
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public void handleSunriseFog(float[] fs) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.matrices.m_85836_();
        this.matrices.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        float i = Mth.m_14031_((float)this.world.m_46490_(this.tickDelta)) < 0.0f ? 180.0f : 0.0f;
        this.matrices.m_252781_(Axis.f_252403_.m_252977_(i - this.options.getSolarTilt()));
        Matrix4f matrix4f = this.matrices.m_85850_().m_252922_();
        BufferBuilder bufferBuilder = this.tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(fs[0], fs[1], fs[2], fs[3]);
        for (int n = 0; n <= 16; ++n) {
            float o = (float)n * ((float)Math.PI * 2) / 16.0f;
            float p = Mth.m_14031_((float)o);
            float q = Mth.m_14089_((float)o);
            bufferBuilder.m_252986_(matrix4f, p * 120.0f, q * 120.0f, -q * 40.0f * fs[3]).m_85950_(fs[0], fs[1], fs[2], 0.0f);
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        this.matrices.m_85849_();
    }

    public void renderAllCelestialBodies(Runnable fogCallback) {
        float rain_alpha = 1.0f - this.world.m_46722_(this.tickDelta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)rain_alpha);
        this.renderSun();
        for (int i = 0; i < this.options.getNumMoons(); ++i) {
            this.renderMoon(i);
        }
        this.renderStars(fogCallback, rain_alpha);
    }

    public void finish() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        this.matrices.m_85849_();
        RenderSystem.depthMask((boolean)true);
    }

    public void rotate_with_velocity(float v, float offset) {
        this.matrices.m_252781_(Axis.f_252529_.m_252977_((this.world.m_46942_(this.tickDelta) + offset) * 360.0f * v));
    }

    public void renderSun() {
        this.renderSingleBody(this.options.getSolarSize(), this.options.getSolarTilt(), 0.0f, 1.0f, 0.0f, this.options.getSolarTint(), this.options.getSolarTexture(), true);
    }

    public void renderMoon(int i) {
        this.renderSingleBody(this.options.getLunarSize(i), this.options.getLunarTiltY(i), this.options.getLunarTiltZ(i), this.options.getLunarVelocity(i), this.options.getLunarOffset(i), this.options.getLunarTint(i), this.options.getLunarTexture(i), false);
    }

    public void renderSingleBody(float size, float tilt_y, float tilt_z, float velocity, float offset, Vector3f tint, ResourceLocation texture, boolean sun) {
        this.matrices.m_252781_(Axis.f_252436_.m_252977_(tilt_y));
        this.matrices.m_252781_(Axis.f_252403_.m_252977_(tilt_z));
        this.rotate_with_velocity(velocity, offset);
        if (sun) {
            this.renderSun(this.matrices.m_85850_().m_252922_(), texture, size, 100.0f, tint);
        } else {
            this.renderMoon(this.matrices.m_85850_().m_252922_(), texture, size, -100.0f, tint);
        }
        this.rotate_with_velocity(-1.0f * velocity, offset);
        this.matrices.m_252781_(Axis.f_252403_.m_252977_(-tilt_z));
        this.matrices.m_252781_(Axis.f_252436_.m_252977_(-tilt_y));
    }

    public void renderSun(Matrix4f matrix4f2, ResourceLocation texture, float k, float y, Vector3f tint) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)tint.x, (float)tint.y, (float)tint.z, (float)1.0f);
        BufferBuilder bufferBuilder = this.tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f2, -k, y, -k).m_7421_(0.0f, 0.0f);
        bufferBuilder.m_252986_(matrix4f2, k, y, -k).m_7421_(1.0f, 0.0f);
        bufferBuilder.m_252986_(matrix4f2, k, y, k).m_7421_(1.0f, 1.0f);
        bufferBuilder.m_252986_(matrix4f2, -k, y, k).m_7421_(0.0f, 1.0f);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public void renderMoon(Matrix4f matrix4f2, ResourceLocation texture, float k, float y, Vector3f tint) {
        float q;
        float p;
        float o;
        float t;
        if (!this.options.isMoonCustom()) {
            int moon_phase = this.world.m_46941_();
            int s = moon_phase % 4;
            int m = moon_phase / 4 % 2;
            t = (float)s / 4.0f;
            o = (float)m / 2.0f;
            p = (float)(s + 1) / 4.0f;
            q = (float)(m + 1) / 2.0f;
        } else {
            q = 1.0f;
            t = 1.0f;
            o = 0.0f;
            p = 0.0f;
        }
        this.renderMoon(matrix4f2, texture, k, y, tint, t, q, p, o);
    }

    public void renderMoon(Matrix4f matrix4f2, ResourceLocation texture, float k, float y, Vector3f tint, float t, float q, float p, float o) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)tint.x, (float)tint.y, (float)tint.z, (float)1.0f);
        BufferBuilder bufferBuilder = this.tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f2, -k, y, k).m_7421_(p, q);
        bufferBuilder.m_252986_(matrix4f2, k, y, k).m_7421_(t, q);
        bufferBuilder.m_252986_(matrix4f2, k, y, -k).m_7421_(t, o);
        bufferBuilder.m_252986_(matrix4f2, -k, y, -k).m_7421_(p, o);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public void renderStars(Runnable fogCallback, float rain_alpha) {
        this.renderStars(this.options.getStellarTiltY(), this.options.getStellarTiltZ(), this.options.getStellarVelocity(), 0.0f, fogCallback, rain_alpha);
    }

    public void renderStars(float tilt_y, float tilt_z, float velocity, float offset, Runnable fogCallback, float rain_alpha) {
        this.matrices.m_252781_(Axis.f_252436_.m_252977_(tilt_y));
        this.matrices.m_252781_(Axis.f_252403_.m_252977_(tilt_z));
        this.rotate_with_velocity(velocity, offset);
        this.renderStars(this.matrices.m_85850_().m_252922_(), this.projectionMatrix, fogCallback, rain_alpha);
        this.rotate_with_velocity(-1.0f * velocity, offset);
        this.matrices.m_252781_(Axis.f_252403_.m_252977_(-tilt_z));
        this.matrices.m_252781_(Axis.f_252436_.m_252977_(-tilt_y));
    }

    public void renderStars(Matrix4f matrix4f2, Matrix4f projectionMatrix, Runnable fogCallback, float rain_alpha) {
        float u = this.world.m_104811_(this.tickDelta) * rain_alpha;
        Vector3f color = this.options.getStellarColor();
        if (u > 0.0f) {
            RenderSystem.setShaderColor((float)(u * color.x), (float)(u * color.y), (float)(u * color.z), (float)u);
            FogRenderer.m_109017_();
            this.starsBuffer.m_85921_();
            this.starsBuffer.m_253207_(matrix4f2, projectionMatrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            fogCallback.run();
        }
    }

    public float getStarBrightness(float tickDelta) {
        float f = this.world.m_46942_(tickDelta);
        float g = 1.0f - (Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        float day = this.options.getDayStarBrightness();
        float night = this.options.getNightStarBrightness();
        return day + g * g * (night - day);
    }

    public void renderSkybox(ResourceLocation texture, float copies, int brightness, int alpha) {
        this.renderSkybox(texture, copies, brightness, brightness, brightness, alpha);
    }

    public void renderSkybox(ResourceLocation texture, float copies, int r, int g, int b, int alpha) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Tesselator tessellator = Tesselator.m_85913_();
        for (int i = 0; i < 6; ++i) {
            this.matrices.m_85836_();
            if (i == 1) {
                this.matrices.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
            if (i == 2) {
                this.matrices.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
            if (i == 3) {
                this.matrices.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            }
            if (i == 4) {
                this.matrices.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            if (i == 5) {
                this.matrices.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            }
            Matrix4f matrix4f = this.matrices.m_85850_().m_252922_();
            BufferBuilder bufferBuilder = tessellator.m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferBuilder.m_252986_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_6122_(r, g, b, alpha);
            bufferBuilder.m_252986_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, copies).m_6122_(r, g, b, alpha);
            bufferBuilder.m_252986_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(copies, copies).m_6122_(r, g, b, alpha);
            bufferBuilder.m_252986_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(copies, 0.0f).m_6122_(r, g, b, alpha);
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            this.matrices.m_85849_();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }
}

