/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.core;

import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.lerariemann.infinity.entity.client.AntModel;
import net.lerariemann.infinity.entity.client.AntRenderer;
import net.lerariemann.infinity.entity.client.BishopModel;
import net.lerariemann.infinity.entity.client.BishopRenderer;
import net.lerariemann.infinity.entity.client.ChaosCreeperRenderer;
import net.lerariemann.infinity.entity.client.ChaosPawnRenderer;
import net.lerariemann.infinity.entity.client.ChaosSkeletonRenderer;
import net.lerariemann.infinity.entity.client.ChaosSlimeRenderer;
import net.lerariemann.infinity.entity.custom.AbstractChessFigure;
import net.lerariemann.infinity.entity.custom.AntEntity;
import net.lerariemann.infinity.entity.custom.BishopEntity;
import net.lerariemann.infinity.entity.custom.ChaosCreeper;
import net.lerariemann.infinity.entity.custom.ChaosPawn;
import net.lerariemann.infinity.entity.custom.ChaosSkeleton;
import net.lerariemann.infinity.entity.custom.ChaosSlime;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> INFINITY_ENTITIES = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<EntityType<ChaosSlime>> CHAOS_SLIME = INFINITY_ENTITIES.register("chaos_slime", () -> FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, ChaosSlime::new).dimensions(EntityDimensions.m_20395_((float)0.52f, (float)0.52f)).trackRangeBlocks(10).build());
    public static final RegistrySupplier<EntityType<ChaosSkeleton>> CHAOS_SKELETON = INFINITY_ENTITIES.register("chaos_skeleton", () -> EntityType.Builder.m_20704_(ChaosSkeleton::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8).m_20712_("chaos_skeleton"));
    public static final RegistrySupplier<EntityType<ChaosCreeper>> CHAOS_CREEPER = INFINITY_ENTITIES.register("chaos_creeper", () -> EntityType.Builder.m_20704_(ChaosCreeper::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.7f).m_20702_(8).m_20712_(ModEntities.type("chaos_creeper")));
    public static final RegistrySupplier<EntityType<ChaosPawn>> CHAOS_PAWN = INFINITY_ENTITIES.register("chaos_pawn", () -> EntityType.Builder.m_20704_(ChaosPawn::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 2.0f).m_20702_(10).m_20712_("chaos_pawn"));
    public static final RegistrySupplier<EntityType<AntEntity>> ANT = INFINITY_ENTITIES.register("ant", () -> EntityType.Builder.m_20704_(AntEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 0.3f).m_20702_(10).m_20712_(ModEntities.type("ant")));
    public static final RegistrySupplier<EntityType<BishopEntity>> BISHOP = INFINITY_ENTITIES.register("bishop", () -> EntityType.Builder.m_20704_(BishopEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 2.7f).m_20702_(10).m_20712_(ModEntities.type("bishop")));

    public static void copy(Mob from, Mob e) {
        e.m_7678_(from.m_20185_(), from.m_20186_(), from.m_20189_(), from.m_146908_(), from.m_146909_());
        e.m_21153_(from.m_21223_());
        e.f_20883_ = from.f_20883_;
        if (from.m_8077_()) {
            e.m_6593_(from.m_7770_());
            e.m_20340_(from.m_20151_());
        }
        if (from.m_21532_()) {
            e.m_21530_();
        }
        e.m_20331_(from.m_20147_());
        e.m_21008_(InteractionHand.MAIN_HAND, from.m_21120_(InteractionHand.MAIN_HAND));
        e.m_21008_(InteractionHand.OFF_HAND, from.m_21120_(InteractionHand.OFF_HAND));
    }

    public static void registerEntities() {
        INFINITY_ENTITIES.register();
        ModEntities.registerAttributes();
    }

    public static String type(String id) {
        return "infinity:" + id;
    }

    public static void registerAttributes() {
        EntityAttributeRegistry.register(CHAOS_SLIME, ChaosSlime::createAttributes);
        EntityAttributeRegistry.register(CHAOS_SKELETON, AbstractSkeleton::m_32166_);
        EntityAttributeRegistry.register(CHAOS_CREEPER, Creeper::m_32318_);
        EntityAttributeRegistry.register(CHAOS_PAWN, ChaosPawn::createAttributes);
        EntityAttributeRegistry.register(ANT, AntEntity::createAttributes);
        EntityAttributeRegistry.register(BISHOP, BishopEntity::createAttributes);
    }

    public static <T extends Mob> void registerSafe(EntityType<T> type, SpawnPlacements.Type location, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
        if (!SpawnPlacements.f_21750_.containsKey(type)) {
            SpawnPlacements.m_21754_(type, (SpawnPlacements.Type)location, (Heightmap.Types)heightmapType, predicate);
        }
    }

    public static void registerSpawnRestrictions() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)CHAOS_SLIME.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChaosSlime::canSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CHAOS_SKELETON.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::canChaosMonsterSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CHAOS_CREEPER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::canChaosMonsterSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CHAOS_PAWN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::canChessFigureSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ANT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::canChessFigureSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)BISHOP.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModEntities::canChessFigureSpawn);
        ModEntities.registerSafe(EntityType.f_271264_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_);
        ModEntities.registerSafe(EntityType.f_243976_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_);
        ModEntities.registerSafe(EntityType.f_20500_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
    }

    public static boolean canChaosMonsterSpawn(EntityType<? extends Monster> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return Monster.m_219013_(type, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && InfinityMethods.chaosMobsEnabled();
    }

    public static boolean canChessFigureSpawn(EntityType<? extends AbstractChessFigure> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return Mob.m_217057_(type, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && world.m_46791_() != Difficulty.PEACEFUL && InfinityMethods.chaosMobsEnabled();
    }

    public static void registerEntityRenderers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)AntModel.MODEL_LAYER, AntModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)BishopModel.MODEL_LAYER, BishopModel::getTexturedModelData);
        EntityRendererRegistry.register(CHAOS_SLIME, ChaosSlimeRenderer::new);
        EntityRendererRegistry.register(CHAOS_SKELETON, ChaosSkeletonRenderer::new);
        EntityRendererRegistry.register(CHAOS_CREEPER, ChaosCreeperRenderer::new);
        EntityRendererRegistry.register(CHAOS_PAWN, ChaosPawnRenderer::new);
        EntityRendererRegistry.register(ANT, AntRenderer::new);
        EntityRendererRegistry.register(BISHOP, BishopRenderer::new);
    }
}

