/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.core;

import com.mojang.serialization.Codec;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.features.RandomCeilingBlobFeature;
import net.lerariemann.infinity.features.RandomColumnsFeature;
import net.lerariemann.infinity.features.RandomCubeFeature;
import net.lerariemann.infinity.features.RandomDungeonFeature;
import net.lerariemann.infinity.features.RandomEndIslandFeature;
import net.lerariemann.infinity.features.RandomFlatMushroomFeature;
import net.lerariemann.infinity.features.RandomMushroomFeature;
import net.lerariemann.infinity.features.RandomPortalSetupper;
import net.lerariemann.infinity.features.RandomRoundMushroomFeature;
import net.lerariemann.infinity.features.RandomShapeFeature;
import net.lerariemann.infinity.features.TextFeature;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class ModFeatures {
    public static RegistrySupplier<RandomEndIslandFeature> RANDOM_END_ISLAND;
    public static RegistrySupplier<RandomDungeonFeature> RANDOM_DUNGEON;
    public static RegistrySupplier<RandomColumnsFeature> RANDOM_COLUMNS;
    public static RegistrySupplier<RandomFlatMushroomFeature> RANDOM_FLAT_MUSHROOM;
    public static RegistrySupplier<RandomRoundMushroomFeature> RANDOM_ROUND_MUSHROOM;
    public static RegistrySupplier<RandomCeilingBlobFeature> RANDOM_CEILING_BLOB;
    public static RegistrySupplier<RandomCubeFeature> RANDOM_CUBE;
    public static RegistrySupplier<RandomShapeFeature> RANDOM_STAR;
    public static RegistrySupplier<TextFeature> RANDOM_TEXT;
    public static RegistrySupplier<RandomPortalSetupper> PORTAL_SETUPPER;
    public static final DeferredRegister<Feature<?>> FEATURES;

    public static <C extends FeatureConfiguration, F extends Feature<C>> RegistrySupplier<F> register(String name, F feature) {
        return FEATURES.register(name, () -> feature);
    }

    public static void registerFeatures() {
        InfinityMod.LOGGER.debug("Registering features for infinity");
        RANDOM_END_ISLAND = ModFeatures.register("random_end_island", new RandomEndIslandFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.f_67546_));
        RANDOM_DUNGEON = ModFeatures.register("random_dungeon", new RandomDungeonFeature(RandomDungeonFeature.Config.CODEC));
        RANDOM_COLUMNS = ModFeatures.register("random_columns", new RandomColumnsFeature(RandomColumnsFeature.Config.CODEC));
        RANDOM_FLAT_MUSHROOM = ModFeatures.register("random_flat_mushroom", new RandomFlatMushroomFeature(RandomMushroomFeature.Config.CODEC));
        RANDOM_ROUND_MUSHROOM = ModFeatures.register("random_round_mushroom", new RandomRoundMushroomFeature(RandomMushroomFeature.Config.CODEC));
        RANDOM_CEILING_BLOB = ModFeatures.register("random_ceiling_blob", new RandomCeilingBlobFeature(RandomCeilingBlobFeature.Config.CODEC));
        RANDOM_CUBE = ModFeatures.register("random_cube", new RandomCubeFeature(RandomCubeFeature.Config.CODEC));
        RANDOM_STAR = ModFeatures.register("random_shape", new RandomShapeFeature(RandomShapeFeature.Config.CODEC));
        RANDOM_TEXT = ModFeatures.register("random_text", new TextFeature(TextFeature.Config.CODEC));
        PORTAL_SETUPPER = ModFeatures.register("portal_setupper", new RandomPortalSetupper(RandomPortalSetupper.Config.CODEC));
        FEATURES.register();
    }

    static {
        FEATURES = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256833_);
    }
}

