/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.core;

import dev.architectury.registry.item.ItemPropertiesRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import net.lerariemann.infinity.block.custom.BiomeBottleBlock;
import net.lerariemann.infinity.item.function.BiomeBottleCombiningRecipe;
import net.lerariemann.infinity.item.function.ChromaticColoringRecipe;
import net.lerariemann.infinity.item.function.CollisionCraftingRecipe;
import net.lerariemann.infinity.item.function.F4RechargingRecipe;
import net.lerariemann.infinity.options.InfinityOptions;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.BackportMethods;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ModItemFunctions {
    public static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTION_TYPES = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_257015_);
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256764_);
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256954_);
    public static RegistrySupplier<RecipeSerializer<BiomeBottleCombiningRecipe>> BIOME_BOTTLE_COMBINING = RECIPE_SERIALIZERS.register("biome_bottle_combining", () -> new SimpleCraftingRecipeSerializer(BiomeBottleCombiningRecipe::new));
    public static RegistrySupplier<RecipeSerializer<F4RechargingRecipe>> F4_RECHARGING = RECIPE_SERIALIZERS.register("f4_recharging", () -> new SimpleCraftingRecipeSerializer(F4RechargingRecipe::new));
    public static RegistrySupplier<RecipeSerializer<ChromaticColoringRecipe>> CHROMATIC_COLORING = RECIPE_SERIALIZERS.register("chromatic_coloring", () -> new ChromaticColoringRecipe.Serializer(ChromaticColoringRecipe::new));
    public static RegistrySupplier<RecipeSerializer<CollisionCraftingRecipe>> PORTAL_CRAFTING = RECIPE_SERIALIZERS.register("collision_portal", () -> new CollisionCraftingRecipe.Serializer(CollisionCraftingRecipe.OfPortal::new));
    public static RegistrySupplier<RecipeSerializer<CollisionCraftingRecipe>> IRIDESCENCE_CRAFTING = RECIPE_SERIALIZERS.register("collision_iridescence", () -> new CollisionCraftingRecipe.Serializer(CollisionCraftingRecipe.OfIridescence::new));
    public static RegistrySupplier<RecipeType<CollisionCraftingRecipe>> PORTAL_CRAFTING_TYPE = RECIPE_TYPES.register("collision_portal", () -> CollisionCraftingRecipe.Type.PORTAL);
    public static RegistrySupplier<RecipeType<CollisionCraftingRecipe>> IRIDESCENCE_CRAFTING_TYPE = RECIPE_TYPES.register("collision_iridescence", () -> CollisionCraftingRecipe.Type.IRIDESCENCE);

    public static void registerItemFunctions() {
        LOOT_FUNCTION_TYPES.register();
        RECIPE_SERIALIZERS.register();
        RECIPE_TYPES.register();
    }

    public static void registerDispenserBehaviour() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.IRIDESCENCE_BUCKET.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack m_7498_(BlockSource pointer, ItemStack stack) {
                DispensibleContainerItem fluidModificationItem = (DispensibleContainerItem)stack.m_41720_();
                BlockPos blockPos = pointer.m_7961_().m_121945_((Direction)pointer.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel world = pointer.m_7727_();
                if (fluidModificationItem.m_142073_(null, (Level)world, blockPos, null)) {
                    fluidModificationItem.m_142131_(null, (Level)world, stack, blockPos);
                    return stack.getRecipeRemainder();
                }
                return new DefaultDispenseItemBehavior().m_6115_(pointer, stack);
            }
        });
    }

    public static void checkCollisionRecipes(ServerLevel w, ItemEntity itemEntity, RecipeType<CollisionCraftingRecipe> recipeType, CompoundTag compound) {
        if (itemEntity.m_213877_()) {
            return;
        }
        final ItemStack itemStack = itemEntity.m_32055_();
        Optional match = w.m_7465_().m_44015_(recipeType, (Container)new ContainerSingleItem(){

            public ItemStack m_8020_(int slot) {
                return itemStack;
            }

            public ItemStack m_7407_(int slot, int amount) {
                return null;
            }

            public void m_6836_(int slot, ItemStack stack) {
            }

            public void m_6596_() {
            }

            public boolean m_6542_(Player player) {
                return false;
            }
        }, (Level)w);
        if (match.isEmpty()) {
            return;
        }
        ItemStack resStack = ((CollisionCraftingRecipe)match.get()).m_8043_(w.m_9598_());
        resStack.m_41751_(compound);
        Vec3 v = itemEntity.m_20184_();
        ItemEntity result = new ItemEntity((Level)w, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), resStack.m_255036_(itemEntity.m_32055_().m_41613_()), -v.f_82479_, -v.f_82480_, -v.f_82481_);
        w.m_7967_((Entity)result);
        itemEntity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public static float iridPredicate(@Nullable ItemStack stack, ClientLevel world, @Nullable LivingEntity entity, int seed) {
        if (entity == null) {
            return 0.0f;
        }
        return (float)InfinityOptions.access((Level)world).iridMap.getColor(entity.m_20183_()) / 100.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerModelPredicates() {
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItems.TRANSFINITE_KEY.get()), (ResourceLocation)InfinityMethods.getId("key"), (stack, world, entity, seed) -> {
            String id = stack.m_41783_() != null ? stack.m_41783_().m_128461_("key_destination") : "minecraft:random";
            if (id == null) {
                return 0.0f;
            }
            if (id.contains("infinity:generated_")) {
                return 0.01f;
            }
            return switch (id) {
                case "minecraft:random" -> 0.02f;
                case "minecraft:the_end" -> 0.03f;
                case "infinity:pride" -> 0.04f;
                default -> 0.0f;
            };
        });
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItems.BIOME_BOTTLE_ITEM.get()), (ResourceLocation)InfinityMethods.getId("bottle"), (stack, world, entity, seed) -> {
            int charge = BiomeBottleBlock.getCharge(stack);
            return Mth.m_14036_((float)((float)charge / 1000.0f), (float)0.0f, (float)1.0f);
        });
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItems.IRIDESCENT_CARPET.get()), (ResourceLocation)InfinityMethods.getId("iridescent"), ModItemFunctions::iridPredicate);
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItems.IRIDESCENT_WOOL.get()), (ResourceLocation)InfinityMethods.getId("iridescent"), ModItemFunctions::iridPredicate);
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItems.F4.get()), (ResourceLocation)InfinityMethods.getId("f4"), (stack, world, entity, seed) -> {
            ResourceLocation id = BackportMethods.getDimensionIdentifier(stack);
            if (id == null) {
                return 0.0f;
            }
            if (id.toString().equals("infinity:random")) {
                return 0.02f;
            }
            return 0.01f;
        });
    }
}

