/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.core;

import dev.architectury.core.item.ArchitecturyBucketItem;
import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.item.BiomeBottleItem;
import net.lerariemann.infinity.item.ChromaticBlockItem;
import net.lerariemann.infinity.item.ChromaticItem;
import net.lerariemann.infinity.item.F4Item;
import net.lerariemann.infinity.item.GlintItem;
import net.lerariemann.infinity.item.HomeItem;
import net.lerariemann.infinity.item.IridescentPotionItem;
import net.lerariemann.infinity.item.StarOfLangItem;
import net.lerariemann.infinity.item.TransfiniteKeyItem;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256913_);
    public static final RegistrySupplier<Item> PORTAL_ITEM = ITEMS.register(ModBlocks.PORTAL.getId(), () -> new BlockItem((Block)ModBlocks.PORTAL.get(), new Item.Properties()));
    public static final RegistrySupplier<Item> COSMIC_ALTAR_ITEM = ModItems.registerBlockItemAfter(ModBlocks.COSMIC_ALTAR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_, Items.f_42774_, BlockItem::new);
    public static final RegistrySupplier<Item> ALTAR_ITEM = ModItems.registerBlockItemAfter(ModBlocks.ALTAR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_, Items.f_42774_, BlockItem::new);
    public static final RegistrySupplier<Item> ANT_ITEM = ModItems.registerBlockItemAfter(ModBlocks.ANT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_, Items.f_42790_, BlockItem::new);
    public static final RegistrySupplier<Item> BOOK_BOX_ITEM = ModItems.registerBlockItemAfter(ModBlocks.BOOK_BOX, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_, Items.f_244640_, BlockItem::new);
    public static final RegistrySupplier<Item> CURSOR_ITEM = ModItems.registerBlockItemAfter(ModBlocks.CURSOR, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_, Items.f_42169_, BlockItem::new);
    public static final RegistrySupplier<Item> NETHERITE_SLAB_ITEM = ModItems.registerBlockItemAfter(ModBlocks.NETHERITE_SLAB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, Items.f_42791_, BlockItem::new);
    public static final RegistrySupplier<Item> NETHERITE_STAIRS_ITEM = ModItems.registerBlockItemAfter(ModBlocks.NETHERITE_STAIRS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, Items.f_42791_, BlockItem::new);
    public static final RegistrySupplier<Item> NOTES_BLOCK_ITEM = ModItems.registerBlockItemAfter(ModBlocks.NOTES_BLOCK, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_, Items.f_41859_, BlockItem::new);
    public static final RegistrySupplier<Item> TIME_BOMB_ITEM = ModItems.registerBlockItemAfter(ModBlocks.TIME_BOMB, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_, Items.f_42065_, BlockItem::new);
    public static final RegistrySupplier<Item> IRIDESCENT_WOOL = ModItems.registerBlockItemAfter(ModBlocks.IRIDESCENT_WOOL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_, Items.f_41876_, BlockItem::new);
    public static final RegistrySupplier<Item> IRIDESCENT_CARPET = ModItems.registerBlockItemAfter(ModBlocks.IRIDESCENT_CARPET, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_, Items.f_42136_, BlockItem::new);
    public static final RegistrySupplier<ChromaticBlockItem> CHROMATIC_WOOL = ModItems.registerBlockItemAfter(ModBlocks.CHROMATIC_WOOL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_, Items.f_41876_, new Item.Properties(), ChromaticBlockItem::new);
    public static final RegistrySupplier<ChromaticBlockItem> CHROMATIC_CARPET = ModItems.registerBlockItemAfter(ModBlocks.CHROMATIC_CARPET, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_, Items.f_42136_, new Item.Properties(), ChromaticBlockItem::new);
    public static final RegistrySupplier<Item> BIOME_BOTTLE_ITEM = ModItems.registerBlockItemAfter(ModBlocks.BIOME_BOTTLE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, Items.f_42612_, BiomeBottleItem::new);
    public static final RegistrySupplier<Item> CHAOS_CREEPER_SPAWN_EGG = ITEMS.register("chaos_creeper_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.CHAOS_CREEPER, 9551193, 7907327, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<Item> CHAOS_SKELETON_SPAWN_EGG = ITEMS.register("chaos_skeleton_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.CHAOS_SKELETON, 15978425, 8889187, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<Item> CHAOS_SLIME_SPAWN_EGG = ITEMS.register("chaos_slime_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.CHAOS_SLIME, 0xFF66FF, 0xAA77DD, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<Item> CHAOS_PAWN_SPAWN_EGG = ITEMS.register("chaos_pawn_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.CHAOS_PAWN, 0x222222, 0xFFFFFF, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<Item> ANT_SPAWN_EGG = ITEMS.register("ant_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.ANT, 0x444444, 0xFFFFFF, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<Item> BISHOP_SPAWN_EGG = ITEMS.register("bishop_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.BISHOP, 0, 0xFFFFFF, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<Item> IRIDESCENCE_BUCKET = ITEMS.register("iridescence_bucket", () -> new ArchitecturyBucketItem(PlatformMethods.getIridescenceStill(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistrySupplier<Item> FOOTPRINT = ModItems.registerItemAfter("footprint", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, Items.f_220218_, Item::new);
    public static final RegistrySupplier<TransfiniteKeyItem> TRANSFINITE_KEY = ModItems.registerItemAfter("key", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, Items.f_151049_, TransfiniteKeyItem::new);
    public static final RegistrySupplier<HomeItem> HOME_ITEM = ModItems.registerItemAfter("fine_item", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, Items.f_42455_, HomeItem::new, new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().m_38767_()));
    public static final RegistrySupplier<ChromaticItem> CHROMATIC_MATTER = ModItems.registerItemAfter("chromatic_matter", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, Items.f_220218_, ChromaticItem::new, new Item.Properties());
    public static final RegistrySupplier<Item> WHITE_MATTER = ModItems.registerItemAfter("white_matter", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, Items.f_220218_, Item::new);
    public static final RegistrySupplier<Item> BLACK_MATTER = ModItems.registerItemAfter("black_matter", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, Items.f_220218_, Item::new);
    public static final RegistrySupplier<Item> IRIDESCENT_STAR = ModItems.registerItemAfter("iridescent_star", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, Items.f_42686_, GlintItem::new, new Item.Properties().m_41497_(Rarity.UNCOMMON));
    public static final RegistrySupplier<? extends StarOfLangItem> STAR_OF_LANG = ModItems.registerItemAfter("star_of_lang", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_, Items.f_42686_, PlatformMethods.getStarOfLangConstructor(), new Item.Properties());
    public static final RegistrySupplier<F4Item> F4 = ModItems.registerItemAfter("f4", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_, Items.f_42614_, F4Item::new, new Item.Properties().m_41497_(Rarity.UNCOMMON));
    public static final RegistrySupplier<Item> IRIDESCENT_POTION = ModItems.registerItemAfter("iridescent_potion", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256839_, Items.f_42787_, s -> new IridescentPotionItem((Item.Properties)s, 4), new Item.Properties());
    public static final RegistrySupplier<Item> CHROMATIC_POTION = ModItems.registerItemAfter("chromatic_potion", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256839_, Items.f_42787_, s -> new IridescentPotionItem((Item.Properties)s, 0), new Item.Properties());

    public static <T extends Item> RegistrySupplier<T> register(String item, Item.Properties settings, Function<Item.Properties, T> constructor) {
        return ITEMS.register(item, () -> (Item)constructor.apply(settings));
    }

    public static <T extends Item> RegistrySupplier<T> registerItemAfter(String id, ResourceKey<CreativeModeTab> group, Item item, Function<Item.Properties, T> constructor, Item.Properties settings) {
        RegistrySupplier<T> registeredItem = ModItems.register(id, ModItems.addFallbackTab(settings, group), constructor);
        PlatformMethods.addAfter(registeredItem, group, item);
        return registeredItem;
    }

    public static <T extends Item> RegistrySupplier<T> registerItemAfter(String id, ResourceKey<CreativeModeTab> group, Item item, Function<Item.Properties, T> constructor) {
        return ModItems.registerItemAfter(id, group, item, constructor, new Item.Properties());
    }

    public static <T extends Item> RegistrySupplier<T> registerBlockItem(RegistrySupplier<Block> block, Item.Properties settings, BiFunction<Block, Item.Properties, T> constructor) {
        return ITEMS.register(block.getId(), () -> (Item)constructor.apply((Block)block.get(), settings));
    }

    public static <T extends Item> RegistrySupplier<T> registerBlockItemAfter(RegistrySupplier<Block> block, ResourceKey<CreativeModeTab> group, Item item, Item.Properties settings, BiFunction<Block, Item.Properties, T> constructor) {
        RegistrySupplier<T> registeredItem = ModItems.registerBlockItem(block, ModItems.addFallbackTab(settings, group), constructor);
        PlatformMethods.addAfter(registeredItem, group, item);
        return registeredItem;
    }

    public static <T extends Item> RegistrySupplier<T> registerBlockItemAfter(RegistrySupplier<Block> block, ResourceKey<CreativeModeTab> group, Item item, BiFunction<Block, Item.Properties, T> constructor) {
        return ModItems.registerBlockItemAfter(block, group, item, new Item.Properties(), constructor);
    }

    public static Item.Properties addFallbackTab(Item.Properties settings, ResourceKey<CreativeModeTab> group) {
        if (!InfinityMethods.isFabricApiLoaded("fabric-item-group-api-v1")) {
            return settings.arch$tab(group);
        }
        return settings;
    }

    public static Item.Properties createSpawnEggSettings() {
        return new Item.Properties().arch$tab(CreativeModeTabs.f_256731_);
    }

    public static void registerModItems() {
        PlatformMethods.addAfter(IRIDESCENCE_BUCKET, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_, Items.f_42455_);
        InfinityMod.LOGGER.debug("Registering items for infinity");
        ITEMS.register();
    }
}

