/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.core;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.structure.LetterPiece;
import net.lerariemann.infinity.structure.PyramidGenerator;
import net.lerariemann.infinity.structure.PyramidStructure;
import net.lerariemann.infinity.structure.SetupperStructure;
import net.lerariemann.infinity.structure.TextStructure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class ModStructureTypes {
    public static RegistrySupplier<StructurePieceType> PYRAMID_PIECE;
    public static RegistrySupplier<StructurePieceType> LETTER;
    public static RegistrySupplier<StructureType<PyramidStructure>> PYRAMID;
    public static RegistrySupplier<StructureType<SetupperStructure>> SETUPPER;
    public static RegistrySupplier<StructureType<TextStructure>> TEXT;
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES;
    public static final DeferredRegister<StructurePieceType> STRUCTURE_PIECES;

    private static RegistrySupplier<StructurePieceType> register(StructurePieceType.ContextlessType type, String id) {
        return ModStructureTypes.register((StructurePieceType)type, id);
    }

    private static RegistrySupplier<StructurePieceType> register(StructurePieceType type, String id) {
        return STRUCTURE_PIECES.register(id, () -> type);
    }

    public static void registerStructures() {
        InfinityMod.LOGGER.debug("Registering processors for infinity");
        PYRAMID = STRUCTURE_TYPES.register("pyramid", () -> () -> PyramidStructure.CODEC.codec());
        SETUPPER = STRUCTURE_TYPES.register("setupper", () -> () -> SetupperStructure.CODEC.codec());
        TEXT = STRUCTURE_TYPES.register("text", () -> () -> TextStructure.CODEC.codec());
        PYRAMID_PIECE = ModStructureTypes.register(PyramidGenerator::new, "pypiece");
        LETTER = ModStructureTypes.register(LetterPiece::new, "letter");
        STRUCTURE_PIECES.register();
        STRUCTURE_TYPES.register();
    }

    static {
        STRUCTURE_TYPES = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256938_);
        STRUCTURE_PIECES = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256786_);
    }
}

