/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.var;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.lerariemann.infinity.block.entity.BiomeBottleBlockEntity;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ModCriteria {
    public static DimensionOpenedCriterion DIMS_OPENED;
    public static DimensionClosedCriterion DIMS_CLOSED;
    public static WhoRemainsCriterion WHO_REMAINS;
    public static IridescentCriterion IRIDESCENT;
    public static BiomeBottleCriterion BIOME_BOTTLE;
    public static ConvertMobCriterion CONVERT_MOB;

    public static void registerCriteria() {
        DIMS_OPENED = (DimensionOpenedCriterion)CriteriaTriggers.m_10595_((CriterionTrigger)new DimensionOpenedCriterion());
        DIMS_CLOSED = (DimensionClosedCriterion)CriteriaTriggers.m_10595_((CriterionTrigger)new DimensionClosedCriterion());
        WHO_REMAINS = (WhoRemainsCriterion)CriteriaTriggers.m_10595_((CriterionTrigger)new WhoRemainsCriterion());
        IRIDESCENT = (IridescentCriterion)CriteriaTriggers.m_10595_((CriterionTrigger)new IridescentCriterion());
        BIOME_BOTTLE = (BiomeBottleCriterion)CriteriaTriggers.m_10595_((CriterionTrigger)new BiomeBottleCriterion());
        CONVERT_MOB = (ConvertMobCriterion)CriteriaTriggers.m_10595_((CriterionTrigger)new ConvertMobCriterion());
    }

    public static class DimensionOpenedCriterion
    extends SimpleCriterionTrigger<ScoredConditions> {
        static final ResourceLocation ID = InfinityMethods.getId("dims_open");

        public ResourceLocation m_7295_() {
            return ID;
        }

        public ScoredConditions conditionsFromJson(JsonObject jsonObject, ContextAwarePredicate lootContextPredicate, DeserializationContext advancementEntityPredicateDeserializer) {
            int score = jsonObject.getAsJsonPrimitive("amount").getAsInt();
            return new ScoredConditions(lootContextPredicate, score, this.m_7295_());
        }

        public void trigger(ServerPlayer player) {
            this.m_66234_(player, conditions -> conditions.test(player.m_8951_().m_13015_(ModStats.DIMS_OPENED_STAT)));
        }
    }

    public static class DimensionClosedCriterion
    extends SimpleCriterionTrigger<ScoredConditions> {
        static final ResourceLocation ID = InfinityMethods.getId("dims_closed");

        public ResourceLocation m_7295_() {
            return ID;
        }

        public ScoredConditions conditionsFromJson(JsonObject jsonObject, ContextAwarePredicate lootContextPredicate, DeserializationContext advancementEntityPredicateDeserializer) {
            int score = jsonObject.getAsJsonPrimitive("amount").getAsInt();
            return new ScoredConditions(lootContextPredicate, score, this.m_7295_());
        }

        public void trigger(ServerPlayer player) {
            this.m_66234_(player, conditions -> conditions.test(player.m_8951_().m_13015_(ModStats.WORLDS_DESTROYED_STAT)));
        }
    }

    public static class WhoRemainsCriterion
    extends SimpleCriterionTrigger<EmptyConditions> {
        static final ResourceLocation ID = InfinityMethods.getId("who_remains");

        public ResourceLocation m_7295_() {
            return ID;
        }

        public EmptyConditions conditionsFromJson(JsonObject jsonObject, ContextAwarePredicate lootContextPredicate, DeserializationContext advancementEntityPredicateDeserializer) {
            return new EmptyConditions(lootContextPredicate, ID);
        }

        public void trigger(ServerPlayer player) {
            this.m_66234_(player, conditions -> true);
        }
    }

    public static class IridescentCriterion
    extends SimpleCriterionTrigger<EmptyConditions> {
        static final ResourceLocation ID = InfinityMethods.getId("iridescence");

        public void trigger(ServerPlayer player, boolean willing, int level) {
            this.m_66234_(player, conditions -> true);
        }

        protected EmptyConditions conditionsFromJson(JsonObject obj, ContextAwarePredicate lootContextPredicate, DeserializationContext predicateDeserializer) {
            return new EmptyConditions(lootContextPredicate, ID);
        }

        public ResourceLocation m_7295_() {
            return ID;
        }
    }

    public static class BiomeBottleCriterion
    extends SimpleCriterionTrigger<ScoredConditions> {
        static final ResourceLocation ID = InfinityMethods.getId("bottle");

        public ResourceLocation m_7295_() {
            return ID;
        }

        public ScoredConditions conditionsFromJson(JsonObject jsonObject, ContextAwarePredicate lootContextPredicate, DeserializationContext advancementEntityPredicateDeserializer) {
            int score = jsonObject.getAsJsonPrimitive("amount").getAsInt();
            return new ScoredConditions(lootContextPredicate, score, this.m_7295_());
        }

        public void trigger(ServerPlayer player, BiomeBottleBlockEntity be) {
            this.m_66234_(player, conditions -> conditions.test(be.charge));
        }
    }

    public static class ConvertMobCriterion
    extends SimpleCriterionTrigger<DataConditions> {
        static final ResourceLocation ID = InfinityMethods.getId("convert_mob");

        public void trigger(ServerPlayer player, LivingEntity e) {
            this.m_66234_(player, conditions -> conditions.test(Integer.parseInt(BuiltInRegistries.f_256780_.m_7981_((Object)e.m_6095_()).toString())));
        }

        protected DataConditions conditionsFromJson(JsonObject obj, ContextAwarePredicate playerPredicate, DeserializationContext predicateDeserializer) {
            return null;
        }

        public ResourceLocation m_7295_() {
            return ID;
        }
    }

    public static class DataConditions
    extends AbstractCriterionTriggerInstance {
        private final int score;

        public DataConditions(ContextAwarePredicate player, int score, ResourceLocation ID) {
            super(ID, player);
            this.score = score;
        }

        public boolean test(int stat) {
            return stat == this.score;
        }

        public static ScoredConditions create(int i, ResourceLocation ID) {
            return new ScoredConditions(ContextAwarePredicate.f_285567_, i, ID);
        }

        public JsonObject m_7683_(SerializationContext predicateSerializer) {
            JsonObject jsonObject = super.m_7683_(predicateSerializer);
            jsonObject.add("amount", (JsonElement)new JsonPrimitive((Number)this.score));
            return jsonObject;
        }
    }

    public static class ScoredConditions
    extends AbstractCriterionTriggerInstance {
        private final int score;

        public ScoredConditions(ContextAwarePredicate player, int score, ResourceLocation ID) {
            super(ID, player);
            this.score = score;
        }

        public boolean test(int stat) {
            return stat >= this.score;
        }

        public static ScoredConditions create(int i, ResourceLocation ID) {
            return new ScoredConditions(ContextAwarePredicate.f_285567_, i, ID);
        }

        public JsonObject m_7683_(SerializationContext predicateSerializer) {
            JsonObject jsonObject = super.m_7683_(predicateSerializer);
            jsonObject.add("amount", (JsonElement)new JsonPrimitive((Number)this.score));
            return jsonObject;
        }
    }

    public static class EmptyConditions
    extends AbstractCriterionTriggerInstance {
        public EmptyConditions(ContextAwarePredicate player, ResourceLocation ID) {
            super(ID, player);
        }

        public static EmptyConditions create(ResourceLocation ID) {
            return new EmptyConditions(ContextAwarePredicate.f_285567_, ID);
        }

        public JsonObject m_7683_(SerializationContext predicateSerializer) {
            return super.m_7683_(predicateSerializer);
        }
    }
}

