/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.var;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.DeferredRegister;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class ModDensityFunctionTypes {
    static NormalNoise sampler;
    static NormalNoise sampler2;
    public static final DeferredRegister<Codec<? extends DensityFunction>> DENSITY_FUNCTION_TYPES;

    public static <T extends DensityFunction> void register(String name, KeyDispatchDataCodec<T> holder) {
        DENSITY_FUNCTION_TYPES.register(name, () -> holder.f_216232_());
    }

    public static void registerFunctions() {
        sampler = NormalNoise.m_230504_((RandomSource)new LegacyRandomSource(0L), (int)-5, (double[])InfinityMethods.genOctaves(8));
        sampler2 = NormalNoise.m_230504_((RandomSource)new LegacyRandomSource(0L), (int)-6, (double[])InfinityMethods.genOctaves(8));
        for (NonbinaryOperation.Type enum_ : NonbinaryOperation.Type.values()) {
            ModDensityFunctionTypes.register(enum_.name, enum_.codecHolder);
        }
        ModDensityFunctionTypes.register("coordinate", Coordinate.CODEC_HOLDER);
        ModDensityFunctionTypes.register("menger", Menger.CODEC_HOLDER);
        ModDensityFunctionTypes.register("skygrid", Skygrid.CODEC_HOLDER);
        ModDensityFunctionTypes.register("library", Library.CODEC_HOLDER);
        ModDensityFunctionTypes.register("classic", Classic.CODEC_HOLDER);
        DENSITY_FUNCTION_TYPES.register();
    }

    static {
        DENSITY_FUNCTION_TYPES = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256746_);
    }

    static final class NonbinaryOperation
    extends Record
    implements Nonbinary {
        private final Type type;
        private final DensityFunction input;
        private final double minValue;
        private final double maxValue;

        NonbinaryOperation(Type type, DensityFunction input, double minValue, double maxValue) {
            this.type = type;
            this.input = input;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public static NonbinaryOperation create(Type type, DensityFunction input) {
            double d = input.m_207402_();
            double e = NonbinaryOperation.apply(type, d);
            double f = NonbinaryOperation.apply(type, input.m_207401_());
            return new NonbinaryOperation(type, input, e, f);
        }

        private static double apply(Type type, double density) {
            return switch (type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> Math.sin(density);
                case 1 -> Math.cos(density);
                case 2 -> Math.sqrt(density);
                case 3 -> {
                    if (Math.abs(density) < 0.001) {
                        yield 1000.0 * Math.signum(density);
                    }
                    yield 1.0 / density;
                }
                case 5 -> Math.exp(density);
                case 4 -> Math.log(density);
            };
        }

        @Override
        public double apply(double density) {
            return NonbinaryOperation.apply(this.type, density);
        }

        public NonbinaryOperation apply(DensityFunction.Visitor densityFunctionVisitor) {
            return NonbinaryOperation.create(this.type, this.input.m_207456_(densityFunctionVisitor));
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return this.type.codecHolder;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NonbinaryOperation.class, "type;input;minValue;maxValue", "type", "input", "minValue", "maxValue"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NonbinaryOperation.class, "type;input;minValue;maxValue", "type", "input", "minValue", "maxValue"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NonbinaryOperation.class, "type;input;minValue;maxValue", "type", "input", "minValue", "maxValue"}, this, o);
        }

        public Type type() {
            return this.type;
        }

        @Override
        public DensityFunction input() {
            return this.input;
        }

        public double m_207402_() {
            return this.minValue;
        }

        public double m_207401_() {
            return this.maxValue;
        }

        static enum Type {
            SIN("sin"),
            COS("cos"),
            SQRT("sqrt"),
            INVERT("invert"),
            LN("ln"),
            EXP("exp");

            private final String name;
            final KeyDispatchDataCodec<NonbinaryOperation> codecHolder = KeyDispatchDataCodec.m_216238_((MapCodec)DensityFunction.f_208218_.fieldOf("argument").xmap(input -> NonbinaryOperation.create(this, input), NonbinaryOperation::input));

            private Type(String name) {
                this.name = name;
            }
        }
    }

    record Coordinate(double scale, int axis) implements DensityFunction.SimpleFunction
    {
        public static final KeyDispatchDataCodec<Coordinate> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("scale").orElse((Object)1.0).forGetter(a -> a.scale), (App)Codec.INT.fieldOf("axis").forGetter(a -> a.axis)).apply((Applicative)instance, Coordinate::new)));

        public double m_207386_(DensityFunction.FunctionContext pos) {
            if (this.axis == -1 || this.scale == 0.0) {
                return this.apply(pos);
            }
            double d = this.apply(pos) * this.scale;
            d -= Math.floor(d);
            return (d - 0.5) * 2.0 * Math.PI;
        }

        public double m_207402_() {
            return -Math.PI;
        }

        public double m_207401_() {
            return Math.PI;
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return CODEC_HOLDER;
        }

        public double apply(DensityFunction.FunctionContext pos) {
            return switch (this.axis) {
                case 1 -> pos.m_207115_();
                case 2 -> pos.m_207114_();
                case 3 -> pos.m_207113_();
                case 0 -> Coordinate.r(pos);
                case -1 -> Math.acos((double)pos.m_207115_() / Coordinate.r(pos)) * (double)(pos.m_207113_() < 0 ? -1 : 1);
                default -> 0.0;
            };
        }

        static double r(DensityFunction.FunctionContext pos) {
            double res = Math.sqrt(pos.m_207115_() * pos.m_207115_() + pos.m_207113_() * pos.m_207113_());
            return Math.max(res, 0.01);
        }
    }

    record Menger(double scale, int max_y) implements DensityFunction.SimpleFunction
    {
        public static final KeyDispatchDataCodec<Menger> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("scale").orElse((Object)1.0).forGetter(a -> a.scale), (App)Codec.INT.fieldOf("max_y").orElse((Object)0).forGetter(a -> a.max_y)).apply((Applicative)instance, Menger::new)));

        public double m_207386_(DensityFunction.FunctionContext pos) {
            int x = pos.m_207115_();
            int y = pos.m_207114_();
            int z = pos.m_207113_();
            return y > this.max_y || this.check(x, z) || this.check(x, y) || this.check(y, z) ? -this.scale : this.scale;
        }

        public double m_207402_() {
            return -this.scale;
        }

        public double m_207401_() {
            return this.scale;
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return CODEC_HOLDER;
        }

        public boolean check(int a, int b) {
            int a1 = Math.abs(a);
            for (int b1 = Math.abs(b); a1 > 0 && b1 > 0; a1 /= 3, b1 /= 3) {
                if (a1 % 3 != 1 || b1 % 3 != 1) continue;
                return true;
            }
            return false;
        }
    }

    record Skygrid(double scale, int size, int separation) implements DensityFunction.SimpleFunction
    {
        public static final KeyDispatchDataCodec<Skygrid> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("scale").orElse((Object)1.0).forGetter(a -> a.scale), (App)Codec.INT.fieldOf("size").orElse((Object)1).forGetter(a -> a.size), (App)Codec.INT.fieldOf("separation").orElse((Object)3).forGetter(a -> a.separation)).apply((Applicative)instance, Skygrid::new)));

        public double m_207386_(DensityFunction.FunctionContext pos) {
            int n = this.separation + this.size;
            int x = Math.abs(pos.m_207115_());
            int y = Math.abs(pos.m_207114_());
            int z = Math.abs(pos.m_207113_());
            return x % n < this.size && y % n < this.size && z % n < this.size ? this.scale : -this.scale;
        }

        public double m_207402_() {
            return -this.scale;
        }

        public double m_207401_() {
            return this.scale;
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return CODEC_HOLDER;
        }
    }

    public static enum Library implements TileableStructure
    {
        INSTANCE;

        static final KeyDispatchDataCodec<Library> CODEC_HOLDER;

        @Override
        public int size(int axis) {
            return axis == 1 ? 16 : 15;
        }

        @Override
        public boolean testBlock(int x, int y, int z) {
            int max_xz = Math.max(Math.abs(7 - x), Math.abs(7 - z));
            int min_xz = Math.min(Math.abs(7 - x), Math.abs(7 - z));
            if (max_xz == 7) {
                return y >= 3 || y == 0 || min_xz > 1;
            }
            if (max_xz < 2) {
                return true;
            }
            if (max_xz == 2 && min_xz == 1) {
                return true;
            }
            return y == 0;
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return CODEC_HOLDER;
        }

        static {
            CODEC_HOLDER = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)INSTANCE));
        }
    }

    public record Classic(int sealevel) implements DensityFunction.SimpleFunction
    {
        public static final KeyDispatchDataCodec<Classic> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("sealevel").orElse((Object)64).forGetter(a -> a.sealevel)).apply((Applicative)instance, Classic::new)));

        public double m_207386_(DensityFunction.FunctionContext pos) {
            return pos.m_207114_() < this.sample(pos.m_207115_(), pos.m_207113_()) ? 1.0 : -1.0;
        }

        int sample(int x, int z) {
            double heightResult;
            double heightLow = sampler.m_75380_((double)x * 1.3, 0.0, (double)z * 1.3) * 6.0 - 6.0;
            double heightHigh = sampler.m_75380_((double)x * 1.3, 200.0, (double)z * 1.3) * 7.2 + 6.0;
            if (sampler2.m_75380_((double)x, 0.0, (double)z) > 0.0) {
                heightHigh = heightLow;
            }
            if ((heightResult = Math.max(heightLow, heightHigh) / 2.0) < 0.0) {
                heightResult *= 0.8;
            }
            return this.sealevel + (int)heightResult;
        }

        public double m_207402_() {
            return -1.0;
        }

        public double m_207401_() {
            return 1.0;
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return CODEC_HOLDER;
        }
    }

    static interface TileableStructure
    extends DensityFunction.SimpleFunction {
        public int size(int var1);

        public boolean testBlock(int var1, int var2, int var3);

        default public int normalize(int x, int axis) {
            int a = Math.abs(x < 0 ? x + 1 : x) % this.size(axis);
            return x < 0 ? this.size(axis) - 1 - a : a;
        }

        default public double m_207386_(DensityFunction.FunctionContext pos) {
            int z;
            int y;
            int x = this.normalize(pos.m_207115_(), 0);
            return this.testBlock(x, y = this.normalize(pos.m_207114_(), 1), z = this.normalize(pos.m_207113_(), 2)) ? 1.0 : -1.0;
        }

        default public double m_207402_() {
            return -1.0;
        }

        default public double m_207401_() {
            return 1.0;
        }
    }

    static interface Nonbinary
    extends DensityFunction {
        public DensityFunction input();

        default public double m_207386_(DensityFunction.FunctionContext pos) {
            return this.apply(this.input().m_207386_(pos));
        }

        default public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
            this.input().m_207362_(densities, applier);
            for (int i = 0; i < densities.length; ++i) {
                densities[i] = this.apply(densities[i]);
            }
        }

        public double apply(double var1);
    }
}

