/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.var;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.Collections;
import java.util.List;
import net.lerariemann.infinity.mixin.core.MaterialRuleContextAccess;
import net.lerariemann.infinity.util.var.TextData;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class ModMaterialConditions {
    public static final DeferredRegister<Codec<? extends SurfaceRules.ConditionSource>> MATERIAL_CONDITIONS = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256793_);

    public static void registerConditions() {
        MATERIAL_CONDITIONS.register("linear", () -> LinearCondition.CODEC.f_216232_());
        MATERIAL_CONDITIONS.register("checkerboard", () -> CheckerboardCondition.CODEC.f_216232_());
        MATERIAL_CONDITIONS.register("text", () -> TextCondition.CODEC.f_216232_());
        MATERIAL_CONDITIONS.register();
    }

    public record LinearCondition(double k_x, double k_y, double k_z, double min, double max, int separation) implements SurfaceRules.ConditionSource
    {
        public static final KeyDispatchDataCodec<LinearCondition> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("k_x").orElse((Object)1.0).forGetter(a -> a.k_x), (App)Codec.DOUBLE.fieldOf("k_y").orElse((Object)0.0).forGetter(a -> a.k_y), (App)Codec.DOUBLE.fieldOf("k_z").orElse((Object)1.0).forGetter(a -> a.k_z), (App)Codec.DOUBLE.fieldOf("min").orElse((Object)0.0).forGetter(a -> a.min), (App)Codec.DOUBLE.fieldOf("max").orElse((Object)0.5).forGetter(a -> a.max), (App)Codec.INT.fieldOf("separation").orElse((Object)16).forGetter(a -> a.separation)).apply((Applicative)instance, LinearCondition::new)));

        public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> m_213794_() {
            return CODEC;
        }

        public SurfaceRules.Condition apply(final SurfaceRules.Context materialRuleContext) {
            class LinearPredicate
            extends SurfaceRules.LazyYCondition {
                LinearPredicate() {
                    super(context);
                }

                double scale() {
                    return Math.sqrt(LinearCondition.this.k_x * LinearCondition.this.k_x + LinearCondition.this.k_y * LinearCondition.this.k_y + LinearCondition.this.k_z * LinearCondition.this.k_z);
                }

                public boolean m_183479_() {
                    int x = ((MaterialRuleContextAccess)this.f_189616_).getBlockX();
                    int y = ((MaterialRuleContextAccess)this.f_189616_).getBlockY();
                    int z = ((MaterialRuleContextAccess)this.f_189616_).getBlockZ();
                    double res = (LinearCondition.this.k_x * (double)x + LinearCondition.this.k_y * (double)y + LinearCondition.this.k_z * (double)z) / ((double)LinearCondition.this.separation * this.scale());
                    return (res -= Math.floor(res)) > LinearCondition.this.min && res < LinearCondition.this.max;
                }
            }
            return new LinearPredicate();
        }
    }

    public record CheckerboardCondition(int size) implements SurfaceRules.ConditionSource
    {
        public static final KeyDispatchDataCodec<CheckerboardCondition> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("size").orElse((Object)1).forGetter(a -> a.size)).apply((Applicative)instance, CheckerboardCondition::new)));

        public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> m_213794_() {
            return CODEC;
        }

        public SurfaceRules.Condition apply(final SurfaceRules.Context materialRuleContext) {
            class CheckerboardPredicate
            extends SurfaceRules.LazyYCondition {
                CheckerboardPredicate() {
                    super(context);
                }

                public int sign(int coord) {
                    if (coord < 0) {
                        return -this.sign(-1 - coord);
                    }
                    return coord / CheckerboardCondition.this.size % 2 * 2 - 1;
                }

                public boolean m_183479_() {
                    int x = this.sign(((MaterialRuleContextAccess)this.f_189616_).getBlockX());
                    int z = this.sign(((MaterialRuleContextAccess)this.f_189616_).getBlockZ());
                    return x > 0 ^ z > 0;
                }
            }
            return new CheckerboardPredicate();
        }
    }

    public record TextCondition(int font_size, int char_spacing, int line_spacing, int max_width, String text, TextData data) implements SurfaceRules.ConditionSource
    {
        public static final KeyDispatchDataCodec<TextCondition> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("font_size").orElse((Object)1).forGetter(a -> a.font_size), (App)Codec.INT.fieldOf("char_spacing").orElse((Object)1).forGetter(a -> a.char_spacing), (App)Codec.INT.fieldOf("line_spacing").orElse((Object)1).forGetter(a -> a.line_spacing), (App)Codec.INT.fieldOf("max_width").orElse((Object)Integer.MAX_VALUE).forGetter(a -> a.max_width), (App)Codec.STRING.fieldOf("text").forGetter(a -> a.text)).apply((Applicative)instance, (font_size, char_spacing, line_spacing, max_width, text) -> new TextCondition((int)font_size, (int)char_spacing, (int)line_spacing, (int)max_width, (String)text, TextData.genData(char_spacing, max_width, text)))));

        public int find(int x, int line_num) {
            int char_num = Collections.binarySearch(this.data.offsetMap().get(line_num), x);
            if (char_num < 0) {
                char_num = -char_num - 2;
            }
            return char_num;
        }

        public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> m_213794_() {
            return CODEC;
        }

        public SurfaceRules.Condition apply(final SurfaceRules.Context materialRuleContext) {
            class CheckerboardPredicate
            extends SurfaceRules.LazyYCondition {
                final List<List<Integer>> textmap;
                final List<List<Character>> charmap;
                final int longest_line;

                CheckerboardPredicate() {
                    super(context);
                    this.textmap = TextCondition.this.data.offsetMap();
                    this.charmap = TextCondition.this.data.charMap();
                    this.longest_line = TextCondition.this.data.longest_line();
                }

                public boolean m_183479_() {
                    int x = ((MaterialRuleContextAccess)this.f_189616_).getBlockX() / TextCondition.this.font_size;
                    int z = ((MaterialRuleContextAccess)this.f_189616_).getBlockZ() / TextCondition.this.font_size;
                    int factor = 8 + TextCondition.this.line_spacing;
                    if (x < 0 || z < 0 || x > this.longest_line || z >= factor * this.textmap.size()) {
                        return false;
                    }
                    int line_num = z / factor;
                    int char_num = TextCondition.this.find(x, line_num);
                    int char_z = z % factor;
                    if (char_z >= 8 || char_num < 0) {
                        return false;
                    }
                    int char_x = x - this.textmap.get(line_num).get(char_num);
                    return TextData.check(char_x, char_z, this.charmap.get(line_num).get(char_num));
                }
            }
            return new CheckerboardPredicate();
        }
    }
}

