/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.var;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.DeferredRegister;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class ModMaterialRules {
    public static final DeferredRegister<Codec<? extends SurfaceRules.RuleSource>> MATERIAL_RULES = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256815_);

    static int normalize(int x, int size) {
        int a = Math.abs(x < 0 ? x + 1 : x) % size;
        return x < 0 ? size - 1 - a : a;
    }

    public static <R extends SurfaceRules.RuleSource, T extends KeyDispatchDataCodec<R>> void register(String name, T holder) {
        MATERIAL_RULES.register(name, () -> holder.f_216232_());
    }

    public static void registerRules() {
        ModMaterialRules.register("chaos", RandomBlockMaterialRule.CODEC);
        ModMaterialRules.register("colored_chaos", RandomColoredBlock.Rule.CODEC);
        ModMaterialRules.register("library", Library.Rule.CODEC);
        ModMaterialRules.register("backrooms", Backrooms.Rule.CODEC);
        ModMaterialRules.register("nexus", Nexus.Rule.CODEC);
        ModMaterialRules.register("perfection", Perfection.Rule.CODEC);
        MATERIAL_RULES.register();
    }

    public static enum RandomBlockMaterialRule implements SurfaceRules.RuleSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<RandomBlockMaterialRule> CODEC;
        static RandomProvider PROVIDER;

        public static void setProvider(RandomProvider p) {
            PROVIDER = p;
        }

        public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> m_213795_() {
            return CODEC;
        }

        public SurfaceRules.SurfaceRule apply(SurfaceRules.Context materialRuleContext) {
            return new RandomBlockStateRule(PROVIDER);
        }

        static {
            CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
        }
    }

    public record RandomColoredBlock(String str) implements SurfaceRules.SurfaceRule
    {
        public BlockState m_183550_(int i, int j, int k) {
            BlockState st;
            double d = InfinityMethods.sampler.m_75380_((double)i, (double)j, (double)k);
            if ((st = Iridescence.getRandomColorBlock(d -= Math.floor(d), this.str).m_49966_()).m_61138_((Property)BlockStateProperties.f_61447_)) {
                st = (BlockState)st.m_61124_((Property)BlockStateProperties.f_61447_, (Comparable)Boolean.TRUE);
            }
            return st;
        }

        record Rule(String str) implements SurfaceRules.RuleSource
        {
            static final KeyDispatchDataCodec<Rule> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("block_type").orElse((Object)"concrete").forGetter(a -> a.str)).apply((Applicative)instance, Rule::new)));

            public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> m_213795_() {
                return CODEC;
            }

            public SurfaceRules.SurfaceRule apply(SurfaceRules.Context materialRuleContext) {
                return new RandomColoredBlock(this.str);
            }
        }
    }

    public static class Library
    implements SurfaceRules.SurfaceRule {
        static final BlockState floor = Blocks.f_50398_.m_49966_();
        static final BlockState wall = ((Block)ModBlocks.BOOK_BOX.get()).m_49966_();
        static final BlockState decor = Blocks.f_50141_.m_49966_();
        static final BlockState glass = Blocks.f_50216_.m_49966_();
        static final BlockState column = Blocks.f_50705_.m_49966_();
        static final BlockState air = Blocks.f_50016_.m_49966_();

        int normalize(int x, int size) {
            int a = Math.abs(x < 0 ? x + 1 : x) % size;
            return x < 0 ? size - 1 - a : a;
        }

        public BlockState m_183550_(int i, int j, int k) {
            int x = this.normalize(i, 15);
            int y = this.normalize(j, 16);
            int z = this.normalize(k, 15);
            int max_xz = Math.max(Math.abs(7 - x), Math.abs(7 - z));
            int min_xz = Math.min(Math.abs(7 - x), Math.abs(7 - z));
            if (max_xz == 7) {
                if (min_xz < 2) {
                    if (y == 0) {
                        return floor;
                    }
                    if (y < 4) {
                        return air;
                    }
                }
                return wall;
            }
            if (max_xz < 2) {
                return (x + z) % 2 == 1 ? wall : column;
            }
            if (max_xz == 2 && min_xz == 1) {
                if (j == 0) {
                    return floor;
                }
                Direction d = x == 5 ? Direction.WEST : (x == 9 ? Direction.EAST : (z == 5 ? Direction.NORTH : Direction.SOUTH));
                return (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)d);
            }
            if (y == 0) {
                if (max_xz == 4) {
                    if (min_xz == 4) {
                        return decor;
                    }
                    if (min_xz == 0 && j > 0) {
                        return glass;
                    }
                }
                return floor;
            }
            return air;
        }

        static enum Rule implements SurfaceRules.RuleSource
        {
            INSTANCE;

            static final KeyDispatchDataCodec<Rule> CODEC;

            public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> m_213795_() {
                return CODEC;
            }

            public SurfaceRules.SurfaceRule apply(SurfaceRules.Context materialRuleContext) {
                return new Library();
            }

            static {
                CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
            }
        }
    }

    public static class Backrooms
    implements SurfaceRules.SurfaceRule {
        static final BlockState floor = Blocks.f_50182_.m_49966_();
        static final BlockState wall = Blocks.f_50471_.m_49966_();
        static final BlockState light = Blocks.f_220859_.m_49966_();
        static final BlockState ceiling = Blocks.f_50471_.m_49966_();
        static final BlockState air = Blocks.f_50016_.m_49966_();
        static final BlockState filler = Blocks.f_50080_.m_49966_();

        int normalize(int x, int size) {
            int a = Math.abs(x < 0 ? x + 1 : x) % size;
            return x < 0 ? size - 1 - a : a;
        }

        int anti_normalize(int x, int size) {
            return Math.abs(x < 0 ? x + 1 : x) / size;
        }

        /*
         * Unable to fully structure code
         */
        public BlockState m_183550_(int i, int j, int k) {
            size_xz = 15;
            halfsize_xz = 7;
            x = this.normalize(i, size_xz);
            y = this.normalize(j - 1, 16);
            z = this.normalize(k, size_xz);
            xrel = Math.abs(halfsize_xz - x);
            zrel = Math.abs(halfsize_xz - z);
            max_xz = Math.max(xrel, zrel);
            min_xz = Math.min(xrel, zrel);
            v0 = isXMax = max_xz == xrel;
            if (max_xz < 3 || min_xz > 3 || y > 6) ** GOTO lbl-1000
            v1 = 2 * this.anti_normalize(i, size_xz) - Mth.m_14205_((double)i) * Mth.m_14205_((double)(halfsize_xz - x)) * (isXMax != false ? 1 : 0);
            v2 = this.anti_normalize(j - 1, 16);
            v3 = 2 * this.anti_normalize(k, size_xz);
            v4 = Mth.m_14205_((double)k) * Mth.m_14205_((double)(halfsize_xz - z));
            v5 = isXMax != false ? 0 : 1;
            if ((double)(Mth.m_14130_((int)v1, (int)v2, (int)(v3 - v4 * v5)) & 15L) / 15.0 > 0.3) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = isOpen = false;
            }
            if (isOpen || min_xz <= 3 && y <= 6 && (i == 0 || k == 0)) {
                if (min_xz == 3) {
                    return Backrooms.wall;
                }
                if (y == 0) {
                    return Backrooms.floor;
                }
                if (y == 6) {
                    if (min_xz == 0 && max_xz % 3 == 0) {
                        return Backrooms.light;
                    }
                    return Backrooms.ceiling;
                }
                return Backrooms.air;
            }
            if (max_xz <= 3 && y <= 6) {
                if (max_xz == 3) {
                    return Backrooms.wall;
                }
                if (y == 0) {
                    return Backrooms.floor;
                }
                if (y == 6) {
                    if (max_xz == 0) {
                        return Backrooms.light;
                    }
                    return Backrooms.ceiling;
                }
                return Backrooms.air;
            }
            return Backrooms.filler;
        }

        static enum Rule implements SurfaceRules.RuleSource
        {
            INSTANCE;

            static final KeyDispatchDataCodec<Rule> CODEC;

            public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> m_213795_() {
                return CODEC;
            }

            public SurfaceRules.SurfaceRule apply(SurfaceRules.Context materialRuleContext) {
                return new Backrooms();
            }

            static {
                CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
            }
        }
    }

    public static class Nexus
    implements SurfaceRules.SurfaceRule {
        static final BlockState floor = Blocks.f_50470_.m_49966_();
        static final BlockState wall = Blocks.f_50705_.m_49966_();
        static final BlockState column1 = Blocks.f_49999_.m_49966_();
        static final BlockState column2 = (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
        static final BlockState stair1 = (BlockState)Blocks.f_50086_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
        static final BlockState stair2 = (BlockState)Blocks.f_50086_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH);
        static final BlockState stair3 = (BlockState)((BlockState)Blocks.f_50086_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)Half.TOP);
        static final BlockState stair4 = (BlockState)((BlockState)Blocks.f_50086_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH)).m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)Half.TOP);
        static final BlockState light1 = (BlockState)Blocks.f_50144_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH);
        static final BlockState light2 = (BlockState)Blocks.f_50144_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
        static final BlockState light3 = Blocks.f_50141_.m_49966_();
        static final BlockState air = Blocks.f_50016_.m_49966_();

        public BlockState m_183550_(int i, int j, int k) {
            int x = ModMaterialRules.normalize(i, 8);
            int y = j - 50;
            int z = ModMaterialRules.normalize(k, 16);
            if (y == -2) {
                return Blocks.f_50752_.m_49966_();
            }
            switch (y) {
                case -1: 
                case 9: {
                    if (!(z != 10 && z != 6 || x != 0 && x != 4)) {
                        return light3;
                    }
                    return y == -1 ? floor : wall;
                }
                case 0: {
                    return switch (z) {
                        case 0, 1, 2, 14, 15 -> wall;
                        case 3 -> stair1;
                        case 13 -> stair2;
                        default -> air;
                    };
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (z == 0) {
                        return wall;
                    }
                    if (z == 1 || z == 15) {
                        if (x == 5 || x == 7) {
                            return column1;
                        }
                        if (x == 6) {
                            if (y != 3) {
                                return wall;
                            }
                            return z == 1 ? light1 : light2;
                        }
                    }
                    return air;
                }
                case 6: {
                    if (z == 0) {
                        return wall;
                    }
                    return z == 1 || z == 15 ? column2 : air;
                }
                case 7: {
                    return switch (z) {
                        case 2 -> stair3;
                        case 14 -> stair4;
                        case 0, 1, 15 -> wall;
                        default -> air;
                    };
                }
                case 8: {
                    return switch (z) {
                        case 0, 1, 2, 3, 13, 14, 15 -> wall;
                        case 4 -> stair3;
                        case 12 -> stair4;
                        default -> air;
                    };
                }
            }
            return air;
        }

        static enum Rule implements SurfaceRules.RuleSource
        {
            INSTANCE;

            static final KeyDispatchDataCodec<Rule> CODEC;

            public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> m_213795_() {
                return CODEC;
            }

            public SurfaceRules.SurfaceRule apply(SurfaceRules.Context materialRuleContext) {
                return new Nexus();
            }

            static {
                CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
            }
        }
    }

    public static class Perfection
    implements SurfaceRules.SurfaceRule {
        static final BlockState cobblestone = Blocks.f_50652_.m_49966_();
        static final BlockState lightNorth = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
        static final BlockState lightSouth = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH);
        static final BlockState lightEast = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST);
        static final BlockState lightWest = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST);
        static final BlockState glass = Blocks.f_50058_.m_49966_();
        static final BlockState air = Blocks.f_50016_.m_49966_();

        public BlockState m_183550_(int i, int j, int k) {
            int x = ModMaterialRules.normalize(i, 10);
            int y = j - 50;
            int z = ModMaterialRules.normalize(k, 10);
            if (y == -2) {
                return Blocks.f_50752_.m_49966_();
            }
            switch (y) {
                case -1: {
                    return cobblestone;
                }
                case 4: {
                    if (!(z != 7 && z != 6 && z != 0 && z != 9 || x != 0 && x != 9 && x != 2 && x != 3)) {
                        return glass;
                    }
                    return cobblestone;
                }
                case 3: {
                    if (z == 2 || z == 3 || z == 4) {
                        return cobblestone;
                    }
                    if (z == 1) {
                        if (x == 1) {
                            return lightNorth;
                        }
                    } else if (z == 5 && x == 1) {
                        return lightSouth;
                    }
                    if (x == 7 || x == 6 || x == 5) {
                        return cobblestone;
                    }
                    if (x == 8) {
                        if (z == 8) {
                            return lightEast;
                        }
                    } else if (x == 4 && z == 8) {
                        return lightWest;
                    }
                    return air;
                }
                case 0: 
                case 1: 
                case 2: {
                    if (x == 7 || x == 6 || x == 5) {
                        if (z == 7 || z == 8 || z == 9) {
                            return air;
                        }
                        return cobblestone;
                    }
                    if (z == 2 || z == 3 || z == 4 || z == 12 || z == 13 || z == 14) {
                        if (x == 0 || x == 2 || x == 1) {
                            return air;
                        }
                        return cobblestone;
                    }
                    return air;
                }
            }
            return air;
        }

        static enum Rule implements SurfaceRules.RuleSource
        {
            INSTANCE;

            static final KeyDispatchDataCodec<Rule> CODEC;

            public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> m_213795_() {
                return CODEC;
            }

            public SurfaceRules.SurfaceRule apply(SurfaceRules.Context materialRuleContext) {
                return new Perfection();
            }

            static {
                CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
            }
        }
    }

    public record RandomBlockStateRule(RandomProvider prov) implements SurfaceRules.SurfaceRule
    {
        public BlockState m_183550_(int i, int j, int k) {
            BlockState st;
            long seed = Mth.m_14130_((int)i, (int)j, (int)k);
            double d = (double)(seed & 0xFFFL) / 4095.0;
            if ((st = ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(this.prov.randomName(d -= Math.floor(d), "full_blocks_worldgen")))).m_49966_()).m_61138_((Property)BlockStateProperties.f_61447_)) {
                st = (BlockState)st.m_61124_((Property)BlockStateProperties.f_61447_, (Comparable)Boolean.TRUE);
            }
            return st;
        }
    }
}

