/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.var;

import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.lerariemann.infinity.access.InfinityOptionsAccess;
import net.lerariemann.infinity.access.WorldRendererAccess;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.item.F4Item;
import net.lerariemann.infinity.options.InfinityOptions;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.loading.DimensionGrabber;
import net.lerariemann.infinity.util.loading.ShaderLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ModPayloads {
    public static final ResourceLocation WORLD_ADD = InfinityMethods.getId("reload_worlds");
    public static final ResourceLocation SHADER_RELOAD = InfinityMethods.getId("reload_shader");
    public static final ResourceLocation STARS_RELOAD = InfinityMethods.getId("reload_stars");
    public static final ResourceLocation UPDATE_F4 = InfinityMethods.getId("update_f4");
    public static final ResourceLocation DEPLOY_F4 = InfinityMethods.getId("deploy_f4");
    public static final ResourceLocation UPLOAD_JUKEBOXES = InfinityMethods.getId("upload_jukeboxes");
    public static boolean resourcesReloaded = Path.of(String.valueOf(Platform.getGameFolder()) + "/resourcepacks/infinity/assets/infinity/shaders", new String[0]).toFile().exists();

    public static FriendlyByteBuf buildPacket(ServerLevel destination, ServerPlayer player) {
        return ModPayloads.buildPacket(destination, Iridescence.shouldApplyShader((Player)player));
    }

    public static FriendlyByteBuf buildPacket(ServerLevel destination, boolean bl) {
        FriendlyByteBuf buf = PlatformMethods.createPacketByteBufs();
        buf.writeBoolean(bl);
        if (destination == null) {
            buf.m_130079_(new CompoundTag());
        } else {
            buf.m_130079_(((InfinityOptionsAccess)destination).infinity$getOptions().data());
        }
        return buf;
    }

    public static void sendReloadPacket(ServerPlayer player, ServerLevel world) {
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)SHADER_RELOAD, (FriendlyByteBuf)ModPayloads.buildPacket(world, player));
    }

    public static void receiveShader(Minecraft client, ClientPacketListener handler, FriendlyByteBuf buf, PacketSender responseSender) {
        if (buf.readBoolean()) {
            client.execute(() -> ShaderLoader.reloadShaders(client, true, true));
            return;
        }
        InfinityOptions options = new InfinityOptions(buf.m_130260_());
        ((InfinityOptionsAccess)client).infinity$setOptions(options);
        CompoundTag shader = options.getShader();
        boolean bl = shader.m_128456_();
        if (bl) {
            client.execute(() -> ShaderLoader.reloadShaders(client, false, false));
        } else {
            client.execute(() -> {
                CommonIO.write(shader, ShaderLoader.shaderDir(client), "current.json");
                ShaderLoader.reloadShaders(client, true, false);
                if (!resourcesReloaded) {
                    client.m_91391_();
                    resourcesReloaded = true;
                }
            });
        }
    }

    public static void receiveStars(Minecraft client, ClientPacketListener handler, FriendlyByteBuf buf, PacketSender responseSender) {
        ((WorldRendererAccess)client.f_91060_).infinity$setNeedsStars(true);
    }

    public static void registerC2SPacketsReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(F4UpdatingValuesPacket.type, (packet, player, responseSender) -> {
            ItemStack st = player.m_150109_().m_8020_(packet.slot).m_41777_();
            if (st.m_150930_((Item)ModItems.F4.get())) {
                CompoundTag nbt = st.m_41783_();
                if (nbt == null) {
                    nbt = new CompoundTag();
                }
                nbt.m_128405_(ModComponentTypes.SIZE_X, packet.width);
                nbt.m_128405_(ModComponentTypes.SIZE_Y, packet.height);
                st.m_41751_(nbt);
                player.m_150109_().m_6836_(packet.slot, st);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(F4DeployingPacket.type, (packet, player, responseSender) -> {
            InteractionResultHolder<ItemStack> result = F4Item.deploy((Level)player.m_284548_(), (Player)player, InteractionHand.MAIN_HAND);
            player.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)result.m_19095_());
        });
    }

    public static void registerS2CPacketsReceivers() {
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)WORLD_ADD, (client, handler, buf, responseSender) -> {
            ResourceLocation id = buf.m_130281_();
            CompoundTag optiondata = buf.m_130260_();
            int i = buf.readInt();
            ArrayList<ResourceLocation> biomeids = new ArrayList<ResourceLocation>();
            ArrayList<CompoundTag> biomes = new ArrayList<CompoundTag>();
            for (int j = 0; j < i; ++j) {
                biomeids.add(buf.m_130281_());
                biomes.add(buf.m_130260_());
            }
            client.execute(() -> new DimensionGrabber(client.m_91403_().m_105152_()).grab_for_client(id, optiondata, biomeids, biomes));
        });
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)SHADER_RELOAD, ModPayloads::receiveShader);
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)STARS_RELOAD, ModPayloads::receiveStars);
    }

    public static class F4UpdatingValuesPacket
    implements FabricPacket {
        int slot;
        int width;
        int height;
        public static PacketType<F4UpdatingValuesPacket> type = PacketType.create((ResourceLocation)UPDATE_F4, buf -> new F4UpdatingValuesPacket(buf.readInt(), buf.readInt(), buf.readInt()));

        public F4UpdatingValuesPacket(int s, int w, int h) {
            this.slot = s;
            this.width = w;
            this.height = h;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeInt(this.slot);
            buf.writeInt(this.width);
            buf.writeInt(this.height);
        }

        public PacketType<?> getType() {
            return type;
        }
    }

    public static class F4DeployingPacket
    implements FabricPacket {
        public static PacketType<F4DeployingPacket> type = PacketType.create((ResourceLocation)DEPLOY_F4, buf -> new F4DeployingPacket());

        public void write(FriendlyByteBuf buf) {
        }

        public PacketType<?> getType() {
            return type;
        }
    }
}

