/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.var;

import com.mojang.serialization.MapCodec;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ModPlacementModifiers {
    public static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIER_TYPES = DeferredRegister.create((String)"infinity", (ResourceKey)Registries.f_256843_);
    public static final RegistrySupplier<PlacementModifierType<?>> PROXIMITY = ModPlacementModifiers.register("center_proximity", CenterProximityPlacementModifier.MODIFIER_CODEC);

    static RegistrySupplier<PlacementModifierType<?>> register(String id, MapCodec<? extends PlacementModifier> codec) {
        return PLACEMENT_MODIFIER_TYPES.register(id, () -> () -> codec.codec());
    }

    public static void registerModifiers() {
        PLACEMENT_MODIFIER_TYPES.register();
    }

    public static class CenterProximityPlacementModifier
    extends PlacementFilter {
        public static final MapCodec<CenterProximityPlacementModifier> MODIFIER_CODEC = ExtraCodecs.f_144629_.fieldOf("radius").xmap(CenterProximityPlacementModifier::new, a -> a.radius);
        private final int radius;

        private CenterProximityPlacementModifier(int radius) {
            this.radius = radius;
        }

        public static CenterProximityPlacementModifier of(int radius) {
            return new CenterProximityPlacementModifier(radius);
        }

        protected boolean m_213917_(PlacementContext context, RandomSource random, BlockPos pos) {
            return pos.m_123341_() * pos.m_123341_() + pos.m_123342_() * pos.m_123342_() + pos.m_123343_() * pos.m_123343_() < this.radius * this.radius;
        }

        public PlacementModifierType<?> m_183327_() {
            return PlacementModifierType.f_191849_;
        }
    }
}

