/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.structure;

import java.util.List;
import net.lerariemann.infinity.registry.core.ModStructureTypes;
import net.lerariemann.infinity.util.var.TextData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.jetbrains.annotations.NotNull;

public class LetterPiece
extends ScatteredFeaturePiece {
    List<Integer> letter;
    BlockStateProvider block;
    int ori;

    protected LetterPiece(StructurePieceType type, int x, int y, int z, int width, int height, int depth, int ori, List<Integer> letter, BlockStateProvider block) {
        super(type, x, y, z, width, height, depth, Direction.SOUTH);
        this.letter = letter;
        this.block = block;
        this.ori = ori;
    }

    public LetterPiece(CompoundTag nbt) {
        super((StructurePieceType)ModStructureTypes.LETTER.get(), nbt);
    }

    static LetterPiece of(BlockPos startcorner, int ori, @NotNull List<Integer> letter, BlockStateProvider block) {
        BlockPos dims = LetterPiece.getDimensions(ori, letter.size());
        BlockPos othercoord = startcorner.m_121955_((Vec3i)dims);
        return new LetterPiece((StructurePieceType)ModStructureTypes.LETTER.get(), Math.min(startcorner.m_123341_(), othercoord.m_123341_()), Math.min(startcorner.m_123342_(), othercoord.m_123342_()), Math.min(startcorner.m_123343_(), othercoord.m_123343_()), Math.abs(dims.m_123341_()), Math.abs(dims.m_123342_()), Math.abs(dims.m_123343_()), ori, letter, block);
    }

    static BlockPos getDimensions(int ori, int letterwidth) {
        return TextData.mutate(BlockPos.f_121853_, ori, 8, letterwidth + 1, 8, 0, 0, 0);
    }

    public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
        if (this.letter == null) {
            return;
        }
        for (int j = 0; j < this.letter.size(); ++j) {
            for (int k = 0; k < 8; ++k) {
                BlockPos bp = TextData.mutate(BlockPos.f_121853_, this.ori, k, j, 0, 8, this.letter.size(), 8);
                this.m_73434_(world, (this.letter.get(j) >> k) % 2 == 1 ? this.block.m_213972_(random, bp) : Blocks.f_50016_.m_49966_(), bp.m_123341_(), bp.m_123342_(), bp.m_123343_(), chunkBox);
            }
        }
    }
}

