/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.lerariemann.infinity.registry.core.ModStructureTypes;
import net.lerariemann.infinity.structure.LetterPiece;
import net.lerariemann.infinity.util.var.TextData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class TextStructure
extends Structure {
    public static final MapCodec<TextStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TextStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)Codec.STRING.fieldOf("text").forGetter(a -> a.text), (App)BlockStateProvider.f_68747_.fieldOf("block").forGetter(a -> a.block), (App)Codec.INT.fieldOf("polarization").orElse((Object)2).forGetter(a -> a.pol.id), (App)Codec.STRING.fieldOf("direction").orElse((Object)"random").forGetter(a -> a.dir), (App)Codec.INT.fieldOf("char_spacing").orElse((Object)1).forGetter(a -> a.char_spacing), (App)Codec.INT.fieldOf("line_spacing").orElse((Object)1).forGetter(a -> a.line_spacing), (App)HeightProvider.f_161970_.fieldOf("y").forGetter(a -> a.y_provider)).apply((Applicative)instance, TextStructure::new));
    String text;
    BlockStateProvider block;
    String dir;
    int line_spacing;
    int char_spacing;
    HeightProvider y_provider;
    TextData.Polarization pol;

    TextStructure(Structure.StructureSettings config, String text, BlockStateProvider block, int pol, String dir, int line_spacing, int char_spacing, HeightProvider y_provider) {
        super(config);
        this.text = text;
        this.block = block;
        this.dir = dir;
        this.pol = TextData.Polarization.of(pol);
        this.line_spacing = line_spacing;
        this.char_spacing = char_spacing;
        this.y_provider = y_provider;
    }

    public Direction getDir(Structure.GenerationContext context) {
        return switch (this.dir) {
            case "N" -> Direction.NORTH;
            case "S" -> Direction.SOUTH;
            case "W" -> Direction.WEST;
            case "E" -> Direction.EAST;
            default -> Direction.Plane.HORIZONTAL.m_235690_((RandomSource)context.f_226626_());
        };
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return TextStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, collector -> this.addPieces((StructurePiecesBuilder)collector, context));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ModStructureTypes.TEXT.get();
    }

    private void addPieces(StructurePiecesBuilder collector, Structure.GenerationContext context) {
        BlockPos centerPos = context.f_226628_().m_45615_().m_7918_(8, 0, 8);
        int new_y = this.y_provider.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        centerPos = centerPos.m_6630_(new_y - centerPos.m_123342_());
        int maxsize = 119;
        TextData data = TextData.genData(this.char_spacing, 2 * maxsize, this.text);
        int line_height = 8 + this.line_spacing;
        int length = Math.min(2 * maxsize, data.longest_line());
        int height = Math.min(2 * maxsize, line_height * data.getLineCount());
        Direction dir = this.getDir(context);
        int ori = TextData.getOri(this.pol, dir);
        for (int i = 0; i < data.getLineCount(); ++i) {
            int line;
            for (int j = 0; j < data.getLineLen(i) && (line = -height / 2 + i * line_height) <= maxsize; ++j) {
                int len = -length / 2 + data.offsetMap().get(i).get(j);
                List<Integer> lst = TextData.storage.get(data.charMap().get(i).get(j));
                if (lst == null) continue;
                BlockPos letterOrigin = TextData.mutate(centerPos, ori, line, len);
                collector.m_142679_((StructurePiece)LetterPiece.of(letterOrigin, ori, lst, this.block));
            }
        }
    }
}

