/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import dev.architectury.platform.Platform;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.Timebombable;
import net.lerariemann.infinity.block.entity.TintableBlockEntity;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.BackportMethods;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public interface InfinityMethods {
    public static final String ofRandomDim = "infinity:random";
    public static final NormalNoise sampler = NormalNoise.m_230504_((RandomSource)new LegacyRandomSource(0L), (int)-5, (double[])InfinityMethods.genOctaves(2));

    public static double[] genOctaves(int octaves) {
        double[] a = new double[octaves];
        Arrays.fill(a, 1.0);
        return a;
    }

    public static double sample(BlockPos pos) {
        return sampler.m_75380_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static ResourceLocation getId(String value) {
        return ResourceLocation.m_214293_((String)"infinity", (String)value);
    }

    public static ResourceLocation getDimId(long value) {
        return InfinityMethods.getId("generated_" + value);
    }

    public static boolean isInfinity(Level w) {
        return InfinityMethods.isInfinity((ResourceKey<Level>)w.m_46472_());
    }

    public static boolean isInfinity(ResourceKey<Level> key) {
        return key.m_135782_().m_135827_().equals("infinity");
    }

    public static boolean isBiomeInfinity(LevelAccessor world, BlockPos pos) {
        AtomicBoolean bl = new AtomicBoolean(false);
        world.m_204166_(pos).m_203543_().ifPresent(key -> bl.set(key.m_135782_().m_135827_().equals("infinity")));
        return bl.get();
    }

    public static boolean isBiomeInfinity(Holder<Biome> b) {
        return ((ResourceKey)b.m_203543_().get()).m_135782_().m_135827_().equals("infinity");
    }

    public static boolean isBiomeInfinity(BlockGetter world, BlockPos pos) {
        if (world instanceof LevelAccessor) {
            LevelAccessor acc = (LevelAccessor)world;
            return InfinityMethods.isBiomeInfinity(acc, pos);
        }
        return Platform.isFabric() && world.hasBiomes() && world.getBiomeFabric(pos) instanceof Holder && InfinityMethods.isBiomeInfinity((Holder<Biome>)world.getBiomeFabric(pos));
    }

    public static boolean isFabricApiLoaded(String modID) {
        if (Platform.isFabric()) {
            return Platform.isModLoaded((String)modID.replace("_", "-"));
        }
        return Platform.isModLoaded((String)modID.replace("-", "_"));
    }

    public static double sample(int x, int y, int z) {
        return sampler.m_75380_((double)x, (double)y, (double)z);
    }

    public static int properMod(int a, int b) {
        int res = a % b;
        return res >= 0 ? res : b + res;
    }

    public static void sendUnexpectedError(ServerPlayer player, String type) {
        player.m_213846_((Component)Component.m_237115_((String)("error.infinity." + type + ".unexpected")));
    }

    public static ResourceLocation dimTextToId(String text) {
        if (text.equals("abatised redivides")) {
            return Level.f_46430_.m_135782_();
        }
        if (text.isEmpty()) {
            return InfinityMethods.getId("missingno");
        }
        String easterId = InfinityMod.provider.easterizer.getAsEaster(text);
        if (easterId != null) {
            return InfinityMethods.getId(easterId);
        }
        return InfinityMethods.getDimId(InfinityMethods.getDimensionSeed(text));
    }

    public static boolean isTimebombed(ServerLevel world) {
        return ((Timebombable)world).infinity$isTimebombed();
    }

    public static boolean dimExists(ServerLevel world) {
        return world != null && !InfinityMethods.isTimebombed(world);
    }

    public static long getDimensionSeed(String text) {
        HashCode f = Hashing.sha256().hashString((CharSequence)(text + InfinityMod.provider.salt), StandardCharsets.UTF_8);
        return InfinityMethods.longArithmeticEnabled() ? f.asLong() & Long.MAX_VALUE : (long)(f.asInt() & Integer.MAX_VALUE);
    }

    public static long getNumericFromId(ResourceLocation id) {
        long i;
        String dimensionName = id.m_135815_();
        String numericId = dimensionName.substring(dimensionName.lastIndexOf("_") + 1);
        try {
            i = Long.parseLong(numericId);
        }
        catch (Exception e) {
            i = InfinityMethods.getDimensionSeed(numericId);
        }
        return i;
    }

    private static float bookBoxSample(BlockPos pos, int offset) {
        return Mth.m_14036_((float)(0.5f * (1.0f + (float)sampler.m_75380_((double)(4 * pos.m_123341_()), (double)(4 * (pos.m_123342_() + offset)), (double)(4 * pos.m_123343_())))), (float)0.0f, (float)1.0f);
    }

    public static int getBookBoxColor(BlockState state, BlockAndTintGetter world, BlockPos pos, int tintIndex) {
        if (pos != null) {
            float r = InfinityMethods.bookBoxSample(pos, -1000);
            float g = InfinityMethods.bookBoxSample(pos, 0);
            float b = InfinityMethods.bookBoxSample(pos, 1000);
            return Mth.m_14159_((float)r, (float)g, (float)b);
        }
        return 0xFFFFFF;
    }

    public static int getOverlayColorFromComponents(ItemStack stack, int layer) {
        if (stack.m_41783_() != null) {
            if (layer == 1) {
                if (stack.m_150930_((Item)ModItems.TRANSFINITE_KEY.get())) {
                    return stack.m_41783_().m_128451_(ModComponentTypes.COLOR);
                }
                if (stack.m_150930_((Item)ModItems.BIOME_BOTTLE_ITEM.get())) {
                    return stack.m_41783_().m_128469_("BlockEntityTag").m_128451_("Color");
                }
                if (stack.m_150930_((Item)ModItems.F4.get())) {
                    return BackportMethods.getOrDefaultInt(stack, ModComponentTypes.COLOR, 10879231);
                }
            } else if (stack.m_150930_((Item)ModItems.CHROMATIC_MATTER.get()) || stack.m_150930_((Item)ModItems.CHROMATIC_WOOL.get()) || stack.m_150930_((Item)ModItems.CHROMATIC_CARPET.get())) {
                return stack.m_41783_().m_128451_(ModComponentTypes.COLOR);
            }
        }
        return 0xFFFFFF;
    }

    public static int getPortalItemColor(ItemStack stack, int layer) {
        return 65535;
    }

    public static int getBlockEntityColor(BlockState state, BlockAndTintGetter world, BlockPos pos, int tintIndex) {
        BlockEntity blockEntity;
        if (world != null && pos != null && (blockEntity = world.m_7702_(pos)) instanceof TintableBlockEntity) {
            TintableBlockEntity be = (TintableBlockEntity)blockEntity;
            Integer j = be.getTint();
            return j & 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public static int getKeyColorFromId(ResourceLocation id) {
        if (id.m_135827_().equals("infinity") && id.m_135815_().contains("generated_")) {
            return Math.toIntExact(InfinityMethods.getNumericFromId(id));
        }
        return 0;
    }

    public static long getRandomSeed(Random random) {
        return InfinityMethods.longArithmeticEnabled() ? random.nextLong() : (long)random.nextInt();
    }

    public static long getRandomSeed(RandomSource random) {
        return InfinityMethods.longArithmeticEnabled() ? random.m_188505_() : (long)random.m_188502_();
    }

    public static ResourceLocation getRandomId(Random random) {
        return InfinityMethods.getDimId(InfinityMethods.getRandomSeed(random));
    }

    public static ResourceLocation getRandomId(RandomSource random) {
        return InfinityMethods.getDimId(InfinityMethods.getRandomSeed(random));
    }

    public static MutableComponent getDimensionNameAsText(ResourceLocation dimension) {
        String name = dimension.toString();
        if (name.contains("infinity:generated_")) {
            return Component.m_237115_((String)"tooltip.infinity.key.generated").m_130946_(name.replace("infinity:generated_", ""));
        }
        if (name.equals(ofRandomDim)) {
            return Component.m_237115_((String)"tooltip.infinity.key.randomise");
        }
        return Component.m_264568_((String)Util.m_137492_((String)"dimension", (ResourceLocation)dimension), (String)InfinityMethods.formatAsTitleCase(dimension.m_135815_()));
    }

    public static String formatAsTitleCase(String text) {
        text = text.replaceAll("[_./]", " ");
        StringBuilder newText = new StringBuilder();
        int i = 0;
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        for (int j = 0; j < n; ++j) {
            Character c = Character.valueOf(cArray[j]);
            if (i == 0) {
                c = Character.valueOf(c.toString().toUpperCase().charAt(0));
            }
            newText.append(c);
            ++i;
            if (c.charValue() != ' ') continue;
            i = 0;
        }
        return newText.toString();
    }

    public static boolean chaosMobsEnabled() {
        return RandomProvider.rule("chaosMobsEnabled");
    }

    public static boolean longArithmeticEnabled() {
        return RandomProvider.rule("longArithmeticEnabled");
    }

    public static boolean isCreateLoaded() {
        if (Platform.isModLoaded((String)"create")) {
            return Platform.getMod((String)"create").getVersion().charAt(0) != '5';
        }
        return false;
    }
}

