/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util;

import com.google.common.collect.ImmutableSet;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.RegistrySupplier;
import java.nio.file.Path;
import java.util.function.Function;
import net.lerariemann.infinity.item.StarOfLangItem;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.forge.PlatformMethodsImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FlowingFluid;

public class PlatformMethods {
    public static boolean isFabricApiLoaded(String modID) {
        if (Platform.isFabric()) {
            return Platform.isModLoaded((String)modID.replace("_", "-"));
        }
        return Platform.isModLoaded((String)modID.replace("-", "_"));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static FriendlyByteBuf createPacketByteBufs() {
        return PlatformMethodsImpl.createPacketByteBufs();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E> PoiType registerPoi(ResourceLocation id, int i, int i1, ImmutableSet<E> es) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatformMethodsImpl.registerPoi((ResourceLocation)id, (int)var1_1, (int)var2_2, (ImmutableSet)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onWorldLoad(Object mixin, ServerLevel world) {
        void var1_1;
        PlatformMethodsImpl.onWorldLoad(mixin, (ServerLevel)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void unfreeze(Registry<?> registry) {
        PlatformMethodsImpl.unfreeze(registry);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void freeze(Registry<?> registry) {
        PlatformMethodsImpl.freeze(registry);
    }

    static double sample(int x, int y, int z) {
        return InfinityMethods.sampler.m_75380_((double)x, (double)y, (double)z);
    }

    public static int posToColor(BlockPos pos) {
        double r = PlatformMethods.sample(pos.m_123341_(), pos.m_123342_() - 10000, pos.m_123343_());
        double g = PlatformMethods.sample(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        double b = PlatformMethods.sample(pos.m_123341_(), pos.m_123342_() + 10000, pos.m_123343_());
        return (int)(256.0 * ((r + 1.0) / 2.0)) + 256 * ((int)(256.0 * ((g + 1.0) / 2.0)) + 256 * (int)(256.0 * ((b + 1.0) / 2.0)));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Item> void addAfter(RegistrySupplier<T> blockItem, ResourceKey<CreativeModeTab> group, Item item) {
        void var2_2;
        void var1_1;
        PlatformMethodsImpl.addAfter(blockItem, (ResourceKey<CreativeModeTab>)var1_1, (Item)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RegistrySupplier<? extends FlowingFluid> getIridescenceStill() {
        return PlatformMethodsImpl.getIridescenceStill();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RegistrySupplier<? extends FlowingFluid> getIridescenceFlowing() {
        return PlatformMethodsImpl.getIridescenceFlowing();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RegistrySupplier<LiquidBlock> getIridBlockForReg() {
        return PlatformMethodsImpl.getIridBlockForReg();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getRootConfigPath() {
        return PlatformMethodsImpl.getRootConfigPath();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigPath() {
        return PlatformMethodsImpl.getConfigPath();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static TagKey<Item> createItemTag(String id) {
        return PlatformMethodsImpl.createItemTag(id);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static TagKey<Block> createBlockTag(String id) {
        return PlatformMethodsImpl.createBlockTag(id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerFlammableBlock(RegistrySupplier<Block> block, int burn, int spread) {
        void var2_2;
        void var1_1;
        PlatformMethodsImpl.registerFlammableBlock(block, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean acidTest(Entity entity, boolean eyes) {
        void var1_1;
        return PlatformMethodsImpl.acidTest(entity, (boolean)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static double acidHeightTest(Entity entity) {
        return PlatformMethodsImpl.acidHeightTest(entity);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Function<Item.Properties, ? extends StarOfLangItem> getStarOfLangConstructor() {
        return PlatformMethodsImpl.getStarOfLangConstructor();
    }
}

