/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.config;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.lerariemann.infinity.util.config.DataCollection;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public class ConfigFactory<S, T> {
    Registry<S> reg;
    Function<ResourceKey<S>, T> extractor;

    ConfigFactory(Registry<S> reg, Function<ResourceKey<S>, T> extractor) {
        this.reg = reg;
        this.extractor = extractor;
    }

    static <S> ConfigFactory<S, String> of(Registry<S> r) {
        return new ConfigFactory<S, String>(r, key -> key.m_135782_().toString());
    }

    static <S, T> ConfigFactory<S, T> of(Registry<S> r, BiFunction<Registry<S>, ResourceKey<S>, T> extractor) {
        return new ConfigFactory<S, Object>(r, key -> extractor.apply(r, (ResourceKey)key));
    }

    static <S, T> ConfigFactory<S, T> of(Registry<S> reg, Function<ResourceKey<S>, T> extractor) {
        return new ConfigFactory<S, T>(reg, extractor);
    }

    void generate(String additionalPath, String name) {
        DataCollection.Logged collection = new DataCollection.Logged(additionalPath, name);
        this.reg.m_214010_().forEach(key -> {
            T entry = this.extractor.apply((ResourceKey<S>)key);
            if (entry != null) {
                collection.add(key.m_135782_().m_135827_(), entry);
            }
        });
        collection.save();
    }
}

