/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.lerariemann.infinity.util.config.ConfigFactory;
import net.lerariemann.infinity.util.config.DataCollection;
import net.lerariemann.infinity.util.config.SurfaceRuleScanner;
import net.lerariemann.infinity.util.var.ColorLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface ConfigGenerator {
    public static void generateAll(MinecraftServer server) {
        ConfigFactory.of(BuiltInRegistries.f_257033_).generate("misc", "items");
        ConfigFactory.of(BuiltInRegistries.f_257034_, ConfigGenerator::extractParticle).generate("misc", "particles");
        ConfigFactory.of(BuiltInRegistries.f_256780_, ConfigGenerator::extractMob).generate("extra", "mobs");
        ConfigFactory.of(BuiltInRegistries.f_256974_, ConfigGenerator::extractEffect).generate("extra", "effects");
        ConfigGenerator.generateSounds();
        ConfigGenerator.generateBlockTags();
        SurfaceRuleScanner.scan(server);
        RegistryAccess.Frozen manager = server.m_206579_();
        ConfigFactory.of(manager.m_175515_(Registries.f_256952_), ConfigGenerator::extractBiome).generate("extra", "biomes");
        ConfigFactory.of(manager.m_175515_(Registries.f_256944_), ConfigGenerator::extractStructure).generate("extra", "structures");
        ConfigFactory.of(manager.m_175515_(Registries.f_256911_), ConfigGenerator::extractFeature).generate("extra", "trees");
    }

    public static void generateSounds() {
        Registry r = BuiltInRegistries.f_256894_;
        DataCollection.Logged music = new DataCollection.Logged("misc", "music", "music tracks");
        DataCollection.Logged sounds = new DataCollection.Logged("misc", "sounds");
        r.m_214010_().forEach(a -> {
            ResourceLocation id = a.m_135782_();
            if (id.toString().contains("music")) {
                DataCollection.addIdentifier(music, id);
            } else {
                DataCollection.addIdentifier(sounds, id);
            }
        });
        sounds.save();
        music.save();
    }

    public static void generateBlockTags() {
        DataCollection.Logged tagMap = new DataCollection.Logged("misc", "tags", "block tags");
        BuiltInRegistries.f_256975_.m_203613_().forEach(tagKey -> DataCollection.addIdentifier(tagMap, tagKey.f_203868_()));
        tagMap.save();
    }

    public static Set<String> generateFluids() {
        DataCollection.Logged fluidMap = new DataCollection.Logged("blocks", "fluids");
        DefaultedRegistry r = BuiltInRegistries.f_257020_;
        HashSet<String> fluidBlockNames = new HashSet<String>();
        r.m_214010_().forEach(arg_0 -> ConfigGenerator.lambda$generateFluids$2(fluidBlockNames, (Registry)r, fluidMap, arg_0));
        fluidMap.save();
        return fluidBlockNames;
    }

    public static void generateBlocks(ServerLevel serverWorld, BlockPos inAir, BlockPos onAltar, Set<String> excludedBlockNames) {
        DataCollection.Logged blockMap = new DataCollection.Logged("blocks", "blocks");
        DataCollection colorPresetMap = new DataCollection("extra", "color_presets");
        DataCollection airMap = new DataCollection("blocks", "airs");
        DataCollection flowerMap = new DataCollection("blocks", "flowers");
        DefaultedRegistry r = BuiltInRegistries.f_256975_;
        r.m_214010_().forEach(arg_0 -> ConfigGenerator.lambda$generateBlocks$3(excludedBlockNames, (Registry)r, blockMap, serverWorld, inAir, onAltar, colorPresetMap, airMap, flowerMap, arg_0));
        blockMap.save();
        colorPresetMap.save();
        airMap.save();
        flowerMap.save();
    }

    public static ListTag checkColorSet(String block) {
        AtomicInteger successCounter = new AtomicInteger();
        ListTag colorSet = new ListTag();
        Arrays.stream(ColorLogic.vanillaColors).forEach(color -> {
            int i = block.lastIndexOf("magenta");
            String blockColored = block.substring(0, i) + color + block.substring(i + 7);
            if (BuiltInRegistries.f_256975_.m_7804_(new ResourceLocation(blockColored))) {
                successCounter.addAndGet(1);
                CompoundTag c = new CompoundTag();
                c.m_128359_("Name", blockColored);
                colorSet.add((Object)c);
            }
        });
        return successCounter.get() == ColorLogic.vanillaColors.length ? colorSet : null;
    }

    public static CompoundTag extractFluid(ResourceKey<Fluid> key) {
        Fluid b = (Fluid)BuiltInRegistries.f_257020_.m_6246_(key);
        if (!1.$assertionsDisabled && b == null) {
            throw new AssertionError();
        }
        CompoundTag res = new CompoundTag();
        String name = BuiltInRegistries.f_256975_.m_7981_((Object)b.m_76145_().m_76188_().m_60734_()).toString();
        res.m_128359_("Name", name);
        res.m_128359_("fluidName", key.m_135782_().toString());
        return res;
    }

    public static CompoundTag extractBlock(ResourceKey<Block> key, LevelReader w, BlockPos inAir, BlockPos onStone) {
        Block b = (Block)BuiltInRegistries.f_256975_.m_6246_(key);
        if (!1.$assertionsDisabled && b == null) {
            throw new AssertionError();
        }
        BlockState bs = b.m_49966_();
        CompoundTag res = new CompoundTag();
        res.m_128359_("Name", key.m_135782_().toString());
        res.m_128379_("laggy", ConfigGenerator.isLaggy(b));
        res.m_128379_("full", ConfigGenerator.isFull(bs, w, inAir));
        res.m_128379_("float", ConfigGenerator.isFloat(bs, w, inAir));
        CompoundTag properties = new CompoundTag();
        if (bs.m_61138_((Property)BlockStateProperties.f_61447_)) {
            properties.m_128359_("persistent", "true");
        }
        if (bs.m_61138_((Property)BlockStateProperties.f_61443_)) {
            properties.m_128359_("lit", "false");
        }
        if (bs.m_61138_((Property)BlockStateProperties.f_61376_)) {
            properties.m_128359_("face", "floor");
            bs = (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.FLOOR);
        }
        res.m_128379_("top", ConfigGenerator.isTop(bs, w, onStone));
        if (!properties.m_128456_()) {
            res.m_128365_("Properties", (Tag)properties);
        }
        return res;
    }

    public static boolean isLaggy(Block b) {
        return b.m_49966_().m_155947_();
    }

    public static boolean isTop(BlockState bs, LevelReader w, BlockPos onStone) {
        try {
            return bs.m_60710_(w, onStone);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFloat(BlockState bs, LevelReader w, BlockPos inAir) {
        try {
            return bs.m_60710_(w, inAir) && !(bs.m_60734_() instanceof FallingBlock);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFull(BlockState bs, LevelReader w, BlockPos inAir) {
        return Block.m_49916_((VoxelShape)bs.m_60812_((BlockGetter)w, inAir)) && Block.m_49916_((VoxelShape)bs.m_60808_((BlockGetter)w, inAir));
    }

    public static String extractParticle(ResourceKey<ParticleType<?>> key) {
        ResourceLocation id = key.m_135782_();
        if (!id.m_135827_().equals("minecraft") && !(BuiltInRegistries.f_257034_.m_7745_(id) instanceof SimpleParticleType)) {
            return null;
        }
        return id.toString();
    }

    public static CompoundTag extractMob(ResourceKey<EntityType<?>> key) {
        if (key.m_135782_().m_135827_().equals("minecolonies")) {
            return null;
        }
        MobCategory sg = ((EntityType)BuiltInRegistries.f_256780_.m_7745_(key.m_135782_())).m_20674_();
        if (sg == MobCategory.MISC) {
            return null;
        }
        CompoundTag mob = new CompoundTag();
        mob.m_128359_("Name", key.m_135782_().toString());
        mob.m_128359_("Category", sg.m_7912_());
        return mob;
    }

    public static CompoundTag extractEffect(ResourceKey<MobEffect> key) {
        CompoundTag res = new CompoundTag();
        Optional o = BuiltInRegistries.f_256974_.m_123009_(key);
        if (o.isEmpty()) {
            return null;
        }
        MobEffect effect = (MobEffect)o.get();
        res.m_128359_("Name", key.m_135782_().toString());
        res.m_128359_("Category", switch (effect.m_19483_()) {
            default -> throw new IncompatibleClassChangeError();
            case MobEffectCategory.HARMFUL -> "harmful";
            case MobEffectCategory.BENEFICIAL -> "beneficial";
            case MobEffectCategory.NEUTRAL -> "neutral";
        });
        res.m_128405_("Color", effect.m_19484_());
        res.m_128379_("Instant", effect.m_8093_());
        return res;
    }

    public static CompoundTag extractStructure(Registry<Structure> registry, ResourceKey<Structure> key) {
        ResourceLocation id = key.m_135782_();
        if (id.m_135827_().equals("infinity") && id.m_135815_().contains("_")) {
            return null;
        }
        Optional o = registry.m_123009_(key);
        if (o.isEmpty()) {
            return null;
        }
        Structure structure = (Structure)o.get();
        String step = structure.m_226619_().name().toLowerCase();
        String adaptation = structure.m_226620_().name().toLowerCase();
        CompoundTag overrides = ConfigGenerator.genOverrides(structure.m_226612_());
        CompoundTag res = new CompoundTag();
        res.m_128359_("id", id.toString());
        res.m_128359_("step", step);
        res.m_128365_("spawn_overrides", (Tag)overrides);
        res.m_128359_("terrain_adaptation", adaptation);
        return res;
    }

    public static CompoundTag genOverrides(Map<MobCategory, StructureSpawnOverride> overrides) {
        CompoundTag res = new CompoundTag();
        overrides.forEach((key, value) -> res.m_128365_(key.name().toLowerCase(), (Tag)ConfigGenerator.genOverride(value)));
        return res;
    }

    public static CompoundTag genOverride(StructureSpawnOverride spawns) {
        CompoundTag res = new CompoundTag();
        StructureSpawnOverride.BoundingBoxType box = spawns.f_210043_();
        res.m_128359_("bounding_box", box == StructureSpawnOverride.BoundingBoxType.PIECE ? "piece" : "full");
        res.m_128365_("spawns", (Tag)ConfigGenerator.genSpawns((WeightedRandomList<MobSpawnSettings.SpawnerData>)spawns.f_210044_()));
        return res;
    }

    public static ListTag genSpawns(WeightedRandomList<MobSpawnSettings.SpawnerData> entries) {
        ListTag lst = new ListTag();
        entries.m_146338_().forEach(entry -> lst.add((Object)ConfigGenerator.genEntry(entry)));
        return lst;
    }

    public static CompoundTag genEntry(MobSpawnSettings.SpawnerData entry) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", BuiltInRegistries.f_256780_.m_7981_((Object)entry.f_48404_).toString());
        res.m_128405_("maxCount", entry.f_48406_);
        res.m_128405_("minCount", entry.f_48405_);
        res.m_128405_("weight", entry.m_142631_().m_146281_());
        return res;
    }

    public static CompoundTag extractFeature(Registry<ConfiguredFeature<?, ?>> registry, ResourceKey<ConfiguredFeature<?, ?>> key) {
        ResourceLocation id = key.m_135782_();
        if (id.m_135827_().equals("infinity") && id.m_135815_().contains("_")) {
            return null;
        }
        if (id.toString().contains("bees")) {
            return null;
        }
        Optional o = registry.m_123009_(key);
        if (o.isEmpty()) {
            return null;
        }
        ConfiguredFeature feature = (ConfiguredFeature)o.get();
        String type = ConfigGenerator.getFeatureType(feature.f_65377_());
        if (type.isEmpty()) {
            return null;
        }
        CompoundTag res = new CompoundTag();
        res.m_128359_("Name", id.toString());
        res.m_128359_("Type", type);
        return res;
    }

    public static String getFeatureType(Feature<?> type) {
        if (type.equals((Object)Feature.f_65760_)) {
            return "tree";
        }
        if (type.equals((Object)Feature.f_65743_)) {
            return "huge_fungus";
        }
        if (type.equals((Object)Feature.f_65772_)) {
            return "huge_brown_mushroom";
        }
        if (type.equals((Object)Feature.f_65771_)) {
            return "huge_red_mushroom";
        }
        return "";
    }

    public static CompoundTag extractLootTable(Registry<LootTable> registry, ResourceKey<LootTable> key) {
        ResourceLocation id = key.m_135782_();
        Optional o = registry.m_123009_(key);
        if (o.isEmpty()) {
            return null;
        }
        LootTable table = (LootTable)o.get();
        ResourceLocation type = (ResourceLocation)LootContextParamSets.f_81422_.inverse().get((Object)table.m_79122_());
        if (type == null) {
            return null;
        }
        CompoundTag res = new CompoundTag();
        res.m_128359_("Name", id.toString());
        res.m_128359_("Type", type.m_135815_());
        return res;
    }

    public static CompoundTag extractBiome(Registry<Biome> registry, ResourceKey<Biome> key) {
        ResourceLocation id = key.m_135782_();
        if (id.m_135827_().equals("infinity")) {
            return null;
        }
        Optional o = registry.m_123009_(key);
        if (o.isEmpty()) {
            return null;
        }
        Biome biome = (Biome)o.get();
        CompoundTag res = new CompoundTag();
        res.m_128359_("Name", id.toString());
        res.m_128405_("Color", biome.m_47542_());
        return res;
    }

    private static /* synthetic */ void lambda$generateBlocks$3(Set excludedBlockNames, Registry r, DataCollection.Logged blockMap, ServerLevel serverWorld, BlockPos inAir, BlockPos onAltar, DataCollection colorPresetMap, DataCollection airMap, DataCollection flowerMap, ResourceKey key) {
        ListTag lst;
        String blockName = key.m_135782_().toString();
        if (excludedBlockNames.contains(blockName)) {
            return;
        }
        Block block = (Block)r.m_6246_(key);
        if (!1.$assertionsDisabled && block == null) {
            throw new AssertionError();
        }
        String modId = key.m_135782_().m_135827_();
        blockMap.add(modId, ConfigGenerator.extractBlock((ResourceKey<Block>)key, (LevelReader)serverWorld, inAir, onAltar));
        if (blockName.contains("magenta") && !ConfigGenerator.isLaggy(block) && ConfigGenerator.isFloat(block.m_49966_(), (LevelReader)serverWorld, inAir) && (lst = ConfigGenerator.checkColorSet(blockName)) != null) {
            colorPresetMap.add(modId, lst);
        }
        if (block.m_49966_().m_60795_()) {
            DataCollection.addIdentifier(airMap, key.m_135782_());
        }
        if (block.m_49966_().m_204336_(BlockTags.f_13037_)) {
            DataCollection.addIdentifier(flowerMap, key.m_135782_());
        }
    }

    private static /* synthetic */ void lambda$generateFluids$2(Set fluidBlockNames, Registry r, DataCollection.Logged fluidMap, ResourceKey a) {
        FlowingFluid fl;
        CompoundTag data = ConfigGenerator.extractFluid((ResourceKey<Fluid>)a);
        fluidBlockNames.add(data.m_128461_("Name"));
        Fluid f = (Fluid)r.m_7745_(a.m_135782_());
        if (f instanceof FlowingFluid && (fl = (FlowingFluid)f).equals(fl.m_5613_())) {
            String modId = a.m_135782_().m_135827_();
            fluidMap.add(modId, data);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

