/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.config;

import dev.architectury.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;

public interface ConfigManager {
    public static final Path tempFile = Platform.getConfigFolder().resolve(".infinity-temp.json");

    public static void updateInvocationLock() {
        File invlock = InfinityMod.invocationLock.toFile();
        if (!invlock.exists()) {
            return;
        }
        try {
            if (!ConfigManager.compareVersions(InfinityMod.invocationLock, InfinityMod.rootConfigPathInJar.resolve(".util/invocation.lock"))) {
                return;
            }
            try (Stream<Path> files = Files.walk(InfinityMod.configPath.resolve("modular"), new FileVisitOption[0]);){
                InfinityMod.LOGGER.info("Deleting outdated modular configs");
                files.map(Path::toFile).filter(File::isFile).forEach(f -> {
                    if (!f.delete()) {
                        InfinityMod.LOGGER.info("Cannot delete file {}", f);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unpackDefaultConfigs() {
        try (Stream<Path> files = Files.walk(InfinityMod.rootConfigPathInJar, new FileVisitOption[0]);){
            if (!InfinityMod.configPath.toFile().exists()) {
                Files.createDirectories(InfinityMod.configPath, new FileAttribute[0]);
            }
            files.filter(p -> p.toString().endsWith(".json")).forEach(p -> ConfigManager.registerConfig(p, InfinityMod.configPath));
            Files.deleteIfExists(tempFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean registerConfig(Path fromPath, Path toDirectory) {
        String path1 = fromPath.toString();
        String fullname = path1.substring(path1.lastIndexOf("config") + 6);
        Path endfile = Paths.get(String.valueOf(toDirectory) + fullname, new String[0]);
        try {
            if (!endfile.toFile().exists()) {
                String separator = Platform.isDevelopmentEnvironment() ? File.separator : "/";
                int i = fullname.lastIndexOf(separator);
                if (i > 0) {
                    String directory_name = fullname.substring(0, i);
                    Files.createDirectories(Paths.get(String.valueOf(InfinityMod.configPath) + directory_name, new String[0]), new FileAttribute[0]);
                }
                Files.copy(fromPath, endfile, new CopyOption[0]);
                return true;
            }
            if (ConfigManager.compareVersions(endfile, fromPath)) {
                Files.copy(fromPath, endfile, StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean compareVersions(Path oldFile, Path newFile) throws IOException {
        int version_old = CommonIO.getVersion(oldFile.toFile());
        Files.copy(newFile, tempFile, StandardCopyOption.REPLACE_EXISTING);
        int version_new = CommonIO.getVersion(tempFile.toFile());
        return version_new > version_old;
    }

    @Deprecated
    public static void evictOldFiles() {
        InfinityMod.LOGGER.info("Evicting old files");
        CompoundTag c = CommonIO.read(InfinityMod.utilPath.resolve("evicted_files.json"));
        ListTag l = c.m_128437_("content", 8);
        try {
            for (Tag e : l) {
                Path path1 = InfinityMod.configPath.resolve(e.m_7916_());
                LogManager.getLogger().info((Object)path1);
                if (!path1.toFile().exists()) continue;
                Path path2 = InfinityMod.configPath.resolve("evicted").resolve(e.m_7916_());
                Files.createDirectories(path2, new FileAttribute[0]);
                Files.copy(path1, path2, StandardCopyOption.REPLACE_EXISTING);
                Files.delete(path1);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

