/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.config;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;

@Deprecated
public record SoundScanner(Map<ResourceLocation, Resource> soundIds) {
    public static SoundScanner instance;

    public static boolean isPreloaded() {
        return instance != null;
    }

    public static Stream<ResourceLocation> getMatchingLoadedIds() {
        if (SoundScanner.isPreloaded()) {
            return SoundScanner.instance.soundIds.keySet().stream().filter(s -> s.m_135815_().contains("music") && !s.m_135815_().contains("record"));
        }
        return Stream.of(new ResourceLocation[0]);
    }

    public static CompoundTag saveResourcePack(Minecraft client, Stream<ResourceLocation> songIds, boolean sendJukeboxes) {
        CompoundTag soundsForRP = new CompoundTag();
        CompoundTag subtitlesForRP = new CompoundTag();
        CompoundTag jukeboxes = new CompoundTag();
        songIds.forEach(id -> {
            String str = id.toString().replace(".ogg", "").replace("sounds/", "");
            List<String> arr = Arrays.stream(str.split("[:/]")).toList();
            String songID = "disc." + arr.get(0) + "." + arr.get(arr.size() - 1);
            String subtitleID = "infinity:subtitles." + songID;
            String subtitleData = InfinityMethods.formatAsTitleCase(arr.get(0) + " - " + arr.get(arr.size() - 1));
            ListTag soundForRPList = new ListTag();
            soundForRPList.add((Object)StringTag.m_129297_((String)str));
            CompoundTag soundForRP = new CompoundTag();
            soundForRP.m_128365_("sounds", (Tag)soundForRPList);
            soundForRP.m_128359_("subtitle", subtitleID);
            subtitlesForRP.m_128359_(subtitleID, subtitleData);
            soundsForRP.m_128365_(songID, (Tag)soundForRP);
            if (sendJukeboxes) {
                double length;
                if (!SoundScanner.isPreloaded()) {
                    return;
                }
                try {
                    length = SoundScanner.calculateDuration(SoundScanner.instance.soundIds.get(id).m_215507_().readAllBytes());
                }
                catch (IOException e) {
                    length = 600.0;
                }
                jukeboxes.m_128365_(arr.get(arr.size() - 1), (Tag)SoundScanner.getJukeboxDef(songID, subtitleID, length));
            }
        });
        CommonIO.write(soundsForRP, client.m_245161_().resolve("infinity/assets/infinity"), "sounds.json");
        CommonIO.write(subtitlesForRP, client.m_245161_().resolve("infinity/assets/infinity/lang"), "en_us.json");
        return jukeboxes;
    }

    public static void unpackUploadedJukeboxes(MinecraftServer server, CompoundTag allJukeboxes) {
        Path pathJukeboxes = server.m_129843_(LevelResource.f_78180_).resolve("infinity/data/infinity/jukebox_song");
        for (String key : allJukeboxes.m_128431_()) {
            Tag tag = allJukeboxes.m_128423_(key);
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag jukebox = (CompoundTag)tag;
            CommonIO.write(jukebox, pathJukeboxes, key + ".json");
        }
    }

    public static double calculateDuration(byte[] track) throws IOException {
        ByteBuffer bb;
        byte[] byteArray;
        int i;
        int rate = -1;
        int length = -1;
        int size = track.length;
        for (i = size - 1 - 8 - 2 - 4; i >= 0 && length < 0; --i) {
            if (track[i] != 79 || track[i + 1] != 103 || track[i + 2] != 103 || track[i + 3] != 83) continue;
            byteArray = new byte[]{track[i + 6], track[i + 7], track[i + 8], track[i + 9], track[i + 10], track[i + 11], track[i + 12], track[i + 13]};
            bb = ByteBuffer.wrap(byteArray);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            length = bb.getInt(0);
        }
        for (i = 0; i < size - 8 - 2 - 4 && rate < 0; ++i) {
            if (track[i] != 118 || track[i + 1] != 111 || track[i + 2] != 114 || track[i + 3] != 98 || track[i + 4] != 105 || track[i + 5] != 115) continue;
            byteArray = new byte[]{track[i + 11], track[i + 12], track[i + 13], track[i + 14]};
            bb = ByteBuffer.wrap(byteArray);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            rate = bb.getInt(0);
        }
        return (double)length / (double)rate;
    }

    @NotNull
    private static CompoundTag getJukeboxDef(String songID, String subtitleID, double length) {
        CompoundTag jukebox_def = new CompoundTag();
        CompoundTag sound_event = new CompoundTag();
        sound_event.m_128359_("sound_id", "infinity:" + songID);
        jukebox_def.m_128365_("sound_event", (Tag)sound_event);
        CompoundTag description = new CompoundTag();
        description.m_128359_("translate", subtitleID);
        jukebox_def.m_128365_("description", (Tag)description);
        jukebox_def.m_128350_("length_in_seconds", (float)length);
        jukebox_def.m_128405_("comparator_output", 15);
        return jukebox_def;
    }
}

