/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.config;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.dimensions.RandomNoisePreset;
import net.lerariemann.infinity.util.config.DataCollection;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import org.jetbrains.annotations.Nullable;

public interface SurfaceRuleScanner {
    public static void scan(MinecraftServer server) {
        HashMap<String, CompoundTag> map = new HashMap<String, CompoundTag>();
        Registry registry = server.m_206579_().m_175515_(Registries.f_256932_);
        registry.m_214010_().forEach(key -> {
            if (!key.m_135782_().m_135827_().contains("infinity")) {
                Optional o = registry.m_123009_(key);
                o.ifPresent(settings -> {
                    Optional c = NoiseGeneratorSettings.f_64430_.encodeStart((DynamicOps)NbtOps.f_128958_, settings).result();
                    c.ifPresent(e -> {
                        Tree t = new Tree(((CompoundTag)e).m_128469_("surface_rule"));
                        t.biomeLocations.keySet().forEach(biome -> {
                            if (!map.containsKey(biome)) {
                                map.put((String)biome, t.wrappedRule((String)biome));
                            }
                        });
                    });
                });
            }
        });
        map.forEach((biome, value) -> {
            String biomename = biome.substring(biome.lastIndexOf(":") + 1) + ".json";
            String modname = biome.substring(0, biome.lastIndexOf(":"));
            String path = "config/infinity/modular/" + modname + "/surface_rule";
            CommonIO.writeSurfaceRule(value, path, biomename);
        });
        DataCollection.loggerOutput(map.size(), "surface rules");
    }

    public static class Tree {
        ArrayList<TreeLeaf> registry = new ArrayList();
        HashMap<String, ArrayList<Integer>> biomeLocations = new HashMap();

        Tree(CompoundTag surfaceRule) {
            TreeLeaf root = new TreeLeaf(new CompoundTag(), -1, null, false);
            this.add(surfaceRule, root);
        }

        static CompoundTag conditionCase(CompoundTag if_true, CompoundTag then_run) {
            CompoundTag c = new CompoundTag();
            c.m_128365_("if_true", (Tag)if_true);
            c.m_128365_("then_run", (Tag)then_run);
            c.m_128359_("type", "minecraft:condition");
            return c;
        }

        void addBiomeLoc(String s, Integer i) {
            if (!this.biomeLocations.containsKey(s)) {
                this.biomeLocations.put(s, new ArrayList());
            }
            this.biomeLocations.get(s).add(i);
        }

        TreeLeaf addOfRule(CompoundTag rule, TreeLeaf where, boolean terminal) {
            TreeLeaf l = new TreeLeaf(rule, this.registry.size(), where, terminal);
            this.registry.add(l);
            return l;
        }

        void add(CompoundTag rule, TreeLeaf where) {
            switch (rule.m_128461_("type")) {
                case "condition": 
                case "minecraft:condition": {
                    CompoundTag next = rule.m_128469_("then_run");
                    CompoundTag c = rule.m_128469_("if_true");
                    if (c.m_128461_("type").contains("above_preliminary_surface")) {
                        this.add(next, where);
                        break;
                    }
                    if (!c.m_128461_("type").contains("biome")) {
                        TreeLeaf l = this.addOfRule(c, where, false);
                        this.add(next, l);
                        break;
                    }
                    TreeLeaf l = this.addOfRule(next, where, true);
                    if (!Objects.requireNonNull(c.m_128423_("biome_is")).m_6458_().equals((Object)ListTag.f_128714_)) break;
                    c.m_128437_("biome_is", 8).forEach(e -> this.addBiomeLoc(e.m_7916_(), l.i));
                    break;
                }
                case "sequence": 
                case "minecraft:sequence": {
                    ListTag sq = rule.m_128437_("sequence", 10);
                    sq.forEach(e -> this.add((CompoundTag)e, where));
                    break;
                }
                default: {
                    if (Tree.checkUnneededParts(rule)) break;
                    TreeLeaf l = this.addOfRule(rule, where, true);
                    this.addBiomeLoc("minecraft:default", l.i);
                }
            }
        }

        static boolean checkUnneededParts(CompoundTag rule) {
            return rule.m_128461_("type").contains("block") && (rule.toString().contains("minecraft:bedrock") || rule.toString().contains("minecraft:deepslate"));
        }

        public CompoundTag wrappedRule(String biome) {
            CompoundTag c = new CompoundTag();
            ListTag l = new ListTag();
            l.add((Object)StringTag.m_129297_((String)biome));
            c.m_128365_("biomes", (Tag)l);
            c.m_128365_("rule", (Tag)this.extractRule(biome));
            return c;
        }

        public CompoundTag extractRule(String biome) {
            if (!this.biomeLocations.containsKey(biome)) {
                return null;
            }
            CompoundTag comp = RandomNoisePreset.startingRule("sequence");
            ListTag l = new ListTag();
            try {
                this.biomeLocations.get(biome).forEach(i -> l.add((Object)this.extractRule((int)i)));
                if (this.biomeLocations.containsKey("minecraft:default")) {
                    this.biomeLocations.get("minecraft:default").forEach(i -> l.add((Object)this.extractRule((int)i)));
                } else {
                    InfinityMod.LOGGER.warn("Default locations unexpectedly missing when processing surface rules for biome {}", (Object)biome);
                }
                comp.m_128365_("sequence", (Tag)l);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an unexpected exception when processing surface rules for biome " + biome + "\n" + e.getMessage());
            }
            this.biomeLocations.get(biome).forEach(i -> l.add((Object)this.extractRule((int)i)));
            if (this.biomeLocations.containsKey("minecraft:default")) {
                this.biomeLocations.get("minecraft:default").forEach(i -> l.add((Object)this.extractRule((int)i)));
            }
            comp.m_128365_("sequence", (Tag)l);
            return comp;
        }

        TreeLeaf getParent(TreeLeaf l) {
            if (l.i_parent == -1) {
                return l;
            }
            return this.registry.get(l.i_parent);
        }

        CompoundTag extractRule(int i) {
            TreeLeaf l = this.registry.get(i);
            assert (l.is_terminal);
            if (l.i_parent == -1) {
                return l.data;
            }
            return this.extractRule(this.getParent(l), l.data);
        }

        CompoundTag extractRule(TreeLeaf l, CompoundTag data) {
            CompoundTag newdata = Tree.conditionCase(l.data, data);
            if (l.i_parent == -1) {
                return newdata;
            }
            return this.extractRule(this.getParent(l), newdata);
        }

        static class TreeLeaf {
            CompoundTag data;
            int i;
            int i_parent;
            boolean is_terminal;

            TreeLeaf(CompoundTag c, int num, @Nullable TreeLeaf where, boolean e) {
                this.data = c;
                this.i = num;
                this.i_parent = where == null ? -1 : where.i;
                this.is_terminal = e;
            }
        }
    }
}

