/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.core;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.core.SaferStringReader;
import net.lerariemann.infinity.util.core.WeighedStructure;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.Mth;
import org.apache.commons.io.FileUtils;

public interface CommonIO {
    public static final int maxBound = 30000000;

    public static void write(CompoundTag base, String path, String filename) {
        CommonIO.write(CommonIO.compoundToString(base), Paths.get(path, new String[0]), filename);
    }

    public static void write(CompoundTag base, Path dir, String filename) {
        CommonIO.write(CommonIO.compoundToString(base), dir, filename);
    }

    public static void write(String source, Path dir, String filename) {
        List<String> lines = Collections.singletonList(source);
        filename = filename.replace("/", "_").replace("\\", "_");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(filename);
            Files.write(file, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeSurfaceRule(CompoundTag base, String path, String filename) {
        String source = CommonIO.compoundToString(base);
        Integer[] integerArray = new Integer[]{31, 62};
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int j = integerArray[i];
            for (int i2 = -5; i2 < 6; ++i2) {
                String z = Integer.toString(j + i2);
                source = source.replace("\"absolute\": " + z, "\"absolute\": " + (String)(i2 == 0 ? "%SL%" : "%SL" + (i2 > 0 ? "+" : "") + i2 + "%"));
            }
        }
        CommonIO.write(source, Paths.get(path, new String[0]), filename);
    }

    public static int getVersion(File file) {
        try {
            String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            if (!content.contains("infinity_version")) {
                return 0;
            }
            int i = content.indexOf("infinity_version");
            int end = content.indexOf(",", i);
            if (end == -1) {
                end = content.indexOf("\n", i);
            }
            return Integer.parseInt(content.substring(content.indexOf(" ", i) + 1, end).trim());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompoundTag read(String path) {
        return CommonIO.read(new File(path));
    }

    public static CompoundTag read(Path path) {
        return CommonIO.read(path.toFile());
    }

    public static CompoundTag read(File file) {
        try {
            if (file.exists()) {
                String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                CompoundTag c = SaferStringReader.parse(content);
                c.m_128473_("infinity_version");
                return c;
            }
            return new CompoundTag();
        }
        catch (CommandSyntaxException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompoundTag readAndFormat(String path, Object ... args) {
        File file = new File(path);
        try {
            String content = String.valueOf(new Formatter(Locale.US).format(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), args));
            CompoundTag c = TagParser.m_129359_((String)content);
            c.m_128473_("infinity_version");
            return c;
        }
        catch (CommandSyntaxException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompoundTag readAndAddCompound(String path, CompoundTag block) {
        return CommonIO.readAndFormat(path, CommonIO.compoundToString(block));
    }

    public static CompoundTag readSurfaceRule(File file, int seaLevel) {
        try {
            String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            CompoundTag c = CommonIO.formatSurfaceRule(content, seaLevel);
            c.m_128473_("infinity_version");
            return c;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompoundTag formatSurfaceRule(String content, int seaLevel) {
        int i = content.lastIndexOf("%");
        if (i == -1) {
            try {
                return TagParser.m_129359_((String)content);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (content.contains("%SL%")) {
            return CommonIO.formatSurfaceRule(content.replace("%SL%", String.valueOf(seaLevel)), seaLevel);
        }
        int j = content.lastIndexOf("%SL");
        String num = content.substring(j + 3, i);
        return CommonIO.formatSurfaceRule(content.replace("%SL" + num + "%", String.valueOf(seaLevel + Integer.parseInt(num))), seaLevel);
    }

    public static WeighedStructure<String> readStringList(String path) {
        CompoundTag base = CommonIO.read(path);
        WeighedStructure<String> res = new WeighedStructure<String>();
        ListTag list = base.m_128437_("elements", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag a = list.m_128728_(i);
            res.add(a.m_128461_("key"), a.m_128459_("weight"));
        }
        return res;
    }

    private static boolean _checkIfModLoaded(File path1) {
        if (!RandomProvider.rule("enforceModLoadedChecks")) {
            return true;
        }
        String modname = path1.toPath().getName(path1.toPath().getNameCount() - 1).toString();
        return Platform.isModLoaded((String)modname);
    }

    private static ListTag _extractElements(File path1, String subpath) {
        File file;
        if (CommonIO._checkIfModLoaded(path1) && (file = path1.toPath().resolve(subpath).toFile()).exists()) {
            CompoundTag base = CommonIO.read(file);
            return base.m_128437_("elements", 10);
        }
        return new ListTag();
    }

    public static <T> WeighedStructure<T> readWeighedList(Path path, String subPath, BiFunction<CompoundTag, String, T> infoGetter) {
        WeighedStructure<T> res = new WeighedStructure<T>();
        for (File path1 : Objects.requireNonNull(path.toFile().listFiles(File::isDirectory))) {
            ListTag list = CommonIO._extractElements(path1, subPath);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag a = list.m_128728_(i);
                res.add(infoGetter.apply(a, "key"), a.m_128459_("weight"));
            }
        }
        return res;
    }

    public static WeighedStructure<String> readStringList(Path path, String subPath) {
        return CommonIO.readWeighedList(path, subPath, CompoundTag::m_128461_);
    }

    public static WeighedStructure<Tag> readCompoundList(Path path, String subPath) {
        return CommonIO.readWeighedList(path, subPath, CompoundTag::m_128423_);
    }

    public static String appendTabs(String parent, int t) {
        return parent + "\t".repeat(Math.max(0, t));
    }

    public static String elementToString(Tag base, int t) {
        if (base == null) {
            return "!!NULL!!";
        }
        if (base instanceof CompoundTag) {
            CompoundTag nbtCompound = (CompoundTag)base;
            return CommonIO.compoundToString(nbtCompound, t + 1);
        }
        if (base instanceof ListTag) {
            ListTag nbtElements = (ListTag)base;
            return CommonIO.listToString(nbtElements, t + 1);
        }
        if (base instanceof ByteTag) {
            ByteTag nbtByte = (ByteTag)base;
            return nbtByte.m_7063_() != 0 ? "true" : "false";
        }
        if (base instanceof DoubleTag) {
            DoubleTag nbtDouble = (DoubleTag)base;
            return String.valueOf(CommonIO.boundsCheck(nbtDouble.m_7057_()));
        }
        if (base instanceof FloatTag) {
            FloatTag nbtFloat = (FloatTag)base;
            return String.valueOf(CommonIO.boundsCheck(nbtFloat.m_7057_()));
        }
        if (base instanceof LongTag) {
            LongTag nbtLong = (LongTag)base;
            return String.valueOf(CommonIO.boundsCheck(nbtLong.m_7046_()));
        }
        if (base instanceof IntTag) {
            IntTag nbtInt = (IntTag)base;
            return String.valueOf(CommonIO.boundsCheck(nbtInt.m_7047_()));
        }
        if (base instanceof ShortTag) {
            ShortTag nbtShort = (ShortTag)base;
            return String.valueOf(CommonIO.boundsCheck(nbtShort.m_7053_()));
        }
        if (base instanceof StringTag) {
            StringTag nbtString = (StringTag)base;
            return "\"" + nbtString.m_7916_().replace("\"", "\\\"") + "\"";
        }
        return base.toString();
    }

    public static float boundsCheck(float base) {
        return Mth.m_14036_((float)base, (float)-3.0E7f, (float)3.0E7f);
    }

    public static int boundsCheck(long base) {
        return (int)Mth.m_14036_((float)base, (float)-3.0E7f, (float)3.0E7f);
    }

    public static int boundsCheck(int base) {
        return Mth.m_14045_((int)base, (int)-30000000, (int)30000000);
    }

    public static String compoundToString(CompoundTag base) {
        return CommonIO.compoundToString(base, 0);
    }

    public static String compoundToString(CompoundTag base, int t) {
        Object res = "{\n";
        int i = base.m_128440_() - 1;
        for (String key : base.m_128431_()) {
            Tag elem = base.m_128423_(key);
            res = CommonIO.appendTabs((String)res, t + 1) + "\"" + key + "\": " + CommonIO.elementToString(elem, t);
            if (i != 0) {
                res = (String)res + ",";
            }
            res = (String)res + "\n";
            --i;
        }
        res = CommonIO.appendTabs((String)res, t) + "}";
        return res;
    }

    public static String listToString(ListTag base, int t) {
        Object res = "[\n";
        for (int i = 0; i < base.size(); ++i) {
            Tag elem = base.get(i);
            res = CommonIO.appendTabs((String)res, t + 1) + CommonIO.elementToString(elem, t);
            if (i != base.size() - 1) {
                res = (String)res + ",";
            }
            res = (String)res + "\n";
        }
        res = CommonIO.appendTabs((String)res, t) + "]";
        return res;
    }
}

