/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.core;

import java.nio.file.Path;
import java.util.List;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.core.WeighedStructure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public record CorePack(RandomProvider provider, Path savingPath) {
    void generate() {
        this.saveTrees();
        this.saveEndOfTime();
        if (!this.savingPath.resolve("pack.mcmeta").toFile().exists()) {
            this.savePackMcmeta();
        }
    }

    void savePackMcmeta() {
        CompoundTag res = new CompoundTag();
        CompoundTag pack = new CompoundTag();
        pack.m_128405_("pack_format", 34);
        pack.m_128359_("description", "Common content providers for Infinite Dimensions");
        res.m_128365_("pack", (Tag)pack);
        CommonIO.write(res, this.savingPath, "pack.mcmeta");
    }

    public static CompoundTag treePlacement(String tree, String block) {
        return CommonIO.readAndFormat(InfinityMod.utilPath.resolve("placements/tree_vanilla.json").toString(), tree, block);
    }

    void saveTrees() {
        WeighedStructure<Tag> treesReg = this.provider.compoundRegistry.get("trees");
        if (treesReg == null) {
            return;
        }
        List<String> trees = treesReg.keys.stream().map(compound -> ((CompoundTag)compound).m_128461_("Name")).toList();
        double size = trees.size();
        CompoundTag c = new CompoundTag();
        ListTag l = new ListTag();
        c.m_128365_("default", (Tag)CorePack.treePlacement(trees.get(0), "minecraft:grass_block"));
        int i = 1;
        while ((double)i < size) {
            CompoundTag c1 = new CompoundTag();
            c1.m_128365_("feature", (Tag)CorePack.treePlacement(trees.get(i), "minecraft:grass_block"));
            c1.m_128347_("chance", 1.0 / (size - (double)i + 1.0));
            l.add((Object)c1);
            ++i;
        }
        c.m_128365_("features", (Tag)l);
        CompoundTag c2 = new CompoundTag();
        c2.m_128359_("type", "minecraft:random_selector");
        c2.m_128365_("config", (Tag)c);
        CommonIO.write(c2, this.savingPath.resolve("data/infinity/worldgen/configured_feature"), "all_trees.json");
    }

    void saveEndOfTime() {
        CompoundTag res = new CompoundTag();
        for (String category : this.provider.getMobCategories()) {
            ListTag entries = new ListTag();
            for (String mob : this.provider.registry.get((Object)category).keys) {
                CompoundTag entry = new CompoundTag();
                entry.m_128359_("type", mob);
                entry.m_128405_("minCount", 1);
                entry.m_128405_("maxCount", 1);
                entry.m_128405_("weight", 1);
                entries.add((Object)entry);
            }
            res.m_128365_(category, (Tag)entries);
        }
        CommonIO.write(CommonIO.readAndAddCompound(InfinityMod.utilPath.resolve("end_of_time.json").toString(), res), this.savingPath.resolve("data/infinity/worldgen/biome"), "end.json");
    }
}

