/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.core;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class Easterizer {
    public Map<String, String> aliasMap = new HashMap<String, String>();
    public Map<String, CompoundTag> map = new HashMap<String, CompoundTag>();
    public Map<String, String> typeMap = new HashMap<String, String>();
    public Map<String, CompoundTag> optionmap = new HashMap<String, CompoundTag>();

    public Easterizer() {
        try (Stream<Path> files = Files.walk(InfinityMod.configPath.resolve("easter"), new FileVisitOption[0]);){
            files.filter(p -> p.toFile().isFile() && !p.toString().endsWith("_type.json")).forEach(p -> {
                String name = p.getFileName().toString().replace(".json", "");
                CompoundTag compound = CommonIO.read(p.toFile());
                if (compound.m_128441_("name")) {
                    name = compound.m_128461_("name");
                }
                if (compound.m_128441_("type")) {
                    this.typeMap.put(name, compound.m_128461_("type"));
                }
                if (compound.m_128425_("aliases", 9)) {
                    String finalName = name;
                    compound.m_128437_("aliases", 8).stream().map(e -> (StringTag)e).map(StringTag::m_7916_).forEach(alias -> this.aliasMap.put((String)alias, finalName));
                } else if (compound.m_128425_("aliases", 8)) {
                    this.aliasMap.put(compound.m_128461_("aliases"), name);
                }
                if (compound.m_128441_("options")) {
                    this.optionmap.put(name, compound.m_128469_("options"));
                }
                this.map.put(name, compound.m_128469_("generator"));
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean easterize(RandomDimension d) {
        String name = d.getName();
        if (!this.isEaster(d.getName())) {
            return false;
        }
        Object type = this.typeMap.getOrDefault(name, "default");
        if (!((String)type).contains(":")) {
            type = "infinity:" + (String)type;
        }
        d.data.m_128359_("type", (String)type);
        d.data.m_128365_("generator", (Tag)this.map.get(name));
        return true;
    }

    public static boolean isDisabled(String name) {
        return InfinityMod.provider.disabledDimensions.contains(name);
    }

    public String getAsEaster(String name) {
        if (this.aliasMap.containsKey(name)) {
            return this.aliasMap.get(name);
        }
        if (this.isEaster(name)) {
            return name;
        }
        return null;
    }

    public boolean isEaster(String name) {
        return this.map.containsKey(name) && !Easterizer.isDisabled(name);
    }
}

