/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.core;

import java.util.Random;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public interface NbtUtils {
    public static String test(CompoundTag data, String key, String def) {
        return data.m_128425_(key, 8) ? data.m_128461_(key) : def;
    }

    public static CompoundTag test(CompoundTag data, String key, CompoundTag def) {
        return data.m_128425_(key, 10) ? data.m_128469_(key) : def;
    }

    public static float test(CompoundTag data, String key, float def) {
        return data.m_128425_(key, 6) ? data.m_128457_(key) : def;
    }

    public static int test(CompoundTag data, String key, int def) {
        return data.m_128425_(key, 3) ? data.m_128451_(key) : def;
    }

    public static double test(CompoundTag data, String key, double def) {
        return data.m_128425_(key, 6) ? data.m_128459_(key) : def;
    }

    public static boolean test(CompoundTag data, String key, boolean def) {
        return data.m_128441_(key) ? data.m_128471_(key) : def;
    }

    public static String elementToName(Tag e) {
        if (e instanceof CompoundTag) {
            return ((CompoundTag)e).m_128461_("Name");
        }
        return e.m_7916_();
    }

    public static CompoundTag nameToElement(String block) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("Name", block);
        return res;
    }

    public static CompoundTag nameToFluid(String block) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("Name", block);
        res.m_128359_("fluidName", block);
        return res;
    }

    public static CompoundTag blockToSimpleStateProvider(CompoundTag block) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", "minecraft:simple_state_provider");
        res.m_128365_("state", (Tag)block);
        return res;
    }

    public static void addBounds(CompoundTag res, int lbound, int bound) {
        CompoundTag value = new CompoundTag();
        value.m_128405_("min_inclusive", lbound);
        value.m_128405_("max_inclusive", bound);
        res.m_128365_("value", (Tag)value);
    }

    public static void addBounds(CompoundTag res, Random random, int lbound, int bound) {
        int a = random.nextInt(lbound, bound);
        int b = random.nextInt(lbound, bound);
        NbtUtils.addBounds(res, Math.min(a, b), Math.max(a, b));
    }

    public static Tag randomIntProvider(Random random, int bound, boolean acceptDistributions) {
        return NbtUtils.randomIntProvider(random, 0, bound, acceptDistributions);
    }

    public static Tag randomIntProvider(Random random, int lbound, int bound, boolean acceptDistributions) {
        int i = random.nextInt(acceptDistributions ? 6 : 4);
        CompoundTag res = new CompoundTag();
        switch (i) {
            case 0: {
                res.m_128359_("type", "constant");
                res.m_128405_("value", random.nextInt(lbound, bound));
                return res;
            }
            case 1: 
            case 2: {
                res.m_128359_("type", i == 1 ? "uniform" : "biased_to_bottom");
                res.m_128365_("value", (Tag)RandomProvider.genBounds(lbound, bound));
                return res;
            }
            case 4: {
                res.m_128359_("type", "clamped");
                CompoundTag value = RandomProvider.genBounds(lbound, bound);
                value.m_128365_("source", NbtUtils.randomIntProvider(random, lbound, bound, false));
                res.m_128365_("value", (Tag)value);
                return res;
            }
            case 3: {
                res.m_128359_("type", "clamped_normal");
                CompoundTag value = RandomProvider.genBounds(lbound, bound);
                value.m_128347_("mean", (double)lbound + random.nextDouble() * (double)(bound - lbound));
                value.m_128347_("deviation", random.nextExponential());
                res.m_128365_("value", (Tag)value);
                return res;
            }
            case 5: {
                res.m_128359_("type", "weighted_list");
                int j = 2 + random.nextInt(0, 5);
                ListTag list = new ListTag();
                for (int k = 0; k < j; ++k) {
                    CompoundTag element = new CompoundTag();
                    element.m_128365_("data", NbtUtils.randomIntProvider(random, lbound, bound, false));
                    element.m_128405_("weight", random.nextInt(100));
                    list.add((Object)element);
                }
                res.m_128365_("distribution", (Tag)list);
                return res;
            }
        }
        return res;
    }

    public static CompoundTag randomHeightProvider(Random random, int lbound, int bound, boolean acceptDistributions, boolean trim) {
        int i = random.nextInt(acceptDistributions ? 6 : 5);
        String[] types = new String[]{"uniform", "biased_to_bottom", "very_biased_to_bottom", "trapezoid", "constant", "weighted_list"};
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", types[i]);
        switch (i) {
            case 4: {
                CompoundTag value = new CompoundTag();
                value.m_128405_("absolute", random.nextInt(lbound, bound));
                res.m_128365_("value", (Tag)value);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int max;
                int min;
                CompoundTag min_inclusive = new CompoundTag();
                CompoundTag max_inclusive = new CompoundTag();
                if (!trim && i == 3) {
                    int center = random.nextInt(lbound, bound);
                    int sigma = random.nextInt(bound - lbound);
                    min = center - sigma;
                    max = center + sigma;
                } else {
                    int k = random.nextInt(lbound, bound);
                    int j = random.nextInt(lbound, bound);
                    min = Math.min(k, j);
                    max = Math.max(k, j);
                }
                min_inclusive.m_128405_("absolute", min);
                max_inclusive.m_128405_("absolute", max);
                res.m_128365_("min_inclusive", (Tag)min_inclusive);
                res.m_128365_("max_inclusive", (Tag)max_inclusive);
                int randomBound = max - min;
                if (randomBound <= 1) {
                    InfinityMod.LOGGER.debug("Corrected random bound of: {} to 2!", (Object)randomBound);
                    randomBound = 2;
                }
                if (i == 3 && random.nextBoolean()) {
                    res.m_128405_("plateau", random.nextInt(1, randomBound));
                    break;
                }
                if (i == 0) break;
                res.m_128405_("inner", 1 + (int)Math.floor(random.nextExponential()));
                break;
            }
            case 5: {
                int j = 2 + random.nextInt(0, 5);
                ListTag list = new ListTag();
                for (int k = 0; k < j; ++k) {
                    CompoundTag element = new CompoundTag();
                    element.m_128365_("data", (Tag)NbtUtils.randomHeightProvider(random, lbound, bound, false, trim));
                    element.m_128405_("weight", random.nextInt(100));
                    list.add((Object)element);
                }
                res.m_128365_("distribution", (Tag)list);
            }
        }
        return res;
    }

    public static CompoundTag randomFloatProvider(Random random, float lbound, float bound) {
        int i = random.nextInt(3);
        String[] types = new String[]{"uniform", "clamped_normal", "trapezoid"};
        CompoundTag res = new CompoundTag();
        res.m_128359_("type", types[i]);
        CompoundTag value = new CompoundTag();
        float a = random.nextFloat(lbound, bound);
        float b = random.nextFloat(lbound, bound);
        float min = Math.min(a, b);
        float max = Math.max(a, b);
        switch (i) {
            case 0: {
                value.m_128350_("max_exclusive", max);
                value.m_128350_("min_inclusive", min);
                break;
            }
            case 1: {
                value.m_128350_("max", max);
                value.m_128350_("min", min);
                value.m_128350_("mean", random.nextFloat(min, max));
                value.m_128350_("deviation", random.nextFloat(max - min));
                break;
            }
            case 2: {
                value.m_128350_("max", max);
                value.m_128350_("min", min);
                value.m_128350_("plateau", random.nextFloat(max - min));
            }
        }
        res.m_128365_("value", (Tag)value);
        return res;
    }
}

