/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.core;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.CorePack;
import net.lerariemann.infinity.util.core.Easterizer;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.lerariemann.infinity.util.core.WeighedStructure;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;

public class RandomProvider {
    public Map<String, WeighedStructure<String>> registry = new HashMap<String, WeighedStructure<String>>();
    public Map<String, WeighedStructure<Tag>> compoundRegistry = new HashMap<String, WeighedStructure<Tag>>();
    private final Map<String, Double> rootChances = new HashMap<String, Double>();
    private final Map<String, Boolean> gameRules = new HashMap<String, Boolean>();
    private final Map<String, Integer> gameRulesInt = new HashMap<String, Integer>();
    private final Map<String, Double> gameRulesDouble = new HashMap<String, Double>();
    public ArrayList<String> disabledDimensions = new ArrayList();
    public Path savingPath;
    private String portalKey;
    public String salt;
    public Easterizer easterizer;
    public static final Map<String, String> defaultMap = Map.ofEntries(Map.entry("all_blocks", "minecraft:stone"), Map.entry("top_blocks", "minecraft:stone"), Map.entry("blocks_features", "minecraft:stone"), Map.entry("full_blocks", "minecraft:stone"), Map.entry("full_blocks_worldgen", "minecraft:stone"), Map.entry("fluids", "minecraft:water"), Map.entry("items", "minecraft:stick"), Map.entry("sounds", "minecraft:block.stone.step"), Map.entry("music", "minecraft:music.game"), Map.entry("particles", "minecraft:heart"), Map.entry("biomes", "minecraft:plains"), Map.entry("mobs", "minecraft:pig"), Map.entry("tags", "minecraft:air"), Map.entry("trees", "minecraft:oak"), Map.entry("loot_tables", "minecraft:blocks/stone"));

    public RandomProvider() {
        this.registerAll();
        this.easterizer = new Easterizer();
    }

    public RandomProvider(Path savingPath) {
        this();
        this.savingPath = savingPath;
        new CorePack(this, savingPath).generate();
    }

    public Optional<Item> getPortalKeyAsItem() {
        if (this.portalKey.isBlank()) {
            return Optional.empty();
        }
        return BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(this.portalKey));
    }

    public boolean isPortalKeyBlank() {
        return this.getPortalKeyAsItem().isEmpty();
    }

    public boolean roll(Random random, String key) {
        return random.nextDouble() < this.rootChances.getOrDefault(key, 0.0);
    }

    private static <T> T getStaticRule(BiFunction<RandomProvider, String, T> applier, BiFunction<CompoundTag, String, T> applier2, String key, T def) {
        if (InfinityMod.provider != null) {
            return applier.apply(InfinityMod.provider, key);
        }
        Path root = InfinityMod.configPath.resolve("infinity.json");
        if (!root.toFile().exists()) {
            return def;
        }
        CompoundTag rules = CommonIO.read(InfinityMod.configPath.resolve("infinity.json")).m_128469_("gameRules");
        if (!rules.m_128441_(key)) {
            return def;
        }
        return applier2.apply(rules, key);
    }

    public static boolean rule(String key) {
        return RandomProvider.getStaticRule((p, k) -> p.gameRules.getOrDefault(k, false), CompoundTag::m_128471_, key, false);
    }

    public static int ruleInt(String key) {
        return RandomProvider.getStaticRule(RandomProvider::_ruleInt, (p, k) -> ((NumericTag)Objects.requireNonNull(p.m_128423_(k))).m_7047_(), key, -1);
    }

    private int _ruleInt(String key) {
        if (this.gameRulesInt.containsKey(key)) {
            return this.gameRulesInt.get(key);
        }
        return this.gameRulesDouble.get(key).intValue();
    }

    public String randomName(Random random, String key) {
        return this.randomName(random.nextDouble(), key);
    }

    public String randomName(RandomSource random, String key) {
        return this.randomName(random.m_188500_(), key);
    }

    public String randomName(double d, String key) {
        if (this.compoundRegistry.containsKey(key)) {
            return NbtUtils.elementToName(this.compoundRegistry.get(key).getElement(d));
        }
        if (this.registry.containsKey(key)) {
            return this.registry.get(key).getElement(d);
        }
        return defaultMap.get(key);
    }

    public CompoundTag randomElement(RandomSource random, String key) {
        return this.randomElement(random.m_188500_(), key);
    }

    public CompoundTag randomElement(Random random, String key) {
        return this.randomElement(random.nextDouble(), key);
    }

    public CompoundTag randomElement(double d, String key) {
        return this.randomElementInternal(d, key, key.equals("fluids") ? NbtUtils::nameToFluid : NbtUtils::nameToElement);
    }

    private CompoundTag randomElementInternal(double d, String key, Function<String, CompoundTag> converter) {
        if (this.compoundRegistry.containsKey(key)) {
            Tag compound = this.compoundRegistry.get(key).getElement(d);
            if (compound instanceof CompoundTag) {
                return (CompoundTag)compound;
            }
            if (compound instanceof StringTag) {
                return converter.apply(compound.m_7916_());
            }
        } else if (this.registry.containsKey(key)) {
            return converter.apply(this.registry.get(key).getElement(d));
        }
        return converter.apply(defaultMap.get(key));
    }

    void registerAll() {
        this.readRootConfig();
        this.registerCategory(this.registry, "misc", CommonIO::readStringList);
        this.registerCategory(this.registry, "features", CommonIO::readStringList);
        this.registerCategory(this.registry, "vegetation", CommonIO::readStringList);
        this.registerCategory(this.compoundRegistry, "blocks", CommonIO::readCompoundList);
        this.extractBlocks();
        this.registerCategory(this.compoundRegistry, "extra", CommonIO::readCompoundList);
        this.extractMobs();
        this.registerHardcoded();
    }

    void readRootConfig() {
        CompoundTag rootConfig = CommonIO.read(InfinityMod.configPath.resolve("infinity.json"));
        this.portalKey = rootConfig.m_128461_("portalKey");
        this.salt = rootConfig.m_128461_("salt");
        CompoundTag gamerules = rootConfig.m_128469_("gameRules");
        for (Object s : gamerules.m_128431_()) {
            Tag elem = gamerules.m_128423_((String)s);
            if (elem == null) continue;
            if (elem.m_7060_() == 3) {
                this.gameRulesInt.put((String)s, gamerules.m_128451_((String)s));
            }
            if (elem.m_7060_() == 6) {
                this.gameRulesDouble.put((String)s, gamerules.m_128459_((String)s));
                continue;
            }
            this.gameRules.put((String)s, gamerules.m_128471_((String)s));
        }
        CompoundTag rootchances = rootConfig.m_128469_("rootChances");
        for (String c : rootchances.m_128431_()) {
            for (String s : rootchances.m_128469_(c).m_128431_()) {
                this.rootChances.put(s, rootchances.m_128469_(c).m_128459_(s));
            }
        }
        ListTag disableddimensions = rootConfig.m_128437_("disabledDimensions", 8);
        for (Tag jsonElement : disableddimensions) {
            this.disabledDimensions.add(jsonElement.m_7916_());
        }
    }

    void extractBlocks() {
        if (this.compoundRegistry.containsKey("blocks")) {
            WeighedStructure<Tag> blocksSettings = this.compoundRegistry.get("blocks");
            WeighedStructure<CompoundTag> allBlocks = new WeighedStructure<CompoundTag>();
            WeighedStructure<CompoundTag> blocksFeatures = new WeighedStructure<CompoundTag>();
            WeighedStructure<CompoundTag> topBlocks = new WeighedStructure<CompoundTag>();
            WeighedStructure<CompoundTag> fullBlocks = new WeighedStructure<CompoundTag>();
            WeighedStructure<CompoundTag> fullBlocksWG = new WeighedStructure<CompoundTag>();
            for (int i = 0; i < blocksSettings.keys.size(); ++i) {
                CompoundTag e = (CompoundTag)blocksSettings.keys.get(i);
                boolean isfull = RandomProvider.popBlockData(e, "full", false);
                boolean islaggy = RandomProvider.popBlockData(e, "laggy", false);
                boolean isfloat = RandomProvider.popBlockData(e, "float", isfull);
                boolean istop = RandomProvider.popBlockData(e, "top", isfull);
                istop = istop || isfloat;
                Double w = blocksSettings.weights.get(i);
                allBlocks.add(e, w);
                if (isfull) {
                    fullBlocks.add(e, w);
                }
                if (istop && !islaggy) {
                    topBlocks.add(e, w);
                }
                if (isfloat) {
                    blocksFeatures.add(e, w);
                }
                if (!isfull || !isfloat || islaggy) continue;
                fullBlocksWG.add(e, w);
            }
            this.compoundRegistry.put("all_blocks", allBlocks);
            this.compoundRegistry.put("blocks_features", blocksFeatures);
            this.compoundRegistry.put("full_blocks", fullBlocks);
            this.compoundRegistry.put("full_blocks_worldgen", fullBlocksWG);
            this.compoundRegistry.put("top_blocks", topBlocks);
            this.compoundRegistry.remove("blocks");
        }
    }

    static boolean popBlockData(CompoundTag e, String key, boolean def) {
        boolean res = NbtUtils.test(e, key, def);
        e.m_128473_(key);
        return res;
    }

    void extractMobs() {
        if (this.compoundRegistry.containsKey("mobs")) {
            WeighedStructure<Tag> allmobs = this.compoundRegistry.get("mobs");
            WeighedStructure<String> allMobNames = new WeighedStructure<String>();
            for (int i = 0; i < allmobs.size(); ++i) {
                Object t = allmobs.keys.get(i);
                if (!(t instanceof CompoundTag)) continue;
                CompoundTag mob = (CompoundTag)t;
                String group = mob.m_128461_("Category");
                if (!this.registry.containsKey(group)) {
                    this.registry.put(group, new WeighedStructure());
                }
                this.registry.get(group).add(mob.m_128461_("Name"), allmobs.weights.get(i));
                allMobNames.add(mob.m_128461_("Name"), allmobs.weights.get(i));
            }
            this.registry.put("mobs", allMobNames);
            this.compoundRegistry.remove("mobs");
        }
    }

    <B> void registerCategory(Map<String, B> reg, String subpath, ListReader<B> reader) {
        Path path = InfinityMod.configPath.resolve("modular");
        try (Stream<Path> files = Files.walk(path.resolve("minecraft").resolve(subpath), new FileVisitOption[0]);){
            files.filter(p -> p.toFile().isFile()).forEach(p -> {
                String fullname = p.toString();
                String name = p.getFileName().toString().replace(".json", "");
                int i = fullname.replace("minecraft_", "%%%").lastIndexOf("minecraft");
                String sub = fullname.substring(i + 10);
                reg.put(name, reader.op(path, sub));
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void registerHardcoded() {
        try (Stream<Path> files = Files.walk(InfinityMod.configPath.resolve("hardcoded"), new FileVisitOption[0]);){
            files.map(Path::toString).filter(s -> s.endsWith(".json")).forEach(fullname -> {
                String name = fullname.substring(fullname.lastIndexOf("/") + 1, fullname.length() - 5);
                if (!(name = name.substring(name.lastIndexOf(92) + 1)).equals("none")) {
                    this.registry.put(name, CommonIO.readStringList(fullname));
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getMobCategories() {
        return this.registry.get((Object)"mob_categories").keys;
    }

    public CompoundTag blockToProvider(CompoundTag block, Random random) {
        CompoundTag res = new CompoundTag();
        boolean isRotatable = ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(block.m_128461_("Name")))).m_49966_().m_61147_().contains(BlockStateProperties.f_61365_);
        res.m_128359_("type", isRotatable && this.roll(random, "rotate_blocks") ? "minecraft:rotated_block_provider" : "minecraft:simple_state_provider");
        res.m_128365_("state", (Tag)block);
        return res;
    }

    public CompoundTag randomBlockProvider(Random random, String key) {
        return this.blockToProvider(this.randomElement(random, key), random);
    }

    public CompoundTag randomPreset(Random random, String key) {
        Tag list = this.compoundRegistry.get("color_presets").getRandomElement(random);
        CompoundTag res = new CompoundTag();
        if (list instanceof ListTag) {
            ListTag lst = (ListTag)list;
            res.m_128359_("type", key);
            if (key.equals("noise_provider")) {
                res.m_128405_("seed", 0);
                res.m_128347_("scale", 4.0);
                res.m_128365_("states", (Tag)lst);
                res.m_128365_("noise", (Tag)CommonIO.read(String.valueOf(InfinityMod.utilPath) + "/noise.json"));
            }
            if (key.equals("weighted_state_provider")) {
                ListTag entries = new ListTag();
                for (Tag block : lst) {
                    CompoundTag entry = new CompoundTag();
                    entry.m_128365_("data", block);
                    entry.m_128347_("weight", 1.0);
                    entries.add((Object)entry);
                }
                res.m_128365_("entries", (Tag)entries);
            }
        }
        return res;
    }

    public static CompoundTag genBounds(int lbound, int bound) {
        CompoundTag value = new CompoundTag();
        value.m_128405_("min_inclusive", lbound);
        value.m_128405_("max_inclusive", bound);
        return value;
    }

    public void kickGhostsOut(RegistryAccess s) {
        Registry reg = s.m_175515_(Registries.f_256952_);
        WeighedStructure<String> biomes = this.registry.get("biomes");
        if (biomes != null) {
            int i = 0;
            while (i < biomes.keys.size()) {
                if (!reg.m_7804_(new ResourceLocation((String)biomes.keys.get(i)))) {
                    biomes.kick(i);
                    continue;
                }
                ++i;
            }
            this.registry.put("biomes", biomes);
        }
    }

    static interface ListReader<B> {
        public B op(Path var1, String var2);
    }
}

