/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;

public class WeighedStructure<T> {
    public List<T> keys = new ArrayList<T>();
    public List<Double> weights = new ArrayList<Double>();
    private double statsum = 0.0;

    public void add(T key, double weight) {
        this.statsum += weight;
        this.keys.add(key);
        this.weights.add(weight);
    }

    public int size() {
        return this.keys.size();
    }

    public T getRandomElement(Random random) {
        return this.getRandomElement(random::nextDouble);
    }

    public T getRandomElement(Supplier<Double> random) {
        return this.getElement(random.get());
    }

    public T getElement(double d) {
        int i;
        double r = d * this.statsum;
        for (i = 0; i < this.size() - 1 && !((r -= this.weights.get(i).doubleValue()) <= 0.0); ++i) {
        }
        return this.keys.get(i);
    }

    public List<T> getAllElements(Random random) {
        ArrayList<T> res = new ArrayList<T>();
        for (int i = 0; i < this.size() - 1; ++i) {
            if (!(random.nextDouble() < this.weights.get(i))) continue;
            res.add(this.keys.get(i));
        }
        return res;
    }

    public void kick(int i) {
        this.statsum -= this.weights.get(i).doubleValue();
        this.keys.remove(i);
        this.weights.remove(i);
    }
}

