/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.forge;

import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.Unpooled;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.lerariemann.infinity.fluids.forge.IridescenceLiquidBlockForge;
import net.lerariemann.infinity.fluids.forge.ModFluidsForge;
import net.lerariemann.infinity.item.StarOfLangItem;
import net.lerariemann.infinity.item.forge.StarOfLangItemForge;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

public class PlatformMethodsImpl {
    public static FriendlyByteBuf createPacketByteBufs() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static void onWorldLoad(Object mixin, ServerLevel world) {
        MinecraftServer server = world.m_7654_();
        server.forgeGetWorldMap().put(world.m_46472_(), world);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)world));
    }

    public static void unfreeze(Registry<?> registry) {
        MappedRegistry writableRegistry = (MappedRegistry)registry;
        writableRegistry.unfreeze();
    }

    public static void freeze(Registry<?> registry) {
        registry.m_203521_();
    }

    public static <T extends Item> void addAfter(RegistrySupplier<T> supplier, ResourceKey<CreativeModeTab> group, Item item) {
        if (InfinityMethods.isFabricApiLoaded("fabric-item-group-api-v1")) {
            ItemGroupEvents.modifyEntriesEvent(group).register(content -> content.addAfter((ItemLike)item, new ItemLike[]{(ItemLike)supplier.get()}));
        }
    }

    public static RegistrySupplier<ForgeFlowingFluid.Source> getIridescenceStill() {
        return ModFluidsForge.IRIDESCENCE_STILL;
    }

    public static RegistrySupplier<ForgeFlowingFluid.Flowing> getIridescenceFlowing() {
        return ModFluidsForge.IRIDESCENCE_FLOWING;
    }

    public static RegistrySupplier<LiquidBlock> getIridBlockForReg() {
        return ModBlocks.BLOCKS.register("iridescence", () -> new IridescenceLiquidBlockForge((Supplier<? extends FlowingFluid>)PlatformMethods.getIridescenceStill(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_284180_(MapColor.f_283931_)));
    }

    public static Path getRootConfigPath() {
        return ModLoadingContext.get().getActiveContainer().getModInfo().getOwningFile().getFile().findResource(new String[]{"config"});
    }

    public static Path getConfigPath() {
        return Path.of(String.valueOf(FMLPaths.CONFIGDIR.get()) + "/infinity", new String[0]);
    }

    public static TagKey<Item> createItemTag(String id) {
        return ItemTags.create((ResourceLocation)InfinityMethods.getId(id));
    }

    public static TagKey<Block> createBlockTag(String id) {
        return BlockTags.create((ResourceLocation)InfinityMethods.getId(id));
    }

    public static void registerFlammableBlock(RegistrySupplier<Block> block, int burn, int spread) {
        if (InfinityMethods.isFabricApiLoaded("fabric-content-registries-v0")) {
            FlammableBlockRegistry.getDefaultInstance().add((Block)block.get(), burn, spread);
        }
    }

    public static boolean acidTest(Entity entity, boolean eyes) {
        if (entity instanceof Player) {
            return false;
        }
        if (eyes) {
            return entity.isEyeInFluidType((FluidType)ModFluidsForge.IRIDESCENCE_TYPE.get());
        }
        return entity.isInFluidType((FluidType)ModFluidsForge.IRIDESCENCE_TYPE.get());
    }

    public static double acidHeightTest(Entity entity) {
        if (entity instanceof Player) {
            return -1.0;
        }
        return entity.getFluidTypeHeight((FluidType)ModFluidsForge.IRIDESCENCE_TYPE.get());
    }

    public static Function<Item.Properties, ? extends StarOfLangItem> getStarOfLangConstructor() {
        return StarOfLangItemForge::new;
    }
}

