/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.loading;

import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.loading.JsonGrabber;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class DimensionGrabber {
    RegistryOps.RegistryInfoLookup registryInfoGetter;
    RegistryAccess baseRegistryManager;

    public DimensionGrabber(RegistryAccess brm) {
        this.baseRegistryManager = brm;
        ArrayList entries = new ArrayList();
        this.baseRegistryManager.m_206193_().forEach(entry -> {
            PlatformMethods.unfreeze(entry.f_206234_());
            entries.add((WritableRegistry)entry.f_206234_());
        });
        this.registryInfoGetter = this.getGetter(entries);
    }

    public LevelStem grab_all(RandomDimension d) {
        Path rootdir = Paths.get(d.getStoragePath(), new String[0]);
        this.buildGrabber(ConfiguredFeature.f_65373_, Registries.f_256911_).grabAll(rootdir.resolve("worldgen/configured_feature"));
        this.buildGrabber(PlacedFeature.f_191772_, Registries.f_256988_).grabAll(rootdir.resolve("worldgen/placed_feature"), true);
        this.buildGrabber(ConfiguredWorldCarver.f_64846_, Registries.f_257003_).grabAll(rootdir.resolve("worldgen/configured_carver"));
        this.buildGrabber(Biome.f_47429_, Registries.f_256952_).grabAll(rootdir.resolve("worldgen/biome"));
        this.buildGrabber(Structure.f_226553_, Registries.f_256944_).grabAll(rootdir.resolve("worldgen/structure"));
        this.buildGrabber(StructureSet.f_210001_, Registries.f_256998_).grabAll(rootdir.resolve("worldgen/structure_set"));
        this.buildGrabber(NoiseGeneratorSettings.f_64430_, Registries.f_256932_).grabAll(rootdir.resolve("worldgen/noise_settings"));
        this.buildGrabber(DimensionType.f_63843_, Registries.f_256787_).grabAll(rootdir.resolve("dimension_type"));
        return this.grab_dimension(rootdir, d.getName());
    }

    public <T> JsonGrabber<T> buildGrabber(Codec<T> codec, ResourceKey<Registry<T>> key) {
        return new JsonGrabber<T>(this.registryInfoGetter, codec, (WritableRegistry)this.baseRegistryManager.m_175515_(key));
    }

    <T> void grab_one_for_client(Codec<T> codec, ResourceKey<Registry<T>> key, ResourceLocation id, CompoundTag optiondata) {
        if (!this.baseRegistryManager.m_175515_(key).m_142003_(ResourceKey.m_135785_(key, (ResourceLocation)id))) {
            this.buildGrabber(codec, key).grab(id, optiondata, false);
        }
    }

    public void grab_dim_for_client(ResourceLocation id, CompoundTag dimdata) {
        if (!dimdata.m_128456_()) {
            this.grab_one_for_client(DimensionType.f_63843_, Registries.f_256787_, id, dimdata);
        }
    }

    public void grab_biome_for_client(ResourceLocation id, CompoundTag biomedata) {
        this.grab_one_for_client(Biome.f_47429_, Registries.f_256952_, id, biomedata);
    }

    LevelStem grab_dimension(Path rootdir, String i) {
        LevelStem ret = (LevelStem)this.buildGrabber(LevelStem.f_63970_, Registries.f_256862_).grab_with_return(rootdir.toString() + "/dimension", i, false);
        this.close();
        return ret;
    }

    public void grab_for_client(ResourceLocation id, CompoundTag optiondata, List<ResourceLocation> biomeids, List<CompoundTag> biomes) {
        if (!optiondata.m_128456_()) {
            this.grab_dim_for_client(id, optiondata);
        }
        int i = biomes.size();
        for (int j = 0; j < i; ++j) {
            this.grab_biome_for_client(biomeids.get(j), biomes.get(j));
        }
        this.close();
    }

    public void close() {
        this.baseRegistryManager.m_206193_().forEach(entry -> entry.f_206234_().m_203521_());
    }

    public RegistryOps.RegistryInfoLookup getGetter(List<WritableRegistry<?>> additionalRegistries) {
        final HashMap map = new HashMap();
        this.baseRegistryManager.m_206193_().forEach(entry -> map.put(entry.f_206233_(), DimensionGrabber.createInfo((WritableRegistry)entry.f_206234_())));
        additionalRegistries.forEach(first -> map.put(first.m_123023_(), DimensionGrabber.createInfo(first)));
        return new RegistryOps.RegistryInfoLookup(){

            public <T> Optional<RegistryOps.RegistryInfo<T>> m_254838_(ResourceKey<? extends Registry<? extends T>> registryRef) {
                return Optional.ofNullable((RegistryOps.RegistryInfo)map.get(registryRef));
            }
        };
    }

    public static <T> RegistryOps.RegistryInfo<T> createInfo(WritableRegistry<T> registry) {
        return new RegistryOps.RegistryInfo((HolderOwner)registry.m_255303_(), registry.m_203505_(), registry.m_203658_());
    }
}

