/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.loading;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.core.WritableRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class JsonGrabber<E> {
    Codec<E> decoder;
    WritableRegistry<E> registry;
    RegistryOps.RegistryInfoLookup registryInfoGetter;

    JsonGrabber(RegistryOps.RegistryInfoLookup get, Codec<E> dec, WritableRegistry<E> reg) {
        this.decoder = dec;
        this.registry = reg;
        this.registryInfoGetter = get;
    }

    public void grabAll(Path rootdir) {
        this.grabAll(rootdir, false);
    }

    void grabAll(Path rootdir, boolean bl) {
        if (!rootdir.toFile().exists()) {
            return;
        }
        try (Stream<Path> files = Files.walk(rootdir, new FileVisitOption[0]);){
            files.forEach(a -> this.grab((Path)a, bl));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void grab(Path path, boolean bl) {
        String path1 = path.toString();
        if (path1.endsWith(".json")) {
            String fullname = path1.substring(path1.lastIndexOf("/") + 1, path1.length() - 5);
            int i = fullname.lastIndexOf("\\");
            if (i >= 0) {
                fullname = fullname.substring(i + 1);
            }
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)this.registry.m_123023_(), (ResourceLocation)InfinityMethods.getId(fullname));
            this.grab(path1, key, bl);
        }
    }

    void grab(ResourceLocation id, CompoundTag compound, boolean bl) {
        this.grab(ResourceKey.m_135785_((ResourceKey)this.registry.m_123023_(), (ResourceLocation)id), JsonParser.parseString((String)CommonIO.compoundToString(compound)), bl);
    }

    void grab(ResourceKey<E> key, JsonElement jsonElement, boolean bl) {
        RegistryOps registryOps = RegistryOps.m_255060_((DynamicOps)JsonOps.INSTANCE, (RegistryOps.RegistryInfoLookup)this.registryInfoGetter);
        DataResult dataResult = this.decoder.parse((DynamicOps)registryOps, (Object)jsonElement);
        Object object = dataResult.getOrThrow(false, error -> {});
        if (bl || !this.registry.m_142003_(key)) {
            this.registry.m_255290_(key, object, Lifecycle.stable());
        }
    }

    void grab(String path, ResourceKey<E> registryKey, boolean bl) {
        String content;
        File file = new File(path);
        try {
            content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonElement jsonElement = JsonParser.parseString((String)content);
        this.grab(registryKey, jsonElement, bl);
    }

    E grab_with_return(String rootdir, String i, boolean register) {
        String content;
        String path = rootdir + "/" + i + ".json";
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)this.registry.m_123023_(), (ResourceLocation)InfinityMethods.getId("generated_" + i));
        File file = new File(path);
        try {
            content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonElement jsonElement = JsonParser.parseString((String)content);
        RegistryOps registryOps = RegistryOps.m_255060_((DynamicOps)JsonOps.INSTANCE, (RegistryOps.RegistryInfoLookup)this.registryInfoGetter);
        DataResult dataResult = this.decoder.parse((DynamicOps)registryOps, (Object)jsonElement);
        Object object = dataResult.getOrThrow(false, error -> {});
        if (register) {
            this.registry.m_255290_(key, object, Lifecycle.stable());
        }
        return (E)object;
    }
}

