/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.loading;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import net.lerariemann.infinity.access.GameRendererAccess;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface ShaderLoader {
    public static final String FILENAME = "current.json";
    public static final AtomicInteger iridLevel = new AtomicInteger(-1);
    public static final AtomicDouble iridProgress = new AtomicDouble(0.0);

    public static Path shaderDir(Minecraft client) {
        return client.m_245161_().resolve("infinity/assets/infinity/shaders");
    }

    public static void reloadShaders(Minecraft client, boolean bl) {
        ShaderLoader.reloadShaders(client, bl, Iridescence.shouldApplyShader((Player)client.f_91074_));
    }

    public static void reloadShaders(Minecraft client, boolean bl, boolean iridescence) {
        if (client.f_91073_ == null) {
            return;
        }
        if (iridescence) {
            ((GameRendererAccess)client.f_91063_).infinity$loadPP(InfinityMethods.getId("shaders/post/iridescence.json"));
            return;
        }
        iridLevel.set(-1);
        iridProgress.set(0.0);
        try {
            ShaderLoader.updateWorldShaderFromDisk(client);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (bl && ShaderLoader.shaderDir(client).resolve(FILENAME).toFile().exists()) {
            ((GameRendererAccess)client.f_91063_).infinity$loadPP(InfinityMethods.getId("shaders/current.json"));
            return;
        }
        client.f_91063_.m_109086_();
    }

    public static void updateWorldShaderFromDisk(Minecraft client) throws IOException {
        PackRepository m = client.m_91099_();
        Path path = client.m_245161_().resolve("infinity");
        String name = "file/" + path.getFileName().toString();
        Files.createDirectories(path.resolve("assets/infinity/shaders"), new FileAttribute[0]);
        if (!path.resolve("pack.mcmeta").toFile().exists()) {
            CommonIO.write(ShaderLoader.packMcmeta(), path.toString(), "pack.mcmeta");
        }
        m.m_10506_();
        m.m_275855_(name);
    }

    public static CompoundTag packMcmeta() {
        CompoundTag res = new CompoundTag();
        CompoundTag pack = new CompoundTag();
        pack.m_128405_("pack_format", 15);
        pack.m_128359_("description", "Shader container");
        res.m_128365_("pack", (Tag)pack);
        return res;
    }
}

