/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.screen;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.lerariemann.infinity.item.F4Item;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.registry.var.ModPayloads;
import net.lerariemann.infinity.registry.var.ModScreenHandlers;
import net.lerariemann.infinity.util.BackportMethods;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class F4ScreenHandler
extends AbstractContainerMenu {
    public final Inventory playerInventory;
    public final ItemStack stack;
    public final int slot;
    public AtomicInteger width;
    public AtomicInteger height;

    public F4ScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf packet) {
        this(syncId, playerInventory, packet.m_130277_(), packet.m_130242_());
    }

    public F4ScreenHandler(int syncId, Inventory playerInventory, String destination, int slot) {
        super((MenuType)ModScreenHandlers.F4.get(), syncId);
        int i;
        this.playerInventory = playerInventory;
        this.slot = slot;
        this.stack = playerInventory.m_8020_(slot);
        this.width = new AtomicInteger(BackportMethods.getOrDefaultInt(this.stack, ModComponentTypes.SIZE_X, 3));
        this.height = new AtomicInteger(BackportMethods.getOrDefaultInt(this.stack, ModComponentTypes.SIZE_Y, 3));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void m_6877_(Player player) {
        ItemStack st = this.stack.m_41777_();
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.m_128405_(ModComponentTypes.SIZE_X, Mth.m_14045_((int)this.width.get(), (int)1, (int)21));
        nbtCompound.m_128405_(ModComponentTypes.SIZE_Y, Mth.m_14045_((int)this.height.get(), (int)1, (int)21));
        this.stack.m_41751_(nbtCompound);
        this.playerInventory.m_6836_(this.slot, st);
        super.m_6877_(player);
        if (player instanceof LocalPlayer) {
            ClientPlayNetworking.send((FabricPacket)new ModPayloads.F4UpdatingValuesPacket(this.slot, this.width.get(), this.height.get()));
        }
    }

    public ItemStack m_7648_(Player player, int slot) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return false;
    }

    public static class Factory
    implements ExtendedMenuProvider {
        ItemStack f4;
        int slot;
        String destination;

        public Factory(Player player) {
            this.f4 = player.m_21120_(InteractionHand.MAIN_HAND);
            this.slot = player.m_150109_().f_35977_;
            ResourceLocation id = BackportMethods.getDimensionIdentifier(this.f4);
            this.destination = id == null ? "" : id.toString();
        }

        public void saveExtraData(FriendlyByteBuf packetByteBuf) {
            packetByteBuf.m_130070_(this.destination);
            packetByteBuf.m_130130_(this.slot);
        }

        public Component m_5446_() {
            return F4Item.getDimensionTooltip(this.destination.isEmpty() ? null : new ResourceLocation(this.destination));
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
            return new F4ScreenHandler(syncId, playerInventory, this.destination, this.slot);
        }
    }
}

