/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.teleport;

import java.util.Comparator;
import java.util.Optional;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.registry.var.ModPoi;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.teleport.PortalCreator;
import net.minecraft.BlockUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class InfinityPortal {
    InfinityPortalBlockEntity ipbe;
    ServerLevel worldFrom;
    BlockPos posFrom;
    Direction.Axis axisFrom;
    BlockUtil.FoundRectangle portalFrom;
    @Nullable
    ServerLevel worldTo;
    @Nullable
    BlockPos posTo;
    @Nullable
    BlockUtil.FoundRectangle portalTo;
    boolean unableToCreatePortalFlag = false;
    boolean noSyncFlag = false;

    public InfinityPortal(InfinityPortalBlockEntity ipbe, ServerLevel worldFrom, BlockPos startingPos) {
        this.ipbe = ipbe;
        this.worldFrom = worldFrom;
        this.portalFrom = InfinityPortal.getRect((Level)worldFrom, startingPos);
        this.posFrom = InfinityPortal.lowerCenterPos(this.portalFrom, (Level)worldFrom);
        this.axisFrom = (Direction.Axis)worldFrom.m_8055_(this.posFrom).m_61143_((Property)BlockStateProperties.f_61364_);
        this.worldTo = worldFrom.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ipbe.getDimension()));
        InfinityPortal.tryUpdateOpenStatus(ipbe, worldFrom, startingPos, this.worldTo);
        if (this.portalShouldWork()) {
            BlockPos targetPos = ipbe.getOtherSidePos();
            if (InfinityPortal.isValidDestination(worldFrom, this.worldTo, targetPos)) {
                this.posTo = targetPos;
                this.scanExistingTarget();
            }
            this.scanNewTeleportTarget();
        }
    }

    public static void tryUpdateOpenStatus(InfinityPortalBlockEntity ipbe, ServerLevel worldFrom, BlockPos posFrom, MinecraftServer server) {
        ServerLevel worldTo = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ipbe.getDimension()));
        InfinityPortal.tryUpdateOpenStatus(ipbe, worldFrom, posFrom, worldTo);
    }

    public static void tryUpdateOpenStatus(InfinityPortalBlockEntity ipbe, ServerLevel worldFrom, BlockPos posFrom, ServerLevel worldTo) {
        if (!ipbe.isOpen() ^ worldTo == null) {
            PortalCreator.modifyPortalRecursive(worldFrom, posFrom, e -> e.setOpen(!ipbe.isOpen()));
        }
    }

    public static BlockUtil.FoundRectangle getRect(Level world, BlockPos pos) {
        BlockState blockStateFrom = world.m_8055_(pos);
        return BlockUtil.m_124334_((BlockPos)pos, (Direction.Axis)InfinityPortal.getAxisOrDefault(blockStateFrom), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posx -> world.m_8055_(posx) == blockStateFrom);
    }

    static BlockPos lowerCenterPos(BlockUtil.FoundRectangle rect, Level world) {
        return InfinityPortal.lowerCenterPos(rect, (Direction.Axis)world.m_8055_(rect.f_124348_).m_61143_((Property)BlockStateProperties.f_61364_));
    }

    static BlockPos lowerCenterPos(BlockUtil.FoundRectangle rect, Direction.Axis axis) {
        boolean bl = axis.equals((Object)Direction.Axis.X);
        int i = rect.f_124349_ / 2;
        return rect.f_124348_.m_7918_(bl ? i : 0, 0, bl ? 0 : i);
    }

    public PortalInfo getTeleportTarget(Entity entity) {
        if (this.portalShouldWork() && this.portalTo != null && this.worldTo != null && this.posTo != null) {
            InfinityPortal.createTicket(this.worldTo, this.posTo);
            return PortalShape.m_257966_((ServerLevel)this.worldTo, (BlockUtil.FoundRectangle)this.portalTo, (Direction.Axis)this.axisFrom, (Vec3)entity.m_7643_(this.axisFrom, this.portalFrom), (Entity)entity, (Vec3)entity.m_20184_(), (float)entity.m_146908_(), (float)entity.m_146909_());
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.sendErrors(player);
        }
        return InfinityPortal.emptyTarget(entity);
    }

    public boolean portalShouldWork() {
        return InfinityMethods.dimExists(this.worldTo) && this.ipbe.isOpen() && !this.worldTo.m_46472_().equals(this.worldFrom.m_46472_());
    }

    public void sendErrors(ServerPlayer player) {
        if (this.worldTo != null) {
            if (this.worldTo.m_46472_().equals(this.worldFrom.m_46472_())) {
                player.m_213846_((Component)Component.m_237115_((String)"error.infinity.portal.matching_ends"));
            } else if (InfinityMethods.isTimebombed(this.worldTo)) {
                player.m_213846_((Component)Component.m_237115_((String)"error.infinity.portal.deleted"));
            } else if (this.unableToCreatePortalFlag) {
                player.m_213846_((Component)Component.m_237115_((String)"error.infinity.portal.cannot_create"));
            } else {
                InfinityMethods.sendUnexpectedError(player, "portal");
            }
        } else if (!this.ipbe.isOpen()) {
            InfinityMod.provider.getPortalKeyAsItem().ifPresent(item -> player.m_213846_((Component)Component.m_237110_((String)"error.infinity.portal.closed", (Object[])new Object[]{((MutableComponent)item.m_41466_()).m_130940_(ChatFormatting.AQUA)})));
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"error.infinity.portal.null"));
        }
    }

    public static void createTicket(ServerLevel worldTo, BlockPos posTo) {
        worldTo.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(posTo), 3, (Object)posTo);
    }

    public static Direction.Axis getAxisOrDefault(BlockState state) {
        if (state.m_61147_().contains(BlockStateProperties.f_61364_)) {
            return (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
        }
        return Direction.Axis.X;
    }

    public static PortalInfo emptyTarget(Entity entity) {
        return new PortalInfo(entity.m_20182_(), entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
    }

    public static boolean isValidDestination(ServerLevel worldFrom, ServerLevel worldTo, BlockPos posTo) {
        InfinityPortalBlockEntity ipbeTo;
        if (posTo == null || !InfinityMethods.dimExists(worldTo)) {
            return false;
        }
        BlockEntity blockEntity = worldTo.m_7702_(posTo);
        return blockEntity instanceof InfinityPortalBlockEntity && (ipbeTo = (InfinityPortalBlockEntity)blockEntity).getDimension().toString().equals(worldFrom.m_46472_().m_135782_().toString());
    }

    private void scanExistingTarget() {
        assert (this.worldTo != null && this.posTo != null);
        BlockState blockState = this.worldTo.m_8055_(this.posTo);
        this.portalTo = BlockUtil.m_124334_((BlockPos)this.posTo, (Direction.Axis)InfinityPortal.getAxisOrDefault(blockState), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posx -> this.worldTo.m_8055_(posx) == blockState);
    }

    private void scanNewTeleportTarget() {
        assert (this.worldTo != null);
        this.findOrCreateExitPortal();
        if (this.portalTo == null) {
            return;
        }
        this.posTo = InfinityPortal.lowerCenterPos(this.portalTo, (Level)this.worldTo);
        if (!this.noSyncFlag) {
            InfinityPortal.trySyncPortals(this.worldFrom, this.posFrom, this.worldTo, this.posTo);
        }
    }

    private void findOrCreateExitPortal() {
        assert (this.worldTo != null);
        WorldBorder wb = this.worldTo.m_6857_();
        double d = DimensionType.m_63908_((DimensionType)this.worldFrom.m_6042_(), (DimensionType)this.worldTo.m_6042_());
        BlockPos originOfTesting = wb.m_187569_((double)this.posFrom.m_123341_() * d, (double)this.posFrom.m_123342_(), (double)this.posFrom.m_123343_() * d);
        Optional<BlockPos> optional = this.findNewExitPortalPosition(wb, originOfTesting);
        if (optional.isPresent()) {
            this.portalTo = InfinityPortal.getRect((Level)this.worldTo, optional.get());
        } else {
            Direction.Axis axis = InfinityPortal.getAxisOrDefault(this.worldFrom.m_8055_(this.posFrom));
            this.worldTo.m_8871_().m_77666_(originOfTesting, axis).ifPresentOrElse(rect -> {
                this.portalTo = rect;
            }, () -> {
                this.unableToCreatePortalFlag = true;
            });
        }
    }

    private Optional<BlockPos> findNewExitPortalPosition(WorldBorder wbTo, BlockPos originOfTesting) {
        assert (this.worldTo != null);
        int radiusOfTesting = 128;
        PoiManager poiStorage = this.worldTo.m_8904_();
        poiStorage.m_27056_((LevelReader)this.worldTo, originOfTesting, radiusOfTesting);
        Optional<BlockPos> portal = poiStorage.m_27166_(poiType -> poiType.m_203565_(ModPoi.NEITHER_PORTAL_KEY), originOfTesting, radiusOfTesting, PoiManager.Occupancy.ANY).map(PoiRecord::m_27257_).filter(arg_0 -> ((WorldBorder)wbTo).m_61937_(arg_0)).filter(pos -> InfinityPortal.isValidDestination(this.worldFrom, this.worldTo, pos)).min(Comparator.comparingDouble(posTo -> posTo.m_123331_((Vec3i)originOfTesting)));
        if (portal.isPresent()) {
            return portal;
        }
        portal = poiStorage.m_27166_(poiType -> poiType.m_203565_(PoiTypes.f_218064_), originOfTesting, radiusOfTesting, PoiManager.Occupancy.ANY).map(PoiRecord::m_27257_).filter(arg_0 -> ((WorldBorder)wbTo).m_61937_(arg_0)).min(Comparator.comparingDouble(posTo -> posTo.m_123331_((Vec3i)originOfTesting)));
        this.noSyncFlag = portal.isPresent();
        return portal;
    }

    public static void trySyncPortals(ServerLevel worldFrom, BlockPos posFrom, ServerLevel worldTo, BlockPos posTo) {
        if (worldTo == null || posTo == null || !(worldTo.m_8055_(posTo).m_60734_() instanceof NetherPortalBlock)) {
            return;
        }
        PortalCreator.PortalModifierUnion otherSideModifier = new PortalCreator.PortalModifierUnion();
        ResourceLocation idFrom = worldFrom.m_46472_().m_135782_();
        BlockEntity blockEntity = worldTo.m_7702_(posTo);
        if (blockEntity instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity ipbeTo = (InfinityPortalBlockEntity)blockEntity;
            if (!ipbeTo.getDimension().toString().equals(idFrom.toString())) {
                return;
            }
            if (ipbeTo.isConnectedBothSides()) {
                return;
            }
        } else {
            otherSideModifier = PortalCreator.forInitialSetupping(worldTo, posTo, idFrom, true);
        }
        otherSideModifier.addModifier(ipbe1 -> ipbe1.setBlockPos(posFrom));
        PortalCreator.modifyPortalRecursive(worldFrom, posFrom, ipbe -> ipbe.setBlockPos(posTo));
        PortalCreator.modifyPortalRecursive(worldTo, posTo, otherSideModifier);
    }
}

