/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.teleport;

import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.MinecraftServerAccess;
import net.lerariemann.infinity.block.custom.Boopable;
import net.lerariemann.infinity.block.custom.InfinityPortalBlock;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.compat.ComputerCraftCompat;
import net.lerariemann.infinity.compat.CreateCompat;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.options.PortalColorApplier;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.registry.var.ModCriteria;
import net.lerariemann.infinity.registry.var.ModPayloads;
import net.lerariemann.infinity.registry.var.ModSounds;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.util.BackportMethods;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.loading.DimensionGrabber;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.storage.LevelResource;

public interface PortalCreator {
    public static void tryCreatePortalFromItem(Level world, BlockPos pos, ItemEntity entity) {
        if (entity.m_213877_()) {
            return;
        }
        ItemStack itemStack = entity.m_32055_();
        if (itemStack.m_41720_() == ModItems.TRANSFINITE_KEY.get()) {
            ResourceLocation key_dest = BackportMethods.getDimensionIdentifier(itemStack);
            MinecraftServer server = world.m_7654_();
            if (server != null && world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                boolean bl = PortalCreator.modifyOnInitialCollision(Objects.requireNonNullElse(key_dest, ResourceLocation.m_214293_((String)"minecraft", (String)"random")), serverWorld, pos);
                if (bl) {
                    entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
                }
            }
        } else if (itemStack.m_41720_() == Items.f_42615_ || itemStack.m_41720_() == Items.f_42614_) {
            CompoundTag compound = itemStack.m_41783_();
            String content = compound != null ? PortalCreator.parseComponents(compound, itemStack.m_41720_()) : "";
            MinecraftServer server = world.m_7654_();
            if (server != null) {
                ResourceLocation id = InfinityMethods.dimTextToId(content);
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    boolean bl = PortalCreator.modifyOnInitialCollision(id, serverWorld, pos);
                    if (bl) {
                        entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
                    }
                    PortalCreator.recordIdTranslation(world.m_7654_(), id, content);
                }
            }
        } else if (Platform.isModLoaded((String)"computercraft")) {
            try {
                String content = ComputerCraftCompat.checkPrintedPage(itemStack);
                MinecraftServer server = world.m_7654_();
                if (server != null) {
                    ResourceLocation id = InfinityMethods.dimTextToId(content);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        boolean bl = PortalCreator.modifyOnInitialCollision(id, serverWorld, pos);
                        if (bl) {
                            entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
                        }
                        PortalCreator.recordIdTranslation(world.m_7654_(), id, content);
                    }
                }
            }
            catch (Exception e) {
                InfinityMod.LOGGER.warn("An incompatible version of ComputerCraft is present. Please update it to the latest version");
            }
        }
    }

    public static String parseComponents(CompoundTag compound, Item item) {
        ListTag pages = compound.m_128437_("pages", 8);
        if (pages.isEmpty()) {
            return "";
        }
        if (item == Items.f_42615_) {
            String pagesString = pages.get(0).m_7916_();
            return pagesString.substring(pagesString.indexOf(58) + 2, pagesString.length() - 2);
        }
        if (item == Items.f_42614_) {
            return pages.get(0).m_7916_();
        }
        return "";
    }

    public static boolean modifyOnInitialCollision(ResourceLocation dimName, ServerLevel world, BlockPos pos) {
        MinecraftServer server = world.m_7654_();
        Player nearestPlayer = world.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 5.0, false);
        if (((MinecraftServerAccess)server).infinity$needsInvocation()) {
            PortalCreator.onInvocationNeedDetected(nearestPlayer);
            return false;
        }
        if (dimName.m_135815_().equals("random")) {
            dimName = InfinityMethods.getRandomId(world.f_46441_);
        }
        boolean dimensionExistsAlready = server.m_129784_().contains(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimName));
        PortalCreator.modifyPortalRecursive(world, pos, dimName, dimensionExistsAlready);
        if (dimensionExistsAlready) {
            if (nearestPlayer != null) {
                nearestPlayer.m_6278_(ModStats.PORTALS_OPENED_STAT, 1);
            }
            PortalCreator.runAfterEffects(world, pos, false, true);
        } else if (InfinityMod.provider.isPortalKeyBlank()) {
            PortalCreator.openWithStatIncrease(nearestPlayer, server, world, pos);
        } else {
            PortalCreator.runAfterEffects(world, pos, false, false);
        }
        return true;
    }

    public static void openWithStatIncrease(Player player, MinecraftServer s, ServerLevel world, BlockPos pos) {
        if (((MinecraftServerAccess)s).infinity$needsInvocation()) {
            PortalCreator.onInvocationNeedDetected(player);
            return;
        }
        boolean isDimensionNew = PortalCreator.open(s, world, pos);
        if (player != null) {
            if (isDimensionNew) {
                player.m_6278_(ModStats.DIMS_OPENED_STAT, 1);
                ModCriteria.DIMS_OPENED.trigger((ServerPlayer)player);
            }
            player.m_6278_(ModStats.PORTALS_OPENED_STAT, 1);
        }
    }

    public static void onInvocationNeedDetected(Player player) {
        if (player != null) {
            player.m_213846_((Component)Component.m_237115_((String)"error.infinity.invocation_needed"));
        }
    }

    public static boolean open(MinecraftServer s, ServerLevel world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        boolean bl = false;
        if (blockEntity instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
            ResourceLocation i = npbe.getDimension();
            if (i.m_135827_().equals("infinity")) {
                bl = PortalCreator.tryAddInfinityDimension(s, i);
            }
            PortalCreator.modifyPortalRecursive(world, pos, (InfinityPortalBlockEntity be) -> {
                be.setOpen(true);
                be.m_6596_();
            });
            PortalCreator.runAfterEffects(world, pos, bl, true);
        }
        return bl;
    }

    public static void modifyPortalRecursive(ServerLevel world, BlockPos pos, ResourceLocation id, boolean open) {
        PortalCreator.modifyPortalRecursive(world, pos, PortalCreator.forInitialSetupping(world, pos, id, open));
    }

    public static void modifyPortalRecursive(ServerLevel world, BlockPos pos, Consumer<InfinityPortalBlockEntity> consumer) {
        PortalCreator.modifyPortalRecursive(world, pos, new PortalModifier(consumer));
    }

    public static void modifyPortalRecursive(ServerLevel world, BlockPos pos, BiConsumer<Level, BlockPos> modifier) {
        Direction.Axis axis = (Direction.Axis)world.m_8055_(pos).m_61143_((Property)NetherPortalBlock.f_54904_);
        BlockUtil.FoundRectangle rect = BlockUtil.m_124334_((BlockPos)pos, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posx -> world.m_8055_(posx).m_60734_() instanceof NetherPortalBlock);
        for (int i = 0; i < rect.f_124349_; ++i) {
            for (int j = 0; j < rect.f_124350_; ++j) {
                BlockPos blockPos = rect.f_124348_.m_6630_(j).m_5487_(axis, i);
                modifier.accept((Level)world, blockPos);
            }
        }
    }

    public static Consumer<BlockPos> infPortalSetupper(ServerLevel world, BlockPos pos) {
        BlockState originalState = world.m_8055_(pos);
        BlockState state = (BlockState)((BlockState)((Block)ModBlocks.PORTAL.get()).m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)((Direction.Axis)originalState.m_61143_((Property)NetherPortalBlock.f_54904_)))).m_61124_((Property)InfinityPortalBlock.BOOP, (Comparable)Boolean.valueOf(!Boopable.getBoop(world.m_8055_(pos))));
        return p -> world.m_6933_(p, state, 3, 1);
    }

    public static PortalModifierUnion forInitialSetupping(ServerLevel world, BlockPos pos, ResourceLocation id, boolean open) {
        PortalColorApplier applier = PortalColorApplier.of(id, world.m_7654_());
        PortalModifierUnion union = new PortalModifierUnion().addSetupper(PortalCreator.infPortalSetupper(world, pos)).addModifier(nbpe -> nbpe.setDimension(id)).addModifier(npbe -> npbe.setColor(applier.apply(npbe.m_58899_()))).addModifier(npbe -> npbe.setOpen(open)).addModifier(BlockEntity::m_6596_);
        if (InfinityMethods.isCreateLoaded()) {
            union.addModifier(CreateCompat::tryModifyRails);
        }
        return union;
    }

    public static boolean tryAddInfinityDimension(MinecraftServer server, ResourceLocation id) {
        if (!id.m_135827_().equals("infinity")) {
            return false;
        }
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)id);
        if (((MinecraftServerAccess)server).infinity$hasToAdd((ResourceKey<Level>)key)) {
            return false;
        }
        ServerLevel w = server.m_129880_(key);
        if (w != null) {
            return false;
        }
        RandomDimension d = new RandomDimension(id, server);
        if (!RandomProvider.rule("runtimeGenerationEnabled")) {
            return false;
        }
        ((MinecraftServerAccess)server).infinity$addWorld((ResourceKey<Level>)key, new DimensionGrabber((RegistryAccess)server.m_206579_()).grab_all(d));
        server.m_6846_().m_11314_().forEach(a -> PortalCreator.sendNewWorld(a, id, d));
        return true;
    }

    public static void sendNewWorld(ServerPlayer player, ResourceLocation id, RandomDimension d) {
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPayloads.WORLD_ADD, (FriendlyByteBuf)PortalCreator.buildPacket(id, d));
    }

    public static FriendlyByteBuf buildPacket(ResourceLocation id, RandomDimension d) {
        FriendlyByteBuf buf = PlatformMethods.createPacketByteBufs();
        buf.m_130085_(id);
        buf.m_130079_(d.type != null ? d.type.data : new CompoundTag());
        buf.writeInt(d.random_biomes.size());
        d.random_biomes.forEach(b -> {
            buf.m_130085_(InfinityMethods.getId(b.name));
            buf.m_130079_(b.data);
        });
        return buf;
    }

    public static void runAfterEffects(ServerLevel world, BlockPos pos, boolean dimensionIsNew, boolean portalWorks) {
        if (!portalWorks) {
            PortalCreator.playSound(world, pos, ModSounds.BACKPORT_VAULT_EVENT);
        } else {
            if (dimensionIsNew) {
                PortalCreator.playSound(world, pos, ModSounds.BACKPORT_VAULT_EVENT);
            }
            PortalCreator.playSound(world, pos, SoundEvents.f_11736_);
        }
    }

    public static void playSound(ServerLevel world, BlockPos pos, SoundEvent soundEvent) {
        world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static boolean convertReturnPortal(ServerLevel destination, MinecraftServer server, ResourceKey<Level> registryKey, PortalInfo teleportTarget) {
        boolean bl = false;
        if (RandomProvider.rule("returnPortalsEnabled") && registryKey.m_135782_().m_135827_().equals("infinity")) {
            BlockPos pos = BlockPos.m_274446_((Position)teleportTarget.f_77676_);
            for (BlockPos pos2 : new BlockPos[]{pos, pos.m_7918_(1, 0, 0), pos.m_7918_(0, 0, 1), pos.m_7918_(-1, 0, 0), pos.m_7918_(0, 0, -1)}) {
                if (!destination.m_8055_(pos2).m_60713_(Blocks.f_50142_)) continue;
                bl = true;
                ResourceLocation dimensionName = registryKey.m_135782_();
                PortalCreator.modifyPortalRecursive(destination, pos2, dimensionName, true);
                break;
            }
        }
        return bl;
    }

    public static void recordIdTranslation(MinecraftServer server, ResourceLocation id, String value) {
        String key;
        String filename;
        value = value.replaceAll("\n", "/n");
        Path dir = server.m_129843_(LevelResource.f_78180_).resolve("infinity");
        CompoundTag comp = CommonIO.read(dir.resolve(filename = "translation_tables.json"));
        if (comp.m_128441_(key = id.m_135815_())) {
            ListTag l;
            if (comp.m_128425_(key, 8)) {
                l = new ListTag();
                l.add((Object)comp.m_128423_(key));
            } else {
                l = comp.m_128437_(key, 8);
            }
            l.add((Object)StringTag.m_129297_((String)value));
            comp.m_128473_(key);
            comp.m_128365_(key, (Tag)l);
        } else {
            comp.m_128359_(key, value);
        }
        CommonIO.write(comp, dir, filename);
    }

    public record PortalModifierUnion(List<Consumer<BlockPos>> setuppers, List<Consumer<InfinityPortalBlockEntity>> modifiers) implements BiConsumer<Level, BlockPos>
    {
        public PortalModifierUnion() {
            this(new ArrayList<Consumer<BlockPos>>(), new ArrayList<Consumer<InfinityPortalBlockEntity>>());
        }

        PortalModifierUnion addSetupper(Consumer<BlockPos> setupper) {
            this.setuppers.add(setupper);
            return this;
        }

        public PortalModifierUnion addModifier(Consumer<InfinityPortalBlockEntity> modifier) {
            this.modifiers.add(modifier);
            return this;
        }

        @Override
        public void accept(Level world, BlockPos pos) {
            this.setuppers.forEach(setupper -> setupper.accept(pos));
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof InfinityPortalBlockEntity) {
                InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
                this.modifiers.forEach(modifier -> modifier.accept(npbe));
            }
        }
    }

    public record PortalModifier(Consumer<InfinityPortalBlockEntity> modifier) implements BiConsumer<Level, BlockPos>
    {
        @Override
        public void accept(Level world, BlockPos pos) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof InfinityPortalBlockEntity) {
                InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
                this.modifier.accept(npbe);
            }
        }
    }
}

