/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.teleport;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.Objects;
import net.lerariemann.infinity.access.MinecraftServerAccess;
import net.lerariemann.infinity.access.ServerPlayerEntityAccess;
import net.lerariemann.infinity.registry.var.ModCommands;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.teleport.PortalCreator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WarpLogic {
    public static void requestWarpById(CommandContext<CommandSourceStack> context, long value) {
        WarpLogic.requestWarp(((CommandSourceStack)context.getSource()).m_230896_(), InfinityMethods.getDimId(value), true);
    }

    public static void requestWarpToExisting(CommandContext<CommandSourceStack> context, ResourceLocation value) throws CommandSyntaxException {
        ServerLevel w = ((CommandSourceStack)context.getSource()).m_81377_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)value));
        if (w == null) {
            throw ModCommands.MALFORM_IDENTIFIER_EXCEPTION.create((Object)value);
        }
        if (InfinityMethods.isTimebombed(w)) {
            throw ModCommands.TIMEBOMBED_EXCEPRION.create((Object)value);
        }
        WarpLogic.requestWarp(((CommandSourceStack)context.getSource()).m_230896_(), value, true);
    }

    public static void requestWarpByText(CommandContext<CommandSourceStack> context, String value) {
        ResourceLocation id = InfinityMethods.dimTextToId(value);
        WarpLogic.requestWarp(((CommandSourceStack)context.getSource()).m_230896_(), id, true);
        PortalCreator.recordIdTranslation(((CommandSourceStack)context.getSource()).m_81377_(), id, value);
    }

    public static void requestWarp(@Nullable ServerPlayer player, ResourceLocation value, boolean increaseStats) {
        if (player == null) {
            return;
        }
        MinecraftServer s = player.m_20194_();
        if (s == null) {
            return;
        }
        if (((MinecraftServerAccess)s).infinity$needsInvocation()) {
            PortalCreator.onInvocationNeedDetected((Player)player);
            return;
        }
        boolean isThisANewDimension = PortalCreator.tryAddInfinityDimension(s, value);
        if (isThisANewDimension) {
            if (increaseStats) {
                player.m_6278_(ModStats.DIMS_OPENED_STAT, 1);
            }
            ((ServerPlayerEntityAccess)player).infinity$setWarpTimer(2L, value);
        } else {
            WarpLogic.performWarp(player, value);
        }
    }

    public static void respawnAlive(@Nullable ServerPlayer player) {
        if (player == null) {
            return;
        }
        BlockPos targ = player.m_8961_();
        ServerLevel serverWorld = player.f_8924_.m_129880_(player.m_8963_());
        if (targ == null || serverWorld == null) {
            serverWorld = player.f_8924_.m_129783_();
            targ = serverWorld.m_220360_();
        }
        player.m_264318_(serverWorld, (double)targ.m_123341_() + 0.5, (double)targ.m_123342_(), (double)targ.m_123343_() + 0.5, new HashSet(), player.m_146908_(), player.m_146909_());
    }

    public static void sendToMissingno(ServerPlayer player) {
        WarpLogic.requestWarp(player, InfinityMethods.getId("missingno"), false);
    }

    public static void performWarp(ServerPlayer player, ResourceLocation idForWarp) {
        ResourceKey key;
        MinecraftServer s = player.m_284548_().m_7654_();
        ServerLevel w = s.m_129880_(key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)idForWarp));
        if (w == null) {
            InfinityMethods.sendUnexpectedError(player, "warp");
            return;
        }
        double d = DimensionType.m_63908_((DimensionType)player.m_284548_().m_6042_(), (DimensionType)w.m_6042_());
        double y = Mth.m_14008_((double)player.m_20186_(), (double)w.m_141937_(), (double)w.m_151558_());
        BlockPos blockPos2 = WarpLogic.getPosForWarp(w.m_6857_().m_187569_(player.m_20185_() * d, y, player.m_20189_() * d), w);
        WarpLogic.ensureSafety(w, blockPos2.m_7495_(), Blocks.f_50080_);
        WarpLogic.ensureSafety(w, blockPos2, Blocks.f_50016_);
        WarpLogic.ensureSafety(w, blockPos2.m_7494_(), Blocks.f_50016_);
        player.m_264318_(w, (double)blockPos2.m_123341_() + 0.5, (double)blockPos2.m_123342_(), (double)blockPos2.m_123343_() + 0.5, new HashSet(), player.m_146908_(), player.m_146909_());
    }

    public static int getKeyColorFromId(ResourceLocation id) {
        if (id.m_135827_().equals("infinity") && id.m_135815_().contains("generated_")) {
            return Math.toIntExact(InfinityMethods.getNumericFromId(id) & 0xFFFFFFL);
        }
        return 0;
    }

    public static boolean isSafe(BlockState state, BlockState fallback) {
        if (state.m_60795_()) {
            return fallback.m_60795_();
        }
        FluidState fluidState = state.m_60819_();
        return fluidState.m_192917_(Fluids.f_76191_) || fluidState.m_205070_(FluidTags.f_13131_);
    }

    public static BlockPos getPosForWarp(@NotNull BlockPos orig, @NotNull ServerLevel world) {
        BlockPos iter = orig;
        int counter = 0;
        BlockPos pos = WarpLogic.scanColumn(orig, world, true);
        while (pos == null) {
            iter = iter.m_7918_(world.f_46441_.m_188503_(16) - 8, 0, world.f_46441_.m_188503_(16) - 8);
            pos = WarpLogic.scanColumn(iter, world, true);
            if (++counter <= 7) continue;
            pos = Objects.requireNonNullElse(WarpLogic.scanColumn(orig, world, false), orig);
            break;
        }
        return pos;
    }

    @Nullable
    public static BlockPos scanColumn(BlockPos orig, ServerLevel world, boolean strong) {
        int z;
        int y1;
        int x = orig.m_123341_();
        if (WarpLogic.isPosViable(x, y1 = orig.m_123342_(), z = orig.m_123343_(), (BlockGetter)world, strong)) {
            return orig;
        }
        int y2 = y1;
        while (y1 > world.m_141937_() || y2 < world.m_151558_()) {
            if (WarpLogic.isPosViable(x, --y1, z, (BlockGetter)world, strong)) {
                return new BlockPos(x, y1, z);
            }
            if (!WarpLogic.isPosViable(x, ++y2, z, (BlockGetter)world, strong)) continue;
            return new BlockPos(x, y2, z);
        }
        return null;
    }

    public static boolean isPosViable(int x, int y, int z, BlockGetter w, boolean strong) {
        return strong ? WarpLogic.isPosViableStrong(new BlockPos(x, y, z), w) : WarpLogic.isPosViableWeak(new BlockPos(x, y, z), w);
    }

    public static boolean isPosViableWeak(BlockPos pos, BlockGetter w) {
        if (w.m_151562_(pos.m_123342_())) {
            return false;
        }
        boolean bl = w.m_8055_(pos.m_7494_()).m_60795_();
        boolean bl2 = w.m_8055_(pos).m_60795_();
        boolean bl3 = w.m_8055_(pos.m_7495_()).m_60795_();
        return !bl3 && bl2 && bl;
    }

    public static boolean isPosViableStrong(BlockPos pos, BlockGetter w) {
        if (w.m_151562_(pos.m_123342_())) {
            return false;
        }
        boolean bl = WarpLogic.isSafe(w, pos.m_7494_(), true);
        boolean bl2 = WarpLogic.isSafe(w, pos, true);
        boolean bl3 = WarpLogic.isSafe(w, pos.m_7495_(), false);
        return bl3 && bl2 && bl;
    }

    public static boolean isSafe(BlockGetter world, BlockPos pos, boolean asAir) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_()) {
            return asAir;
        }
        if (asAir) {
            return false;
        }
        FluidState fluidState = state.m_60819_();
        return fluidState.m_192917_(Fluids.f_76191_) || fluidState.m_205070_(FluidTags.f_13131_);
    }

    public static void ensureSafety(ServerLevel world, BlockPos pos, Block fallback) {
        BlockState fb = fallback.m_49966_();
        if (!WarpLogic.isSafe((BlockGetter)world, pos, fb.m_60795_())) {
            world.m_46597_(pos, fb);
        }
    }
}

