/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.var;

import java.util.Objects;
import net.lerariemann.infinity.entity.custom.AntEntity;
import net.lerariemann.infinity.entity.custom.BishopEntity;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class BishopBattle {
    public String teamName;
    public ServerLevel serverWorld;
    public Scoreboard scoreboard;
    public PlayerTeam team;

    public BishopBattle(ServerLevel world) {
        this(world, "bishop_battle_" + world.f_46441_.m_188502_());
    }

    public BishopBattle(ServerLevel world, String teamName) {
        this.teamName = teamName;
        this.serverWorld = world;
        this.scoreboard = world.m_6188_();
        this.team = this.getOrCreateTeam(teamName);
    }

    public PlayerTeam getOrCreateTeam(String name) {
        PlayerTeam t = this.scoreboard.m_83489_(name);
        if (t == null) {
            t = this.scoreboard.m_83492_(name);
        }
        return t;
    }

    public void addEntity(LivingEntity entity) {
        this.scoreboard.m_6546_(entity.m_6302_(), this.team);
    }

    public void start(BlockPos pos) {
        AntEntity ant = (AntEntity)((EntityType)ModEntities.ANT.get()).m_262496_(this.serverWorld, pos, MobSpawnType.MOB_SUMMONED);
        BishopEntity bishop = (BishopEntity)((EntityType)ModEntities.BISHOP.get()).m_262496_(this.serverWorld, pos, MobSpawnType.MOB_SUMMONED);
        if (ant != null && bishop != null) {
            Objects.requireNonNull(ant.m_21051_(Attributes.f_22276_)).m_22100_(20.0);
            Objects.requireNonNull(ant.m_21051_(Attributes.f_22279_)).m_22100_(0.25);
            ant.m_21153_(20.0f);
            bishop.m_20329_((Entity)ant);
            bishop.m_8061_(EquipmentSlot.CHEST, Items.f_42469_.m_7968_());
            bishop.m_8061_(EquipmentSlot.LEGS, Items.f_42470_.m_7968_());
            bishop.m_8061_(EquipmentSlot.FEET, Items.f_42471_.m_7968_());
            ant.addToBattle(this);
            bishop.addToBattle(this);
        }
    }

    public void stop() {
        this.scoreboard.m_83475_(this.team);
    }
}

