/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.var;

import java.awt.Color;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface ColorLogic {
    public static final Map<String, Integer> chromaticColors = Map.ofEntries(Map.entry("white", 0xFFFFFF), Map.entry("light_gray", 0x8F8F86), Map.entry("gray", 0x262F2F), Map.entry("black", 0), Map.entry("brown", 7025679), Map.entry("red", 0xA30300), Map.entry("orange", 16736768), Map.entry("yellow", 0xFFCC00), Map.entry("lime", 8371968), Map.entry("green", 4348928), Map.entry("cyan", 29308), Map.entry("light_blue", 2211562), Map.entry("blue", 1779090), Map.entry("purple", 6427810), Map.entry("magenta", 11676333), Map.entry("pink", 16746158));
    public static final int defaultChromatic = 9524443;
    public static final String[] vanillaColors = new String[]{"white", "light_gray", "gray", "black", "brown", "red", "orange", "yellow", "lime", "green", "light_blue", "blue", "cyan", "purple", "magenta", "pink"};
    public static final Map<TagKey<Block>, String> supportedBlockTypes = Map.ofEntries(Map.entry(BlockTags.f_13089_, "$_wool"), Map.entry(BlockTags.f_215838_, "$_carpet"));

    public static int getChromaticColor(DyeColor dye) {
        return chromaticColors.getOrDefault(dye.m_41065_(), 0xFFFFFF);
    }

    public static boolean matchesPureHue(int rgb, int pureHue) {
        Color c = new Color(rgb);
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        return Math.abs(hsb[0] * 360.0f - (float)pureHue) <= 1.0f && hsb[1] >= 1.0f && hsb[2] >= 1.0f;
    }

    public static Block getBlockByColor(String color, TagKey<Block> type) {
        return (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(supportedBlockTypes.get(type).replace("$", color)));
    }

    public static Block getBlockByColor(DyeColor color, TagKey<Block> type) {
        return ColorLogic.getBlockByColor(color.m_41065_(), type);
    }

    public static DyeColor getColorByState(BlockState state) {
        for (TagKey<Block> key : supportedBlockTypes.keySet()) {
            if (!state.m_204336_(key)) continue;
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
            return DyeColor.m_41057_((String)id.m_135815_().replace(supportedBlockTypes.get(key).replace("$", ""), ""), null);
        }
        return null;
    }

    public static boolean isSupported(BlockState state) {
        for (TagKey<Block> key : supportedBlockTypes.keySet()) {
            if (!state.m_204336_(key)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>> BlockState applyPropertyFrom(BlockState newState, BlockState oldState, Property<T> property) {
        return (BlockState)newState.m_263224_(property, oldState.m_61143_(property));
    }

    public static BlockState recolor(String color, BlockState state) {
        for (TagKey<Block> key : supportedBlockTypes.keySet()) {
            if (!state.m_204336_(key)) continue;
            BlockState newState = ColorLogic.getBlockByColor(color, key).m_49966_();
            for (Property property : state.m_61147_()) {
                newState = ColorLogic.applyPropertyFrom(newState, state, property);
            }
            return newState;
        }
        return null;
    }
}

